/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.windows.WindowsJavaIOSubstitutions;
import com.oracle.svm.core.windows.WindowsJavaNIOSubstitutions;
import com.oracle.svm.core.windows.WindowsJavaNetSubstitutions;
import com.oracle.svm.core.windows.headers.Jvm;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class WindowsNativeLibrarySupport
implements PlatformNativeLibrarySupport {
    static final String[] builtInPkgNatives = new String[]{"Java_com_sun_demo_jvmti_hprof", "Java_com_sun_java_util_jar_pack", "Java_com_sun_net_ssl", "Java_com_sun_nio_file", "Java_com_sun_security_cert_internal_x509", "Java_java_io", "Java_java_lang", "Java_java_math", "Java_java_net", "Java_java_nio", "Java_java_security", "Java_java_text", "Java_java_time", "Java_java_util", "Java_javax_net", "Java_javax_script", "Java_javax_security", "Java_jdk", "Java_sun_invoke", "Java_sun_launcher", "Java_sun_misc", "Java_sun_net", "Java_sun_nio", "Java_sun_reflect", "Java_sun_security", "Java_sun_text", "Java_sun_util", "Java_com_oracle_svm_core_jdk"};

    WindowsNativeLibrarySupport() {
    }

    static void initialize() {
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)new WindowsNativeLibrarySupport());
    }

    @Override
    public boolean initializeBuiltinLibraries() {
        if (!WindowsJavaNetSubstitutions.initIDs()) {
            return false;
        }
        if (!WindowsJavaIOSubstitutions.initIDs()) {
            return false;
        }
        return WindowsJavaNIOSubstitutions.initIDs();
    }

    @Override
    public WindowsNativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new WindowsNativeLibrary(canonical, builtIn);
    }

    @Override
    public PointerBase findBuiltinSymbol(String name) {
        try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
            Pointer builtinHandle = WinBase.GetModuleHandleA(WordFactory.nullPointer());
            PointerBase pointerBase = WinBase.GetProcAddress(builtinHandle, (PointerBase)symbol.get());
            return pointerBase;
        }
    }

    @Override
    public boolean isBuiltinPkgNative(String name) {
        if (name.startsWith("Java_")) {
            for (String str : builtInPkgNatives) {
                if (!name.startsWith(str)) continue;
                return true;
            }
        }
        return false;
    }

    class WindowsNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private Pointer dlhandle = (Pointer)WordFactory.nullPointer();

        WindowsNativeLibrary(String canonicalIdentifier, boolean builtin) {
            Jvm.initialize();
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
        }

        @Override
        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        @Override
        public boolean isBuiltin() {
            return this.builtin;
        }

        @Override
        public void load() {
            if (!this.builtin) {
                assert (this.dlhandle.isNull());
                String dllPath = this.canonicalIdentifier;
                CTypeConversion.CCharPointerHolder dllpathPin = CTypeConversion.toCString((CharSequence)dllPath);
                CCharPointer dllPathPtr = dllpathPin.get();
                this.dlhandle = WinBase.LoadLibraryA((PointerBase)dllPathPtr);
                if (this.dlhandle.isNull()) {
                    throw new UnsatisfiedLinkError(dllPath + ": " + WinBase.GetLastError());
                }
            }
        }

        @Override
        public PointerBase findSymbol(String name) {
            if (this.builtin) {
                PointerBase addr = WindowsNativeLibrarySupport.this.findBuiltinSymbol(name);
                return addr;
            }
            assert (this.dlhandle.isNonNull());
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                PointerBase addr;
                PointerBase pointerBase = addr = WinBase.GetProcAddress(this.dlhandle, (PointerBase)symbol.get());
                return pointerBase;
            }
        }
    }
}

