/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.windows.Target_sun_nio_fs_WindowsFileSystemProvider;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.spi.FileSystemProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.WINDOWS.class})
public final class WindowsJavaNIOSubstitutions {
    public static boolean initIDs() {
        return true;
    }

    @TargetClass(className="sun.nio.fs.Cancellable")
    @Platforms(value={Platform.WINDOWS.class})
    static final class Target_sun_nio_fs_Cancellable {
        @Alias
        @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Manual)
        private long pollingAddress;

        Target_sun_nio_fs_Cancellable() {
        }
    }

    @TargetClass(value=FileSystems.class)
    @Platforms(value={Platform.WINDOWS.class})
    static final class Target_java_nio_file_FileSystems {
        Target_java_nio_file_FileSystems() {
        }

        @Substitute
        static FileSystem getDefault() {
            if (Util_Target_java_nio_file_FileSystems.defaultFilesystem == null) {
                Target_sun_nio_fs_WindowsFileSystemProvider provider = KnownIntrinsics.unsafeCast(Util_Target_java_nio_file_FileSystems.defaultProvider, Target_sun_nio_fs_WindowsFileSystemProvider.class);
                try {
                    FileSystem fs;
                    Util_Target_java_nio_file_FileSystems.defaultFilesystem = fs = provider.getFileSystem(new URI("file:/"));
                }
                catch (Exception e) {
                    Log.log().string("Exception while getting default FileSystem: " + e);
                    return null;
                }
            }
            return Util_Target_java_nio_file_FileSystems.defaultFilesystem;
        }

        @Delete
        @TargetClass(value=FileSystems.class, innerClass={"DefaultFileSystemHolder"})
        static final class Target_java_nio_file_FileSystems_DefaultFileSystemHolder {
            Target_java_nio_file_FileSystems_DefaultFileSystemHolder() {
            }
        }
    }

    static final class Util_Target_java_nio_file_FileSystems {
        static FileSystemProvider defaultProvider = FileSystems.getDefault().provider();
        static FileSystem defaultFilesystem;

        Util_Target_java_nio_file_FileSystems() {
        }
    }
}

