/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class UserError {
    public static UserException abort(String message) {
        throw new UserException(message);
    }

    public static UserException abort(String message, Throwable ex) {
        StringWriter s = new StringWriter();
        Exception wrapper = new Exception(ex);
        wrapper.printStackTrace(new PrintWriter(s));
        String stackTrace = s.toString();
        int start = stackTrace.indexOf("Caused by:");
        if (start != -1) {
            stackTrace = stackTrace.substring(start);
        }
        throw UserError.abort(message + System.lineSeparator() + stackTrace);
    }

    public static void guarantee(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw UserError.abort(String.format(message, UserError.formatArguments(args)));
        }
    }

    private static Object[] formatArguments(Object ... args) {
        Object[] stringArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            stringArgs[i] = arg instanceof ResolvedJavaType ? ((ResolvedJavaType)arg).toJavaName(true) : (arg instanceof ResolvedJavaMethod ? ((ResolvedJavaMethod)arg).format("%H.%n(%p)") : (arg instanceof ResolvedJavaField ? ((ResolvedJavaField)arg).format("%H.%n") : String.valueOf(arg)));
        }
        return stringArgs;
    }

    public static UserException abort(Iterable<String> messages) {
        throw new UserException(messages);
    }

    public static class UserException
    extends Error {
        static final long serialVersionUID = 75431290632980L;
        private final Iterable<String> messages;

        protected UserException(String msg) {
            this(Collections.singletonList(msg));
        }

        protected UserException(Iterable<String> messages) {
            super(String.join((CharSequence)System.lineSeparator(), messages));
            this.messages = messages;
        }

        public Iterable<String> getMessages() {
            return this.messages;
        }
    }
}

