/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.posix.Java_lang_Process_Supplement;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Dlfcn;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Stdlib;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.impl.ProcessPropertiesSupport;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class PosixProcessPropertiesSupport
implements ProcessPropertiesSupport {
    public long getProcessID() {
        return PosixUtils.getpid();
    }

    public long getProcessID(Process process) {
        return PosixUtils.getpid(process);
    }

    public boolean destroy(long processID) {
        return Signal.kill(Math.toIntExact(processID), Signal.SignalEnum.SIGTERM.getCValue()) == 0;
    }

    public boolean destroyForcibly(long processID) {
        return Signal.kill(Math.toIntExact(processID), Signal.SignalEnum.SIGKILL.getCValue()) == 0;
    }

    public boolean isAlive(long processID) {
        return Signal.kill(Math.toIntExact(processID), 0) == 0;
    }

    public int waitForProcessExit(long processID) {
        return Java_lang_Process_Supplement.waitForProcessExit(Math.toIntExact(processID));
    }

    public String getObjectFile(String symbol) {
        return PosixProcessPropertiesSupport.getObjectPathDefiningSymbol(symbol);
    }

    public String getObjectFile(CEntryPointLiteral<?> symbol) {
        return PosixProcessPropertiesSupport.getObjectPathDefiningAddress((PointerBase)symbol.getFunctionPointer());
    }

    public String setLocale(String category, String locale) {
        return PosixUtils.setLocale(category, locale);
    }

    static String getObjectPathDefiningSymbol(String symbol) {
        try (CTypeConversion.CCharPointerHolder symbolHolder = CTypeConversion.toCString((CharSequence)symbol);){
            Object symbolAddress = Dlfcn.dlsym(Dlfcn.RTLD_DEFAULT(), symbolHolder.get());
            if (symbolAddress.isNull()) {
                String string = null;
                return string;
            }
            String string = PosixProcessPropertiesSupport.getObjectPathDefiningAddress(symbolAddress);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getObjectPathDefiningAddress(PointerBase symbolAddress) {
        Dlfcn.Dl_info info = (Dlfcn.Dl_info)StackValue.get(Dlfcn.Dl_info.class);
        if (Dlfcn.dladdr((WordBase)symbolAddress, info) == 0) {
            return null;
        }
        CCharPointer realpath = Stdlib.realpath(info.dli_fname(), (CCharPointer)WordFactory.nullPointer());
        if (realpath.isNull()) {
            return null;
        }
        try {
            String string = CTypeConversion.toJavaString((CCharPointer)realpath);
            return string;
        }
        finally {
            LibC.free((PointerBase)realpath);
        }
    }

    protected static String realpath(String path) {
        try (CTypeConversion.CCharPointerHolder pathHolder = CTypeConversion.toCString((CharSequence)path);){
            CCharPointer realpathPointer = Stdlib.realpath(pathHolder.get(), (CCharPointer)WordFactory.nullPointer());
            if (realpathPointer.isNull()) {
                String string = null;
                return string;
            }
            String result = CTypeConversion.toJavaString((CCharPointer)realpathPointer);
            LibC.free((PointerBase)realpathPointer);
            String string = result;
            return string;
        }
    }
}

