/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.jdk.JDKUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;

public class VMErrorSubstitutions {
    @Uninterruptible(reason="Allow use in uninterruptible code.", calleeMustBe=false)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate during printing diagnostics.")
    static void shutdown(String msg, Throwable ex) {
        Log log = Log.log();
        log.autoflush(true);
        log.string("VMError.shouldNotReachHere");
        if (msg != null) {
            log.string(": ").string(msg);
        }
        if (ex != null) {
            String detailMessage = JDKUtils.getRawMessage(ex);
            StackTraceElement[] stackTrace = JDKUtils.getRawStackTrace(ex);
            log.string(": ").string(ex.getClass().getName()).string(": ").string(detailMessage);
            if (stackTrace != null) {
                for (StackTraceElement element : stackTrace) {
                    if (element == null) continue;
                    log.newline();
                    log.string("    at ").string(element.getClassName()).string(".").string(element.getMethodName());
                    log.string("(").string(element.getFileName()).string(":").signed(element.getLineNumber()).string(")");
                }
            }
        }
        log.newline();
        VMErrorSubstitutions.doShutdown(log);
    }

    private static void doShutdown(Log log) {
        try {
            SubstrateUtil.printDiagnostics(log, KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
    }
}

