/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.word.PointerBase;

public interface PlatformNativeLibrarySupport {
    public static final List<String> defaultBuiltInLibraries = Collections.unmodifiableList(Arrays.asList("java", "nio", "net", "zip"));

    public static PlatformNativeLibrarySupport singleton() {
        return (PlatformNativeLibrarySupport)ImageSingletons.lookup(PlatformNativeLibrarySupport.class);
    }

    public NativeLibrary createLibrary(String var1, boolean var2);

    public PointerBase findBuiltinSymbol(String var1);

    default public boolean isBuiltinLibrary(String name) {
        return defaultBuiltInLibraries.contains(name);
    }

    public boolean isBuiltinPkgNative(String var1);

    public boolean initializeBuiltinLibraries();

    public static interface NativeLibrary {
        public String getCanonicalIdentifier();

        public boolean isBuiltin();

        public void load() throws UnsatisfiedLinkError;

        public PointerBase findSymbol(String var1);
    }
}

