/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.jdk.RuntimeFeature;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.jdk.SubstrateClassLoadingMXBean;
import com.oracle.svm.core.jdk.SubstrateCompilationMXBean;
import com.oracle.svm.core.jdk.SubstrateRuntimeMXBean;
import com.oracle.svm.core.jdk.SubstrateThreadMXBean;
import com.oracle.svm.core.util.UserError;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
final class ManagementFactoryFeature
implements Feature {
    ManagementFactoryFeature() {
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(RuntimeFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        access.registerObjectReplacer(ManagementFactoryFeature::replace);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        SubstrateRuntimeMXBean runtimeMXBean = new SubstrateRuntimeMXBean();
        ImageSingletons.add(RuntimeMXBean.class, (Object)runtimeMXBean);
        ImageSingletons.add(ThreadMXBean.class, (Object)new SubstrateThreadMXBean());
        ImageSingletons.add(ClassLoadingMXBean.class, (Object)new SubstrateClassLoadingMXBean());
        ImageSingletons.add(CompilationMXBean.class, (Object)new SubstrateCompilationMXBean());
        RuntimeSupport.getRuntimeSupport().addStartupHook(runtimeMXBean.startupHook());
    }

    private static Object replace(Object source) {
        if (source instanceof ThreadMXBean) {
            return ImageSingletons.lookup(ThreadMXBean.class);
        }
        if (source instanceof RuntimeMXBean) {
            return ImageSingletons.lookup(RuntimeMXBean.class);
        }
        if (source instanceof OperatingSystemMXBean) {
            return ImageSingletons.lookup(OperatingSystemMXBean.class);
        }
        if (source instanceof ClassLoadingMXBean) {
            return ImageSingletons.lookup(ClassLoadingMXBean.class);
        }
        if (source instanceof CompilationMXBean) {
            return ImageSingletons.lookup(CompilationMXBean.class);
        }
        if (source instanceof MemoryMXBean) {
            return Heap.getHeap().getMemoryMXBean();
        }
        if (source instanceof GarbageCollectorMXBean) {
            if (source.getClass().getName().equals("sun.management.GarbageCollectorImpl")) {
                if (((GarbageCollectorMXBean)source).getMemoryPoolNames().length == 2) {
                    GarbageCollectorMXBean incrementalBean = Heap.getHeap().getGC().getGarbageCollectorMXBeanList().get(0);
                    assert (incrementalBean.getName().equals("young generation scavenger"));
                    return incrementalBean;
                }
                if (((GarbageCollectorMXBean)source).getMemoryPoolNames().length == 3) {
                    GarbageCollectorMXBean completeBean = Heap.getHeap().getGC().getGarbageCollectorMXBeanList().get(1);
                    assert (completeBean.getName().equals("complete scavenger"));
                    return completeBean;
                }
                throw UserError.abort("Found " + source + " in image heap. Don't know to which Substrate VM GC bean to map.");
            }
            return source;
        }
        return source;
    }
}

