/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.FileSystemProviderSupport;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Map;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
public final class FileSystemProviderFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(FileSystemProviderSupport.class, (Object)new FileSystemProviderSupport());
        ArrayList<FileSystemProvider> providers = new ArrayList<FileSystemProvider>(FileSystemProvider.installedProviders());
        providers.removeIf(p -> p.getScheme().equals("jrt"));
        providers.forEach(p -> FileSystemProviderFeature.addFileSystemProvider(p));
    }

    public static void addFileSystemProvider(FileSystemProvider fileSystemProvider) {
        Map<String, FileSystemProvider> fileSystemProviders = ((FileSystemProviderSupport)ImageSingletons.lookup(FileSystemProviderSupport.class)).fileSystemProviders;
        fileSystemProviders.put(fileSystemProvider.getScheme(), fileSystemProvider);
    }
}

