/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.nodes.CEntryPointEnterNode;
import com.oracle.svm.core.graal.nodes.CEntryPointLeaveNode;
import com.oracle.svm.core.graal.nodes.CEntryPointUtilityNode;
import com.oracle.svm.core.graal.nodes.WriteCurrentVMThreadNode;
import com.oracle.svm.core.graal.nodes.WriteHeapBaseNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.core.stack.StackOverflowCheck;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.Safepoint;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.util.VMError;
import java.util.Map;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.LogHandler;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class CEntryPointSnippets
extends SubstrateTemplates
implements Snippets {
    public static final SnippetRuntime.SubstrateForeignCallDescriptor CREATE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "createIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor INITIALIZE_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "initializeIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ATTACH_THREAD = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "attachThread", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ENTER_ISOLATE_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "enterIsolateMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor DETACH_THREAD_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "detachThreadMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor REPORT_EXCEPTION = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "reportException", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor TEAR_DOWN_ISOLATE = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "tearDownIsolate", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor IS_ATTACHED_MT = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "isAttachedMT", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor FAIL_FATALLY = SnippetRuntime.findForeignCall(CEntryPointSnippets.class, "failFatally", false, LocationIdentity.any());
    public static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{CREATE_ISOLATE, INITIALIZE_ISOLATE, ATTACH_THREAD, ENTER_ISOLATE_MT, DETACH_THREAD_MT, REPORT_EXCEPTION, TEAR_DOWN_ISOLATE, IS_ATTACHED_MT, FAIL_FATALLY};

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, CEntryPointCreateIsolateParameters var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1, int var2);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, IsolateThread var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCall(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Throwable var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallInitializeIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int runtimeCallTearDownIsolate(@Node.ConstantNodeParameter ForeignCallDescriptor var0);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native boolean runtimeCallIsAttached(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Isolate var1);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void runtimeCallFailFatally(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, CCharPointer var2);

    @Fold
    static boolean hasHeapBase() {
        return ((CompressEncoding)ImageSingletons.lookup(CompressEncoding.class)).hasBase();
    }

    @Uninterruptible(reason="Called by an uninterruptible method.")
    public static void setHeapBase(PointerBase heapBase) {
        WriteHeapBaseNode.writeCurrentVMHeapBase(CEntryPointSnippets.hasHeapBase() ? heapBase : WordFactory.nullPointer());
    }

    @Snippet
    public static int createIsolateSnippet(CEntryPointCreateIsolateParameters parameters, @Snippet.ConstantParameter int vmThreadSize) {
        int result;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread(VMThreads.nullThread());
        }
        if ((result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)CREATE_ISOLATE, parameters, vmThreadSize)) != 0) {
            return result;
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Safepoint.transitionNativeToJava();
        }
        result = CEntryPointSnippets.runtimeCallInitializeIsolate(INITIALIZE_ISOLATE);
        return result;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget
    private static int createIsolate(CEntryPointCreateIsolateParameters parameters, int vmThreadSize) {
        WordPointer isolate = (WordPointer)StackValue.get(WordPointer.class);
        isolate.write((WordBase)WordFactory.nullPointer());
        int error = Isolates.create(isolate, parameters);
        if (error != 0) {
            return error;
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase((Isolate)isolate.read()));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && !VMThreads.ensureInitialized()) {
            return 11;
        }
        return CEntryPointSnippets.attachThread((Isolate)isolate.read(), vmThreadSize);
    }

    @SubstrateForeignCallTarget
    private static int initializeIsolate() {
        int result = 0;
        boolean success = PlatformNativeLibrarySupport.singleton().initializeBuiltinLibraries();
        if (!success) {
            return 13;
        }
        return result;
    }

    @Snippet
    public static int attachThreadSnippet(Isolate isolate, @Snippet.ConstantParameter int vmThreadSize) {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread(VMThreads.nullThread());
        }
        int result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)ATTACH_THREAD, isolate, vmThreadSize);
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue() && result == 0) {
            Safepoint.transitionNativeToJava();
        }
        return result;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget
    private static int attachThread(Isolate isolate, int vmThreadSize) {
        int sanityError = Isolates.checkSanity(isolate);
        if (sanityError != 0) {
            return sanityError;
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (!VMThreads.isInitialized()) {
                return 5;
            }
            IsolateThread thread = VMThreads.singleton().findIsolateThreadforCurrentOSThread();
            if (VMThreads.isNullThread(thread)) {
                thread = VMThreads.singleton().allocateIsolateThread(vmThreadSize);
                StackOverflowCheck.singleton().initialize(thread);
                VMThreads.singleton().attachThread(thread);
                VMThreads.IsolateTL.set(thread, isolate);
            }
            WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        } else {
            StackOverflowCheck.singleton().initialize((IsolateThread)WordFactory.nullPointer());
        }
        return 0;
    }

    @Snippet
    public static int detachThreadSnippet() {
        int result = 0;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            IsolateThread thread = CurrentIsolate.getCurrentThread();
            result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)DETACH_THREAD_MT, thread);
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            WriteHeapBaseNode.writeCurrentVMHeapBase(WordFactory.nullPointer());
        }
        return result;
    }

    @SubstrateForeignCallTarget
    @Uninterruptible(reason="Thread state going away.")
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not (thread-local) allocate while detaching a thread.")
    private static int detachThreadMT(IsolateThread thread) {
        int result = 0;
        VMThreads.StatusSupport.setStatusIgnoreSafepoints();
        VMThreads.THREAD_MUTEX.lockNoTransition();
        try {
            CEntryPointSnippets.detachJavaLangThreadMT(thread);
            WriteCurrentVMThreadNode.writeCurrentVMThread(VMThreads.nullThread());
            VMThreads.detachThread(thread);
        }
        catch (Throwable t) {
            result = 12;
        }
        finally {
            VMThreads.THREAD_MUTEX.unlock();
            VMThreads.singleton().freeIsolateThread(thread);
        }
        return result;
    }

    @Uninterruptible(reason="For calling interruptible code from uninterruptible code.", callerMustBe=true, mayBeInlined=true, calleeMustBe=false)
    private static void detachJavaLangThreadMT(IsolateThread thread) {
        JavaThreads.detachThread(thread);
    }

    @Snippet
    public static int tearDownIsolateSnippet() {
        return CEntryPointSnippets.runtimeCallTearDownIsolate(TEAR_DOWN_ISOLATE);
    }

    @SubstrateForeignCallTarget
    private static int tearDownIsolate() {
        try {
            RuntimeSupport.executeTearDownHooks();
            if (!JavaThreads.singleton().tearDownVM()) {
                return 1;
            }
            return Isolates.tearDownCurrent();
        }
        catch (Throwable t) {
            CEntryPointSnippets.logException(t);
            return 12;
        }
    }

    @Snippet
    public static int enterIsolateSnippet(Isolate isolate) {
        int result;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            WriteCurrentVMThreadNode.writeCurrentVMThread(VMThreads.nullThread());
            result = CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)ENTER_ISOLATE_MT, isolate);
            if (result == 0) {
                Safepoint.transitionNativeToJava();
            }
        } else {
            result = Isolates.checkSanity(isolate);
            if (result == 0 && SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
            }
        }
        return result;
    }

    @Uninterruptible(reason="Thread state not set up yet")
    @SubstrateForeignCallTarget
    private static int enterIsolateMT(Isolate isolate) {
        int sanityError = Isolates.checkSanity(isolate);
        if (sanityError != 0) {
            return sanityError;
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (!VMThreads.isInitialized()) {
            return 5;
        }
        IsolateThread thread = VMThreads.singleton().findIsolateThreadforCurrentOSThread();
        if (VMThreads.isNullThread(thread)) {
            return 4;
        }
        WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
        return 0;
    }

    @Snippet
    public static int enterSnippet(IsolateThread thread) {
        Isolate isolate;
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            if (thread.isNull()) {
                return 2;
            }
            WriteCurrentVMThreadNode.writeCurrentVMThread(thread);
            isolate = VMThreads.IsolateTL.get(thread);
        } else {
            if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
                if (thread.isNull()) {
                    return 2;
                }
            } else if (!thread.equal((ComparableWord)CEntryPointSetup.SINGLE_THREAD_SENTINEL)) {
                return 4;
            }
            isolate = (Isolate)((Word)thread).subtract(1575);
        }
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            Safepoint.transitionNativeToJava();
        }
        return 0;
    }

    @Snippet
    public static int reportExceptionSnippet(Throwable exception) {
        return CEntryPointSnippets.runtimeCall((ForeignCallDescriptor)REPORT_EXCEPTION, exception);
    }

    @SubstrateForeignCallTarget
    private static int reportException(Throwable exception) {
        CEntryPointSnippets.logException(exception);
        ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
        return 1;
    }

    private static void logException(Throwable exception) {
        String detail;
        Log.log().string(exception.getClass().getName());
        if (!NoAllocationVerifier.isActive() && (detail = exception.getMessage()) != null) {
            Log.log().string(": ").string(detail);
        }
        Log.log().newline();
    }

    @Snippet
    public static int returnFromJavaToCSnippet() {
        if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            VMThreads.StatusSupport.setStatusNative();
        }
        return 0;
    }

    @Snippet
    public static boolean isAttachedSnippet(Isolate isolate) {
        return Isolates.checkSanity(isolate) == 0 && (SubstrateOptions.MultiThreaded.getValue() == false || CEntryPointSnippets.runtimeCallIsAttached(IS_ATTACHED_MT, isolate));
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    @SubstrateForeignCallTarget
    private static boolean isAttachedMT(Isolate isolate) {
        if (SubstrateOptions.SpawnIsolates.getValue().booleanValue()) {
            CEntryPointSnippets.setHeapBase(Isolates.getHeapBase(isolate));
        }
        return VMThreads.isInitialized() && VMThreads.singleton().findIsolateThreadforCurrentOSThread().isNonNull();
    }

    @Snippet
    public static void failFatallySnippet(int code, CCharPointer message) {
        CEntryPointSnippets.runtimeCallFailFatally(FAIL_FATALLY, code, message);
    }

    @Uninterruptible(reason="Unknown thread state.")
    @SubstrateForeignCallTarget
    private static void failFatally(int code, CCharPointer message) {
        VMThreads.singleton().failFatally(code, message);
    }

    public static void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
        for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : FOREIGN_CALLS) {
            foreignCalls.put(descriptor, new SubstrateForeignCallLinkage(providers, descriptor));
        }
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, int vmThreadSize, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new CEntryPointSnippets(options, factories, providers, snippetReflection, vmThreadSize, lowerings);
    }

    private CEntryPointSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, int vmThreadSize, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(CEntryPointEnterNode.class, new EnterLowering(vmThreadSize));
        lowerings.put(CEntryPointLeaveNode.class, new LeaveLowering());
        lowerings.put(CEntryPointUtilityNode.class, new UtilityLowering());
    }

    protected class UtilityLowering
    implements NodeLoweringProvider<CEntryPointUtilityNode> {
        private final SnippetTemplate.SnippetInfo isAttached;
        private final SnippetTemplate.SnippetInfo failFatally;

        protected UtilityLowering() {
            this.isAttached = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "isAttachedSnippet", new LocationIdentity[0]);
            this.failFatally = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "failFatallySnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(CEntryPointUtilityNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            switch (node.getUtilityAction()) {
                case IsAttached: {
                    args = new SnippetTemplate.Arguments(this.isAttached, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter0());
                    break;
                }
                case FailFatally: {
                    args = new SnippetTemplate.Arguments(this.failFatally, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("code", (Object)node.getParameter0());
                    args.add("message", (Object)node.getParameter1());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            CEntryPointSnippets.this.template((ValueNode)node, args).instantiate(CEntryPointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class LeaveLowering
    implements NodeLoweringProvider<CEntryPointLeaveNode> {
        private final SnippetTemplate.SnippetInfo returnFromJavaToC;
        private final SnippetTemplate.SnippetInfo detachThread;
        private final SnippetTemplate.SnippetInfo reportException;
        private final SnippetTemplate.SnippetInfo tearDownIsolate;

        protected LeaveLowering() {
            this.returnFromJavaToC = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "returnFromJavaToCSnippet", new LocationIdentity[0]);
            this.detachThread = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "detachThreadSnippet", new LocationIdentity[0]);
            this.reportException = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "reportExceptionSnippet", new LocationIdentity[0]);
            this.tearDownIsolate = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "tearDownIsolateSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(CEntryPointLeaveNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            switch (node.getLeaveAction()) {
                case Leave: {
                    args = new SnippetTemplate.Arguments(this.returnFromJavaToC, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case DetachThread: {
                    args = new SnippetTemplate.Arguments(this.detachThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case TearDownIsolate: {
                    args = new SnippetTemplate.Arguments(this.tearDownIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    break;
                }
                case ExceptionAbort: {
                    args = new SnippetTemplate.Arguments(this.reportException, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("exception", (Object)node.getException());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            CEntryPointSnippets.this.template((ValueNode)node, args).instantiate(CEntryPointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class EnterLowering
    implements NodeLoweringProvider<CEntryPointEnterNode> {
        private final SnippetTemplate.SnippetInfo createIsolate;
        private final SnippetTemplate.SnippetInfo attachThread;
        private final SnippetTemplate.SnippetInfo enter;
        private final SnippetTemplate.SnippetInfo enterThreadFromTL;
        private final int vmThreadSize;

        EnterLowering(int vmThreadSize) {
            this.createIsolate = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "createIsolateSnippet", new LocationIdentity[0]);
            this.attachThread = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "attachThreadSnippet", new LocationIdentity[0]);
            this.enter = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "enterSnippet", new LocationIdentity[0]);
            this.enterThreadFromTL = CEntryPointSnippets.this.snippet(CEntryPointSnippets.class, "enterIsolateSnippet", new LocationIdentity[0]);
            this.vmThreadSize = vmThreadSize;
        }

        @Override
        public void lower(CEntryPointEnterNode node, LoweringTool tool) {
            SnippetTemplate.Arguments args;
            switch (node.getEnterAction()) {
                case CreateIsolate: {
                    args = new SnippetTemplate.Arguments(this.createIsolate, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("parameters", (Object)node.getParameter());
                    args.addConst("vmThreadSize", (Object)this.vmThreadSize);
                    break;
                }
                case AttachThread: {
                    args = new SnippetTemplate.Arguments(this.attachThread, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    args.addConst("vmThreadSize", (Object)this.vmThreadSize);
                    break;
                }
                case EnterIsolate: {
                    args = new SnippetTemplate.Arguments(this.enterThreadFromTL, node.graph().getGuardsStage(), tool.getLoweringStage());
                    args.add("isolate", (Object)node.getParameter());
                    break;
                }
                case Enter: {
                    args = new SnippetTemplate.Arguments(this.enter, node.graph().getGuardsStage(), tool.getLoweringStage());
                    assert (node.getParameter() != null);
                    args.add("thread", (Object)node.getParameter());
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            CEntryPointSnippets.this.template((ValueNode)node, args).instantiate(CEntryPointSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

