/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.genscavenge.MemoryMXBeanMemoryVisitor;
import com.oracle.svm.core.option.RuntimeOptionValues;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import javax.management.ObjectName;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import sun.management.Util;

final class HeapImplMemoryMXBean
implements MemoryMXBean {
    static final long UNDEFINED_MEMORY_USAGE = -1L;
    private final MemoryMXBeanMemoryVisitor visitor = new MemoryMXBeanMemoryVisitor();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    HeapImplMemoryMXBean() {
    }

    @Override
    public ObjectName getObjectName() {
        return Util.newObjectName("java.lang:type=Memory");
    }

    @Override
    public int getObjectPendingFinalizationCount() {
        return 0;
    }

    @Override
    public MemoryUsage getHeapMemoryUsage() {
        this.visitor.reset();
        MemoryWalker.getMemoryWalker().visitMemory(this.visitor);
        long used = this.visitor.getHeapUsed().rawValue();
        long committed = this.visitor.getHeapCommitted().rawValue();
        return new MemoryUsage(-1L, used, committed, -1L);
    }

    @Override
    public MemoryUsage getNonHeapMemoryUsage() {
        this.visitor.reset();
        MemoryWalker.getMemoryWalker().visitMemory(this.visitor);
        long used = this.visitor.getNonHeapUsed().rawValue();
        long committed = this.visitor.getNonHeapCommitted().rawValue();
        return new MemoryUsage(-1L, used, committed, -1L);
    }

    @Override
    public boolean isVerbose() {
        return SubstrateOptions.PrintGC.getValue();
    }

    @Override
    public void setVerbose(boolean value) {
        RuntimeOptionValues.singleton().update(SubstrateOptions.PrintGC, value);
    }

    @Override
    public void gc() {
        System.gc();
    }
}

