/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GCImpl;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunkProvider;
import com.oracle.svm.core.genscavenge.HeapImplMemoryMXBean;
import com.oracle.svm.core.genscavenge.HeapOptions;
import com.oracle.svm.core.genscavenge.HeapPolicy;
import com.oracle.svm.core.genscavenge.HeapPolicyOptions;
import com.oracle.svm.core.genscavenge.HeapVerifier;
import com.oracle.svm.core.genscavenge.HeapVerifierImpl;
import com.oracle.svm.core.genscavenge.ObjectHeaderImpl;
import com.oracle.svm.core.genscavenge.OldGeneration;
import com.oracle.svm.core.genscavenge.PinnedAllocatorImpl;
import com.oracle.svm.core.genscavenge.PinnedObjectImpl;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.StackVerifier;
import com.oracle.svm.core.genscavenge.ThreadLocalAllocation;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.genscavenge.YoungGeneration;
import com.oracle.svm.core.heap.GC;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.NativeImageInfo;
import com.oracle.svm.core.heap.NoAllocationVerifier;
import com.oracle.svm.core.heap.ObjectHeader;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.heap.PinnedAllocator;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.LayoutEncoding;
import com.oracle.svm.core.jdk.UninterruptibleUtils;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.util.VMError;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public class HeapImpl
extends Heap {
    PinnedAllocatorImpl pinnedAllocatorListHead;
    private final YoungGeneration youngGeneration = new YoungGeneration("YoungGeneration");
    private final OldGeneration oldGeneration = new OldGeneration("OldGeneration");
    final HeapChunkProvider chunkProvider;
    private final MemoryMXBean memoryMXBean;
    private List<Class<?>> classList;
    private final ObjectVisitorWalkerOperation objectVisitorWalkerOperation;
    private final ObjectHeaderImpl objectHeaderImpl;
    private final GCImpl gcImpl;
    private final HeapPolicy heapPolicy;
    private UninterruptibleUtils.AtomicReference<PinnedObjectImpl> pinHead;
    private HeapVerifierImpl heapVerifier;
    private final StackVerifier stackVerifier;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public HeapImpl(Feature.FeatureAccess access) {
        this.gcImpl = new GCImpl(access);
        this.objectHeaderImpl = new ObjectHeaderImpl();
        this.heapPolicy = new HeapPolicy(access);
        this.pinHead = new UninterruptibleUtils.AtomicReference();
        if (HeapImpl.getVerifyHeapBeforeGC() || HeapImpl.getVerifyHeapAfterGC() || HeapImpl.getVerifyStackBeforeGC() || HeapImpl.getVerifyStackAfterGC()) {
            this.heapVerifier = HeapVerifierImpl.factory();
            this.stackVerifier = new StackVerifier();
        } else {
            this.heapVerifier = null;
            this.stackVerifier = null;
        }
        this.chunkProvider = new HeapChunkProvider();
        this.pinnedAllocatorListHead = null;
        this.objectVisitorWalkerOperation = new ObjectVisitorWalkerOperation();
        this.memoryMXBean = new HeapImplMemoryMXBean();
        this.classList = null;
        SubstrateUtil.DiagnosticThunkRegister.getSingleton().register(() -> {
            this.bootImageHeapBoundariesToLog(Log.log()).newline();
            this.zapValuesToLog(Log.log()).newline();
            this.report(Log.log(), true).newline();
            Log.log().newline();
        });
    }

    @Fold
    public static HeapImpl getHeapImpl() {
        Heap heap = Heap.getHeap();
        assert (heap instanceof HeapImpl) : "VMConfiguration heap is not a HeapImpl.";
        return (HeapImpl)heap;
    }

    @Override
    public void suspendAllocation() {
        ThreadLocalAllocation.suspendThreadLocalAllocation();
    }

    @Override
    public void resumeAllocation() {
        ThreadLocalAllocation.resumeThreadLocalAllocation();
    }

    @Override
    public void disableAllocation(IsolateThread vmThread) {
        ThreadLocalAllocation.disableThreadLocalAllocation(vmThread);
    }

    @Override
    public PinnedAllocator createPinnedAllocator() {
        return new PinnedAllocatorImpl();
    }

    private ObjectVisitorWalkerOperation getObjectVisitorWalkerOperation() {
        return this.objectVisitorWalkerOperation;
    }

    @Override
    public void walkObjects(ObjectVisitor visitor) {
        try (ObjectVisitorWalkerOperation operation = this.getObjectVisitorWalkerOperation().open(visitor);){
            operation.enqueue();
        }
    }

    private void doWalkObjects(ObjectVisitor visitor) {
        if (!NativeImageInfo.walkNativeImageHeap(visitor)) {
            return;
        }
        if (!this.getYoungGeneration().walkObjects(visitor)) {
            return;
        }
        if (!this.getOldGeneration().walkObjects(visitor)) {
            return;
        }
    }

    public boolean walkHeap(MemoryWalker.Visitor visitor) {
        boolean result = true;
        if (result) {
            result = NativeImageInfo.walkNativeImageHeap(visitor);
        }
        if (result) {
            boolean bl = result = this.getYoungGeneration().walkHeapChunks(visitor) && this.getOldGeneration().walkHeapChunks(visitor);
        }
        if (result) {
            result = HeapChunkProvider.get().walkHeapChunks(visitor);
        }
        return result;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public final void tearDown() {
        this.youngGeneration.tearDown();
        this.oldGeneration.tearDown();
        HeapChunkProvider.get().tearDown();
    }

    @Override
    public ObjectHeader getObjectHeader() {
        return this.getObjectHeaderImpl();
    }

    public ObjectHeaderImpl getObjectHeaderImpl() {
        return this.objectHeaderImpl;
    }

    @Override
    public GC getGC() {
        return this.getGCImpl();
    }

    public GCImpl getGCImpl() {
        return this.gcImpl;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean isAllocationDisallowed() {
        return NoAllocationVerifier.isActive() || this.gcImpl.collectionInProgress.getState();
    }

    static void exitIfAllocationDisallowed(String callSite, String typeName) {
        if (HeapImpl.getHeapImpl().isAllocationDisallowed()) {
            NoAllocationVerifier.exit(callSite, typeName);
        }
    }

    final Space getAllocationSpace() {
        return this.getYoungGeneration().getSpace();
    }

    public HeapChunk.Header<?> getEnclosingHeapChunk(Object obj) {
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isAlignedObject(obj)) {
            return AlignedHeapChunk.getEnclosingAlignedHeapChunk(obj);
        }
        if (ohi.isUnalignedObject(obj)) {
            return UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(obj);
        }
        try (Log failure = Log.log().string("[HeapImpl.getEnclosingHeapChunk:");){
            failure.string("  obj: ").hex((WordBase)Word.objectToUntrackedPointer((Object)obj));
            UnsignedWord header = ObjectHeaderImpl.readHeaderFromObjectCarefully(obj);
            failure.string("  header: ").hex((WordBase)header).string("  is neither aligned nor unaligned").newline();
            failure.string("  obj: ").object(obj).string("]").newline();
        }
        throw VMError.shouldNotReachHere();
    }

    public Object promoteObject(Object original) {
        Log trace = Log.noopLog().string("[HeapImpl.promoteObject:").string("  original: ").object(original);
        OldGeneration oldGen = this.getOldGeneration();
        Object result = oldGen.promoteObject(original);
        trace.string("  result: ").object(result).string("]").newline();
        return result;
    }

    boolean hasSurvivedThisCollection(Object obj) {
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isBootImage(obj)) {
            return true;
        }
        if (ohi.isHeapAllocated(obj)) {
            OldGeneration oldGen;
            HeapChunk.Header<?> chunk = this.getEnclosingHeapChunk(obj);
            Space space = chunk.getSpace();
            return space == (oldGen = this.getOldGeneration()).getToSpace() || space == oldGen.getPinnedToSpace();
        }
        return false;
    }

    public HeapPolicy getHeapPolicy() {
        return HeapImpl.getHeapImpl().heapPolicy;
    }

    public boolean isYoungGeneration(Space space) {
        return this.getYoungGeneration().isYoungSpace(space);
    }

    public YoungGeneration getYoungGeneration() {
        return this.youngGeneration;
    }

    public OldGeneration getOldGeneration() {
        return this.oldGeneration;
    }

    public UninterruptibleUtils.AtomicReference<PinnedObjectImpl> getPinHead() {
        return this.pinHead;
    }

    public boolean isPinned(Object instance) {
        UnalignedHeapChunk.UnalignedHeader uChunk;
        AlignedHeapChunk.AlignedHeader aChunk;
        Space space;
        UnsignedWord headerBits;
        ObjectHeaderImpl ohi = this.getObjectHeaderImpl();
        if (ohi.isBootImageHeaderBits(headerBits = ObjectHeaderImpl.readHeaderBitsFromObject(instance))) {
            return true;
        }
        Space pinnedFromSpace = this.getOldGeneration().getPinnedFromSpace();
        Space pinnedToSpace = this.getOldGeneration().getPinnedToSpace();
        if (ohi.isAlignedHeader(headerBits) && ((space = (aChunk = AlignedHeapChunk.getEnclosingAlignedHeapChunk(instance)).getSpace()) == pinnedFromSpace || space == pinnedToSpace)) {
            return true;
        }
        if (ohi.isUnalignedHeader(headerBits) && ((space = (uChunk = UnalignedHeapChunk.getEnclosingUnalignedHeapChunk(instance)).getSpace()) == pinnedFromSpace || space == pinnedToSpace)) {
            return true;
        }
        for (PinnedObjectImpl pinnedObject = this.getPinHead().get(); pinnedObject != null; pinnedObject = pinnedObject.getNext()) {
            if (instance != pinnedObject.getObject()) continue;
            return true;
        }
        return false;
    }

    public boolean isImageHeapObject(Object obj) {
        return NativeImageInfo.isObjectInReadOnlyPrimitivePartition(obj) || NativeImageInfo.isObjectInReadOnlyReferencePartition(obj) || NativeImageInfo.isObjectInWritablePrimitivePartition(obj) || NativeImageInfo.isObjectInWritableReferencePartition(obj);
    }

    UnsignedWord getUsedChunkBytes() {
        UnsignedWord youngBytes = this.getYoungUsedChunkBytes();
        UnsignedWord oldBytes = this.getOldUsedChunkBytes();
        return youngBytes.add(oldBytes);
    }

    UnsignedWord getYoungUsedChunkBytes() {
        Space.Accounting young = this.getYoungGeneration().getSpace().getAccounting();
        return young.getAlignedChunkBytes().add(young.getUnalignedChunkBytes());
    }

    UnsignedWord getOldUsedChunkBytes() {
        Log trace = Log.noopLog().string("[HeapImpl.getOldUsedChunkBytes:");
        Space.Accounting from = this.getOldGeneration().getFromSpace().getAccounting();
        UnsignedWord fromBytes = from.getAlignedChunkBytes().add(from.getUnalignedChunkBytes());
        Space.Accounting to = this.getOldGeneration().getToSpace().getAccounting();
        UnsignedWord toBytes = to.getAlignedChunkBytes().add(to.getUnalignedChunkBytes());
        Space.Accounting pinnedFrom = this.getOldGeneration().getPinnedFromSpace().getAccounting();
        UnsignedWord pinnedFromBytes = pinnedFrom.getAlignedChunkBytes().add(pinnedFrom.getUnalignedChunkBytes());
        Space.Accounting pinnedTo = this.getOldGeneration().getPinnedFromSpace().getAccounting();
        UnsignedWord pinnedToBytes = pinnedTo.getAlignedChunkBytes().add(pinnedTo.getUnalignedChunkBytes());
        UnsignedWord result = fromBytes.add(toBytes).add(pinnedFromBytes).add(pinnedToBytes);
        if (trace.isEnabled()) {
            trace.string("  fromAligned: ").unsigned((WordBase)from.getAlignedChunkBytes()).string("  fromUnaligned: ").signed((WordBase)from.getUnalignedChunkBytes()).string("  toAligned: ").unsigned((WordBase)to.getAlignedChunkBytes()).string("  toUnaligned: ").signed((WordBase)to.getUnalignedChunkBytes()).string("  pinnedFromAligned: ").unsigned((WordBase)pinnedFrom.getAlignedChunkBytes()).string("  pinnedFromUnaligned: ").signed((WordBase)pinnedFrom.getUnalignedChunkBytes()).string("  pinnedToAligned: ").unsigned((WordBase)pinnedTo.getAlignedChunkBytes()).string("  pinnedToUnaligned: ").signed((WordBase)pinnedTo.getUnalignedChunkBytes()).string("  returns: ").unsigned((WordBase)result).string(" ]").newline();
        }
        return result;
    }

    public UnsignedWord getUsedObjectBytes() {
        Space youngSpace = this.getYoungGeneration().getSpace();
        UnsignedWord youngBytes = youngSpace.getObjectBytes();
        Space fromSpace = this.getOldGeneration().getFromSpace();
        UnsignedWord fromBytes = fromSpace.getObjectBytes();
        Space pinnedSpace = this.getOldGeneration().getPinnedFromSpace();
        UnsignedWord pinnedBytes = pinnedSpace.getObjectBytes();
        UnsignedWord result = youngBytes.add(fromBytes).add(pinnedBytes);
        return result;
    }

    protected void report(Log log) {
        this.report(log, HeapPolicyOptions.TraceHeapChunks.getValue());
    }

    public Log report(Log log, boolean traceHeapChunks) {
        HeapImpl heap = HeapImpl.getHeapImpl();
        log.newline().string("[Heap:").indent(true);
        heap.getYoungGeneration().report(log, traceHeapChunks).newline();
        heap.getOldGeneration().report(log, traceHeapChunks).newline();
        HeapChunkProvider.get().report(log, traceHeapChunks);
        log.redent(false).string("]");
        return log;
    }

    Log bootImageHeapBoundariesToLog(Log log) {
        log.string("[Native image heap boundaries: ").indent(true);
        log.string("ReadOnly Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.firstReadOnlyPrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.lastReadOnlyPrimitiveObject)).newline();
        log.string("ReadOnly References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.firstReadOnlyReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.lastReadOnlyReferenceObject)).newline();
        log.string("Writable Primitives: ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.firstWritablePrimitiveObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.lastWritablePrimitiveObject)).newline();
        log.string("Writable References: ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.firstWritableReferenceObject)).string(" .. ").hex((WordBase)Word.objectToUntrackedPointer((Object)NativeImageInfo.lastWritableReferenceObject));
        log.redent(false).string("]");
        return log;
    }

    Log zapValuesToLog(Log log) {
        if (HeapPolicy.getZapProducedHeapChunks() || HeapPolicy.getZapConsumedHeapChunks()) {
            log.string("[Heap Chunk zap values: ").indent(true);
            if (HeapPolicy.getZapProducedHeapChunks()) {
                log.string("  producedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getProducedHeapChunkZapInt()).string("  signed: ").spaces(9).signed(HeapPolicy.getProducedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getProducedHeapChunkZapInt()).newline();
                log.string("  producedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getProducedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getProducedHeapChunkZapWord());
                if (HeapPolicy.getZapConsumedHeapChunks()) {
                    log.newline();
                }
            }
            if (HeapPolicy.getZapConsumedHeapChunks()) {
                log.string("  consumedHeapChunkZapInt: ").string("  hex: ").spaces(8).hex(HeapPolicy.getConsumedHeapChunkZapInt()).string("  signed: ").spaces(10).signed(HeapPolicy.getConsumedHeapChunkZapInt()).string("  unsigned: ").spaces(10).unsigned(HeapPolicy.getConsumedHeapChunkZapInt()).newline();
                log.string("  consumedHeapChunkZapWord:").string("  hex: ").hex((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  signed: ").signed((WordBase)HeapPolicy.getConsumedHeapChunkZapWord()).string("  unsigned: ").unsigned((WordBase)HeapPolicy.getConsumedHeapChunkZapWord());
            }
            log.redent(false).string("]");
        }
        return log;
    }

    @Override
    public MemoryMXBean getMemoryMXBean() {
        return this.memoryMXBean;
    }

    @Override
    public List<Class<?>> getClassList() {
        if (this.classList == null) {
            ArrayList<Class> list = new ArrayList<Class>(1024);
            Object firstObject = NativeImageInfo.firstReadOnlyReferenceObject;
            Object lastObject = NativeImageInfo.lastReadOnlyReferenceObject;
            Word firstPointer = Word.objectToUntrackedPointer((Object)firstObject);
            Word lastPointer = Word.objectToUntrackedPointer((Object)lastObject);
            Word currentPointer = firstPointer;
            while (currentPointer.belowOrEqual((UnsignedWord)lastPointer)) {
                Object currentObject = KnownIntrinsics.convertUnknownValue(currentPointer.toObject(), Object.class);
                if (currentObject instanceof Class) {
                    Class asClass = (Class)currentObject;
                    list.add(asClass);
                }
                currentPointer = LayoutEncoding.getObjectEnd(currentObject);
            }
            this.classList = Collections.unmodifiableList(list);
        }
        return this.classList;
    }

    HeapVerifier getHeapVerifier() {
        return this.getHeapVerifierImpl();
    }

    public HeapVerifierImpl getHeapVerifierImpl() {
        return this.heapVerifier;
    }

    void setHeapVerifierImpl(HeapVerifierImpl value) {
        this.heapVerifier = value;
    }

    @Fold
    static boolean getVerifyHeapBeforeGC() {
        return HeapOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyHeapAfterGC() {
        return HeapOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyHeapAfterCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackBeforeGC() {
        return HeapOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackBeforeCollection.getValue() != false;
    }

    @Fold
    static boolean getVerifyStackAfterGC() {
        return HeapOptions.VerifyHeap.getValue() != false || HeapOptions.VerifyStackAfterCollection.getValue() != false;
    }

    void verifyBeforeGC(String cause, UnsignedWord epoch) {
        Log trace = Log.noopLog().string("[HeapImpl.verifyBeforeGC:");
        trace.string("  getVerifyHeapBeforeGC(): ").bool(HeapImpl.getVerifyHeapBeforeGC()).string("  heapVerifier: ").object(this.heapVerifier);
        trace.string("  getVerifyStackBeforeGC(): ").bool(HeapImpl.getVerifyStackBeforeGC()).string("  stackVerifier: ").object(this.stackVerifier);
        if (HeapImpl.getVerifyHeapBeforeGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("before collection", HeapVerifier.Occasion.BEFORE_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  heap fails to verify before epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackBeforeGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress(), "before collection")) {
                Log.log().string("[HeapImpl.verifyBeforeGC:").string("  cause: ").string(cause).string("  stack fails to verify epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        trace.string("]").newline();
    }

    void verifyAfterGC(String cause, UnsignedWord epoch) {
        if (HeapImpl.getVerifyHeapAfterGC()) {
            assert (this.heapVerifier != null) : "No heap verifier!";
            if (!this.heapVerifier.verifyOperation("after collection", HeapVerifier.Occasion.AFTER_COLLECTION)) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  heap fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
        if (HeapImpl.getVerifyStackAfterGC()) {
            assert (this.stackVerifier != null) : "No stack verifier!";
            if (!this.stackVerifier.verifyInAllThreads(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress(), "after collection")) {
                Log.log().string("[HeapImpl.verifyAfterGC:").string("  cause: ").string(cause).string("  stack fails to verify after epoch: ").unsigned((WordBase)epoch).string("]").newline();
                assert (false);
            }
        }
    }

    public boolean assertHub(DynamicHub hub) {
        return NativeImageInfo.isObjectInReadOnlyReferencePartition(hub);
    }

    public boolean assertHubOfObject(Object obj) {
        DynamicHub hub = ObjectHeader.readDynamicHubFromObject(obj);
        return this.assertHub(hub);
    }

    public boolean isValidSpace(Space space) {
        return this.getYoungGeneration().isValidSpace(space) || this.getOldGeneration().isValidSpace(space);
    }

    public UnsignedWord freeMemory() {
        return this.maxMemory().subtract(HeapPolicy.getBytesAllocatedSinceLastCollection()).subtract(this.getOldUsedChunkBytes());
    }

    public UnsignedWord totalMemory() {
        return this.maxMemory();
    }

    public UnsignedWord maxMemory() {
        PhysicalMemory.size();
        return HeapPolicy.getMaximumHeapSize();
    }

    static class ObjectVisitorWalkerOperation
    extends VMOperation
    implements AutoCloseable {
        private ObjectVisitor visitor = null;

        ObjectVisitorWalkerOperation() {
            super("ObjectVisitorWalker", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT);
        }

        ObjectVisitorWalkerOperation open(ObjectVisitor value) {
            this.visitor = value;
            return this;
        }

        @Override
        public void operate() {
            assert (this.visitor != null) : "HeapImpl.ObjectVisitorWalkerOperation.operate: null visitor";
            HeapImpl.getHeapImpl().doWalkObjects(this.visitor);
        }

        @Override
        public void close() {
            this.visitor = null;
        }
    }
}

