/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.code.CodeInfoDecoderCounters;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;

class CodeInfoDecoder {
    @UnknownObjectField(types={byte[].class})
    protected byte[] codeInfoIndex;
    @UnknownObjectField(types={byte[].class})
    protected byte[] codeInfoEncodings;
    @UnknownObjectField(types={byte[].class})
    protected byte[] referenceMapEncoding;
    @UnknownObjectField(types={byte[].class})
    protected byte[] frameInfoEncodings;
    @UnknownObjectField(types={Object[].class})
    protected Object[] frameInfoObjectConstants;
    @UnknownObjectField(types={Class[].class})
    protected Class<?>[] frameInfoSourceClasses;
    @UnknownObjectField(types={String[].class})
    protected String[] frameInfoSourceMethodNames;
    @UnknownObjectField(types={String[].class})
    protected String[] frameInfoNames;
    private static final int INVALID_SIZE_ENCODING = 0;
    protected static final int DELTA_END_OF_TABLE = 0;
    protected static final int FS_BITS = 2;
    protected static final int FS_SHIFT = 0;
    protected static final int FS_MASK_IN_PLACE = 3;
    protected static final int FS_NO_CHANGE = 0;
    protected static final int FS_SIZE_S1 = 1;
    protected static final int FS_SIZE_S2 = 2;
    protected static final int FS_SIZE_S4 = 3;
    protected static final int[] FS_MEM_SIZE = new int[]{0, 1, 2, 4};
    protected static final int EX_BITS = 2;
    protected static final int EX_SHIFT = 2;
    protected static final int EX_MASK_IN_PLACE = 12;
    protected static final int EX_NO_HANDLER = 0;
    protected static final int EX_OFFSET_S1 = 1;
    protected static final int EX_OFFSET_S2 = 2;
    protected static final int EX_OFFSET_S4 = 3;
    protected static final int[] EX_MEM_SIZE = new int[]{0, 1, 2, 4};
    protected static final int RM_BITS = 2;
    protected static final int RM_SHIFT = 4;
    protected static final int RM_MASK_IN_PLACE = 48;
    protected static final int RM_NO_MAP = 0;
    protected static final int RM_EMPTY_MAP = 1;
    protected static final int RM_INDEX_U2 = 2;
    protected static final int RM_INDEX_U4 = 3;
    protected static final int[] RM_MEM_SIZE = new int[]{0, 0, 2, 4};
    protected static final int FI_BITS = 2;
    protected static final int FI_SHIFT = 6;
    protected static final int FI_MASK_IN_PLACE = 192;
    protected static final int FI_NO_DEOPT = 0;
    protected static final int FI_DEOPT_ENTRY_INDEX_S4 = 1;
    protected static final int FI_INFO_ONLY_INDEX_S4 = 2;
    protected static final int[] FI_MEM_SIZE = new int[]{0, 4, 4, 0};
    protected static final int TOTAL_BITS = 8;
    protected static final byte IP_OFFSET;
    protected static final byte FS_OFFSET;
    protected static final byte[] EX_OFFSET;
    protected static final byte[] RM_OFFSET;
    protected static final byte[] FI_OFFSET;
    protected static final byte[] MEM_SIZE;

    CodeInfoDecoder() {
    }

    protected void setData(byte[] codeInfoIndex, byte[] codeInfoEncodings, byte[] referenceMapEncoding, byte[] frameInfoEncodings, Object[] frameInfoObjectConstants, Class<?>[] frameInfoSourceClasses, String[] frameInfoSourceMethodNames, String[] frameInfoNames) {
        this.codeInfoIndex = codeInfoIndex;
        this.codeInfoEncodings = codeInfoEncodings;
        this.referenceMapEncoding = referenceMapEncoding;
        this.frameInfoEncodings = frameInfoEncodings;
        this.frameInfoObjectConstants = frameInfoObjectConstants;
        this.frameInfoSourceClasses = frameInfoSourceClasses;
        this.frameInfoSourceMethodNames = frameInfoSourceMethodNames;
        this.frameInfoNames = frameInfoNames;
    }

    protected long lookupCodeInfoEntryOffset(long ip) {
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = this.loadEntryOffset(ip);
        do {
            int entryFlags = this.loadEntryFlags(entryOffset);
            if (entryIP == ip) {
                return entryOffset;
            }
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return -1L;
    }

    protected void lookupCodeInfo(long ip, CodeInfoQueryResult codeInfo) {
        codeInfo.exceptionOffset = 0L;
        codeInfo.referenceMapIndex = -1L;
        codeInfo.frameInfo = CodeInfoQueryResult.NO_FRAME_INFO;
        codeInfo.referenceMapEncoding = this.referenceMapEncoding;
        long sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = this.loadEntryOffset(ip);
        do {
            int entryFlags = this.loadEntryFlags(entryOffset);
            sizeEncoding = this.updateSizeEncoding(entryOffset, entryFlags, sizeEncoding);
            if (entryIP == ip) {
                codeInfo.exceptionOffset = this.loadExceptionOffset(entryOffset, entryFlags);
                codeInfo.referenceMapIndex = this.loadReferenceMapIndex(entryOffset, entryFlags);
                codeInfo.frameInfo = this.loadFrameInfo(entryOffset, entryFlags);
                break;
            }
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        codeInfo.totalFrameSize = CodeInfoDecoder.decodeTotalFrameSize(sizeEncoding);
    }

    public long lookupDeoptimizationEntrypoint(long method, long encodedBci, CodeInfoQueryResult codeInfo) {
        int entryFlags;
        long entryOffset;
        long entryIP;
        long sizeEncoding;
        block7: {
            sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
            entryIP = CodeInfoDecoder.lookupEntryIP(method);
            entryOffset = this.loadEntryOffset(method);
            do {
                entryFlags = this.loadEntryFlags(entryOffset);
                sizeEncoding = this.updateSizeEncoding(entryOffset, entryFlags, sizeEncoding);
                if (entryIP == method) break block7;
                entryIP = this.advanceIP(entryOffset, entryIP);
                entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
            } while (entryIP <= method);
            return -1L;
        }
        assert (entryIP == method);
        assert (CodeInfoDecoder.decodeMethodStart(this.loadEntryFlags(entryOffset), sizeEncoding));
        do {
            if (CodeInfoDecoder.decodeMethodStart(entryFlags = this.loadEntryFlags(entryOffset), sizeEncoding = this.updateSizeEncoding(entryOffset, entryFlags, sizeEncoding)) && entryIP != method) {
                return -1L;
            }
            if (this.isDeoptEntryPoint(entryOffset, entryFlags, encodedBci)) {
                codeInfo.totalFrameSize = CodeInfoDecoder.decodeTotalFrameSize(sizeEncoding);
                codeInfo.exceptionOffset = this.loadExceptionOffset(entryOffset, entryFlags);
                codeInfo.referenceMapEncoding = this.referenceMapEncoding;
                codeInfo.referenceMapIndex = this.loadReferenceMapIndex(entryOffset, entryFlags);
                codeInfo.frameInfo = this.loadFrameInfo(entryOffset, entryFlags);
                assert (codeInfo.frameInfo.isDeoptEntry() && codeInfo.frameInfo.getCaller() == null) : "Deoptimization entry must not have inlined frames";
                return entryIP;
            }
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (!CodeInfoDecoder.endOfTable(entryIP));
        return -1L;
    }

    protected long lookupTotalFrameSize(long ip) {
        long sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = this.loadEntryOffset(ip);
        do {
            int entryFlags = this.loadEntryFlags(entryOffset);
            sizeEncoding = this.updateSizeEncoding(entryOffset, entryFlags, sizeEncoding);
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return CodeInfoDecoder.decodeTotalFrameSize(sizeEncoding);
    }

    protected long lookupExceptionOffset(long ip) {
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = this.loadEntryOffset(ip);
        do {
            int entryFlags = this.loadEntryFlags(entryOffset);
            if (entryIP == ip) {
                return this.loadExceptionOffset(entryOffset, entryFlags);
            }
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return 0L;
    }

    protected byte[] getReferenceMapEncoding() {
        return this.referenceMapEncoding;
    }

    protected long lookupReferenceMapIndex(long ip) {
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = this.loadEntryOffset(ip);
        do {
            int entryFlags = this.loadEntryFlags(entryOffset);
            if (entryIP == ip) {
                return this.loadReferenceMapIndex(entryOffset, entryFlags);
            }
            entryIP = this.advanceIP(entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return -1L;
    }

    protected static long indexGranularity() {
        return Options.CodeInfoIndexGranularity.getValue().intValue();
    }

    protected static long lookupEntryIP(long ip) {
        return Long.divideUnsigned(ip, CodeInfoDecoder.indexGranularity()) * CodeInfoDecoder.indexGranularity();
    }

    private long loadEntryOffset(long ip) {
        CodeInfoDecoder.counters().lookupEntryOffsetCount.inc();
        long index = Long.divideUnsigned(ip, CodeInfoDecoder.indexGranularity());
        return ByteArrayReader.getU4(this.codeInfoIndex, index * 4L);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    protected final int loadEntryFlags(long curOffset) {
        CodeInfoDecoder.counters().loadEntryFlagsCount.inc();
        return ByteArrayReader.getU1(this.codeInfoEncodings, curOffset);
    }

    private static int initialSizeEncoding() {
        return 0;
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private long updateSizeEncoding(long entryOffset, int entryFlags, long sizeEncoding) {
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 0: {
                return sizeEncoding;
            }
            case 1: {
                return ByteArrayReader.getS1(this.codeInfoEncodings, CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
            case 2: {
                return ByteArrayReader.getS2(this.codeInfoEncodings, CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
            case 3: {
                return ByteArrayReader.getS4(this.codeInfoEncodings, CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static long decodeTotalFrameSize(long sizeEncoding) {
        assert (sizeEncoding != (long)CodeInfoDecoder.initialSizeEncoding());
        return Math.abs(sizeEncoding);
    }

    private static boolean decodeMethodStart(int entryFlags, long sizeEncoding) {
        assert (sizeEncoding != (long)CodeInfoDecoder.initialSizeEncoding());
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                return sizeEncoding < 0L;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private long loadExceptionOffset(long entryOffset, int entryFlags) {
        switch (CodeInfoDecoder.extractEX(entryFlags)) {
            case 0: {
                return 0L;
            }
            case 1: {
                return ByteArrayReader.getS1(this.codeInfoEncodings, CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
            case 2: {
                return ByteArrayReader.getS2(this.codeInfoEncodings, CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
            case 3: {
                return ByteArrayReader.getS4(this.codeInfoEncodings, CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private long loadReferenceMapIndex(long entryOffset, int entryFlags) {
        switch (CodeInfoDecoder.extractRM(entryFlags)) {
            case 0: {
                return -1L;
            }
            case 1: {
                return 0L;
            }
            case 2: {
                return ByteArrayReader.getU2(this.codeInfoEncodings, CodeInfoDecoder.offsetRM(entryOffset, entryFlags));
            }
            case 3: {
                return ByteArrayReader.getU4(this.codeInfoEncodings, CodeInfoDecoder.offsetRM(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private boolean isDeoptEntryPoint(long entryOffset, int entryFlags, long encodedBci) {
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 0: {
                return false;
            }
            case 1: {
                int frameInfoIndex = ByteArrayReader.getS4(this.codeInfoEncodings, CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
                return FrameInfoDecoder.isFrameInfoMatch(frameInfoIndex, this.frameInfoEncodings, encodedBci);
            }
            case 2: {
                return false;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    protected boolean initFrameInfoReader(long entryOffset, ReusableTypeReader frameInfoReader) {
        int entryFlags = this.loadEntryFlags(entryOffset);
        int frameInfoIndex = ByteArrayReader.getS4(this.codeInfoEncodings, CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
        frameInfoReader.setByteIndex(frameInfoIndex);
        frameInfoReader.setData(this.frameInfoEncodings);
        return CodeInfoDecoder.extractFI(entryFlags) != 0;
    }

    private FrameInfoQueryResult loadFrameInfo(long entryOffset, int entryFlags) {
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 0: {
                return CodeInfoQueryResult.NO_FRAME_INFO;
            }
            case 1: {
                return this.loadFrameInfo(true, entryOffset, entryFlags);
            }
            case 2: {
                return this.loadFrameInfo(false, entryOffset, entryFlags);
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private FrameInfoQueryResult loadFrameInfo(boolean isDeoptEntry, long entryOffset, int entryFlags) {
        int frameInfoIndex = ByteArrayReader.getS4(this.codeInfoEncodings, CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
        return FrameInfoDecoder.decodeFrameInfo(isDeoptEntry, new ReusableTypeReader(this.frameInfoEncodings, frameInfoIndex), this.frameInfoObjectConstants, this.frameInfoSourceClasses, this.frameInfoSourceMethodNames, this.frameInfoNames, FrameInfoDecoder.HeapBasedFrameInfoQueryResultAllocator, FrameInfoDecoder.HeapBasedValueInfoAllocator, true);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private long advanceIP(long entryOffset, long entryIP) {
        int deltaIP = ByteArrayReader.getU1(this.codeInfoEncodings, CodeInfoDecoder.offsetIP(entryOffset));
        if (deltaIP == 0) {
            return Long.MAX_VALUE;
        }
        assert (deltaIP > 0);
        return entryIP + (long)deltaIP;
    }

    private static boolean endOfTable(long entryIP) {
        return entryIP == Long.MAX_VALUE;
    }

    protected static int extractFS(int entryFlags) {
        return (entryFlags & 3) >> 0;
    }

    protected static int extractEX(int entryFlags) {
        return (entryFlags & 0xC) >> 2;
    }

    protected static int extractRM(int entryFlags) {
        return (entryFlags & 0x30) >> 4;
    }

    protected static int extractFI(int entryFlags) {
        return (entryFlags & 0xC0) >> 6;
    }

    private static long offsetIP(long entryOffset) {
        return entryOffset + (long)IP_OFFSET;
    }

    private static long offsetFS(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractFS(entryFlags) != 0);
        return entryOffset + (long)FS_OFFSET;
    }

    private static long offsetEX(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractEX(entryFlags) != 0);
        return entryOffset + (long)ByteArrayReader.getU1(EX_OFFSET, entryFlags);
    }

    private static long offsetRM(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractRM(entryFlags) != 0 && CodeInfoDecoder.extractRM(entryFlags) != 1);
        return entryOffset + (long)ByteArrayReader.getU1(RM_OFFSET, entryFlags);
    }

    private static long offsetFI(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractFI(entryFlags) != 0);
        return entryOffset + (long)ByteArrayReader.getU1(FI_OFFSET, entryFlags);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private static long advanceOffset(long entryOffset, int entryFlags) {
        CodeInfoDecoder.counters().advanceOffset.inc();
        return entryOffset + (long)ByteArrayReader.getU1(MEM_SIZE, entryFlags);
    }

    @Fold
    static CodeInfoDecoderCounters counters() {
        return (CodeInfoDecoderCounters)ImageSingletons.lookup(CodeInfoDecoderCounters.class);
    }

    static {
        int maxFlag = 256;
        IP_OFFSET = 1;
        FS_OFFSET = (byte)2;
        EX_OFFSET = new byte[maxFlag];
        RM_OFFSET = new byte[maxFlag];
        FI_OFFSET = new byte[maxFlag];
        MEM_SIZE = new byte[maxFlag];
        for (int i = 0; i < maxFlag; ++i) {
            CodeInfoDecoder.EX_OFFSET[i] = TypeConversion.asU1((long)(FS_OFFSET + FS_MEM_SIZE[CodeInfoDecoder.extractFS(i)]));
            CodeInfoDecoder.RM_OFFSET[i] = TypeConversion.asU1((long)(EX_OFFSET[i] + EX_MEM_SIZE[CodeInfoDecoder.extractEX(i)]));
            CodeInfoDecoder.FI_OFFSET[i] = TypeConversion.asU1((long)(RM_OFFSET[i] + RM_MEM_SIZE[CodeInfoDecoder.extractRM(i)]));
            CodeInfoDecoder.MEM_SIZE[i] = TypeConversion.asU1((long)(FI_OFFSET[i] + FI_MEM_SIZE[CodeInfoDecoder.extractFI(i)]));
        }
    }

    public static class Options {
        @Option(help={"The granularity of the index for looking up code metadata. Should be a power of 2. Larger values make the index smaller, but access slower."})
        public static final HostedOptionKey<Integer> CodeInfoIndexGranularity = new HostedOptionKey<Integer>(256);
    }
}

