/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.code.CodeInfoDecoder;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractCodeInfo
extends CodeInfoDecoder {
    @UnknownPrimitiveField
    private CodePointer codeStart;
    @UnknownPrimitiveField
    private UnsignedWord codeSize;

    protected void setData(CodePointer codeStart, UnsignedWord codeSize) {
        this.codeStart = codeStart;
        this.codeSize = codeSize;
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    public CodePointer getCodeStart() {
        return this.codeStart;
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    public UnsignedWord getCodeSize() {
        return this.codeSize;
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    protected CodePointer getCodeEnd() {
        return (CodePointer)((UnsignedWord)this.codeStart).add(this.codeSize);
    }

    public boolean contains(CodePointer ip) {
        return ((UnsignedWord)ip).subtract((UnsignedWord)this.codeStart).belowThan(this.codeSize);
    }

    public long relativeIP(CodePointer ip) {
        assert (this.contains(ip));
        return ((UnsignedWord)ip).subtract((UnsignedWord)this.codeStart).rawValue();
    }

    public CodePointer absoluteIP(long relativeIP) {
        return (CodePointer)((UnsignedWord)this.codeStart).add(WordFactory.unsigned((long)relativeIP));
    }

    public long initFrameInfoReader(CodePointer ip, ReusableTypeReader frameInfoReader) {
        long entryOffset = this.lookupCodeInfoEntryOffset(this.relativeIP(ip));
        if (entryOffset >= 0L && !this.initFrameInfoReader(entryOffset, frameInfoReader)) {
            return -1L;
        }
        return entryOffset;
    }

    public FrameInfoQueryResult nextFrameInfo(long entryOffset, ReusableTypeReader frameInfoReader, FrameInfoDecoder.FrameInfoQueryResultAllocator resultAllocator, FrameInfoDecoder.ValueInfoAllocator valueInfoAllocator, boolean fetchFirstFrame) {
        int entryFlags = this.loadEntryFlags(entryOffset);
        boolean isDeoptEntry = AbstractCodeInfo.extractFI(entryFlags) == 1;
        return FrameInfoDecoder.decodeFrameInfo(isDeoptEntry, frameInfoReader, this.frameInfoObjectConstants, this.frameInfoSourceClasses, this.frameInfoSourceMethodNames, this.frameInfoNames, resultAllocator, valueInfoAllocator, fetchFirstFrame);
    }

    public abstract String getName();
}

