/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.c.function;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.c.CHeader;
import com.oracle.svm.core.c.function.CEntryPointActions;
import com.oracle.svm.core.c.function.CEntryPointCreateIsolateParameters;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.c.function.GraalIsolateHeader;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.threadlocal.VMThreadLocalInfos;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

@CHeader(value=GraalIsolateHeader.class)
public final class CEntryPointNativeFunctions {
    private static final String UNINTERRUPTIBLE_REASON = "Unsafe state in case of failure";
    private static final CGlobalData<CLongPointer> ISOLATETHREAD_ISOLATE_OFFSET = CGlobalDataFactory.createBytes(() -> ByteBuffer.allocate(SizeOf.get(CLongPointer.class)).order(ConfigurationValues.getTarget().arch.getByteOrder()).putLong(VMThreadLocalInfos.getOffset(VMThreads.IsolateTL)).array());

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="create_isolate", documentation={"Create a new isolate, considering the passed parameters (which may be NULL).", "Returns 0 on success, or a non-zero value on failure.", "On success, the current thread is attached to the created isolate, and the", "address of the isolate and the isolate thread are written to the passed pointers", "if they are not NULL."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static int createIsolate(CEntryPointCreateIsolateParameters params, IsolatePointer isolate, IsolateThreadPointer thread) {
        int result = CEntryPointActions.enterCreateIsolate(params);
        if (result == 0) {
            if (isolate.isNonNull()) {
                isolate.write(CurrentIsolate.getIsolate());
            }
            if (thread.isNonNull()) {
                thread.write(CurrentIsolate.getCurrentThread());
            }
            result = CEntryPointActions.leave();
        }
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="attach_thread", documentation={"Attaches the current thread to the passed isolate.", "On failure, returns a non-zero value. On success, writes the address of the", "created isolate thread structure to the passed pointer and returns 0.", "If the thread has already been attached, the call succeeds and also provides", "the thread's isolate thread structure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static int attachThread(Isolate isolate, IsolateThreadPointer thread) {
        int result = CEntryPointActions.enterAttachThread(isolate);
        if (result == 0) {
            thread.write(CurrentIsolate.getCurrentThread());
            result = CEntryPointActions.leave();
        }
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="get_current_thread", documentation={"Given an isolate to which the current thread is attached, returns the address of", "the thread's associated isolate thread structure.  If the current thread is not", "attached to the passed isolate or if another error occurs, returns NULL."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static IsolateThread getCurrentThread(Isolate isolate) {
        int result = CEntryPointActions.enterIsolate(isolate);
        if (result != 0) {
            return (IsolateThread)WordFactory.nullPointer();
        }
        IsolateThread thread = CurrentIsolate.getCurrentThread();
        if (CEntryPointActions.leave() != 0) {
            thread = (IsolateThread)WordFactory.nullPointer();
        }
        return thread;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="get_isolate", documentation={"Given an isolate thread structure, determines to which isolate it belongs and returns", "the address of its isolate structure. If an error occurs, returns NULL instead."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static Isolate getIsolate(IsolateThread thread) {
        Isolate isolate = (Isolate)WordFactory.nullPointer();
        if (!thread.isNull()) {
            if (SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
                long offset = ISOLATETHREAD_ISOLATE_OFFSET.get().read();
                isolate = (Isolate)((Pointer)thread).readWord((WordBase)WordFactory.unsigned((long)offset));
            } else if (SubstrateOptions.SpawnIsolates.getValue().booleanValue() || thread.equal((ComparableWord)CEntryPointSetup.SINGLE_THREAD_SENTINEL)) {
                isolate = (Isolate)((Pointer)thread).subtract(1575);
            }
        }
        return isolate;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="detach_thread", documentation={"Detaches the passed isolate thread from its isolate and discards any state or", "context that is associated with it. At the time of the call, no code may still", "be executing in the isolate thread's context.", "Returns 0 on success, or a non-zero value on failure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static int detachThread(IsolateThread thread) {
        int result = CEntryPointActions.enter(thread);
        if (result != 0) {
            CEntryPointActions.leave();
            return result;
        }
        result = CEntryPointActions.leaveDetachThread();
        return result;
    }

    @Uninterruptible(reason="Unsafe state in case of failure")
    @CEntryPoint(name="tear_down_isolate", documentation={"Tears down the passed isolate, waiting for any attached threads to detach from", "it, then discards the isolate's objects, threads, and any other state or context", "that is associated with it.", "Returns 0 on success, or a non-zero value on failure."})
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, nameTransformation=NameTransformation.class)
    public static int tearDownIsolate(IsolateThread isolateThread) {
        int result = CEntryPointActions.enter(isolateThread);
        if (result != 0) {
            CEntryPointActions.leave();
            return result;
        }
        return CEntryPointActions.leaveTearDownIsolate();
    }

    private CEntryPointNativeFunctions() {
    }

    public static class NameTransformation
    implements Function<String, String> {
        @Override
        public String apply(String s) {
            return SubstrateOptions.APIFunctionPrefix.getValue() + s;
        }
    }

    @CPointerTo(value=IsolateThread.class)
    public static interface IsolateThreadPointer
    extends PointerBase {
        public IsolateThread read();

        public void write(IsolateThread var1);
    }

    @CPointerTo(value=Isolate.class)
    public static interface IsolatePointer
    extends PointerBase {
        public Isolate read();

        public void write(Isolate var1);
    }
}

