/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle.api;

import com.oracle.truffle.api.CompilerDirectives;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.Phase;

public class TruffleBoundaryPhase
extends Phase {
    protected void run(StructuredGraph graph) {
        for (Node n : graph.getNodes()) {
            CompilerDirectives.TruffleBoundary truffleBoundary;
            InvokeWithExceptionNode invoke;
            ExceptionObjectNode exceptionObject;
            FixedNode originalNext;
            if (!(n instanceof InvokeWithExceptionNode) || (originalNext = (exceptionObject = (ExceptionObjectNode)(invoke = (InvokeWithExceptionNode)n).exceptionEdge()).next()) instanceof DeoptimizeNode || invoke.callTarget().targetMethod() == null || (truffleBoundary = (CompilerDirectives.TruffleBoundary)invoke.callTarget().targetMethod().getAnnotation(CompilerDirectives.TruffleBoundary.class)) == null || truffleBoundary.throwsControlFlowException() || !truffleBoundary.transferToInterpreterOnException()) continue;
            TruffleBoundaryPhase.addDeoptimizeNode(graph, originalNext);
        }
    }

    private static void addDeoptimizeNode(StructuredGraph graph, FixedNode originalNext) {
        DeoptimizeNode deoptimize = (DeoptimizeNode)graph.add((Node)new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.NotCompiledExceptionHandler));
        originalNext.replaceAtPredecessor((Node)deoptimize);
        GraphUtil.killCFG((FixedNode)originalNext);
    }
}

