/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.snippets;

import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.reflect.ReflectionPluginExceptions;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;

public class ReflectionPlugins {
    private static final Method throwClassNotFoundExceptionMethod;
    private static final Method throwNoSuchFieldExceptionMethod;
    private static final Method throwNoSuchMethodExceptionMethod;

    public static void registerInvocationPlugins(ImageClassLoader imageClassLoader, SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, boolean analysis, boolean hosted) {
        if (hosted && analysis) {
            ImageSingletons.add(ReflectionPluginRegistry.class, (Object)new ReflectionPluginRegistry());
        }
        ReflectionPlugins.registerClassPlugins(imageClassLoader, snippetReflection, plugins, analysis, hosted);
    }

    private static void registerClassPlugins(final ImageClassLoader imageClassLoader, final SnippetReflectionProvider snippetReflection, InvocationPlugins plugins, final boolean analysis, final boolean hosted) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, Class.class);
        r.register1("forName", String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name) {
                return ReflectionPlugins.processForName(b, targetMethod, name, imageClassLoader, snippetReflection, analysis, hosted);
            }
        });
        r.register3("forName", String.class, Boolean.TYPE, ClassLoader.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name, ValueNode initialize, ValueNode classLoader) {
                return ReflectionPlugins.processForName(b, targetMethod, name, imageClassLoader, snippetReflection, analysis, hosted);
            }
        });
        r.register2("getDeclaredField", InvocationPlugin.Receiver.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name) {
                return ReflectionPlugins.processGetField(b, targetMethod, receiver, name, snippetReflection, true, analysis, hosted);
            }
        });
        r.register2("getField", InvocationPlugin.Receiver.class, String.class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name) {
                return ReflectionPlugins.processGetField(b, targetMethod, receiver, name, snippetReflection, false, analysis, hosted);
            }
        });
        r.register3("getDeclaredMethod", InvocationPlugin.Receiver.class, String.class, Class[].class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name, ValueNode parameterTypes) {
                return ReflectionPlugins.processGetMethod(b, targetMethod, receiver, name, parameterTypes, snippetReflection, true, analysis, hosted);
            }
        });
        r.register3("getMethod", InvocationPlugin.Receiver.class, String.class, Class[].class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name, ValueNode parameterTypes) {
                return ReflectionPlugins.processGetMethod(b, targetMethod, receiver, name, parameterTypes, snippetReflection, false, analysis, hosted);
            }
        });
        r.register2("getDeclaredConstructor", InvocationPlugin.Receiver.class, Class[].class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameterTypes) {
                return ReflectionPlugins.processGetConstructor(b, targetMethod, receiver, parameterTypes, snippetReflection, true, analysis, hosted);
            }
        });
        r.register2("getConstructor", InvocationPlugin.Receiver.class, Class[].class, new InvocationPlugin(){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameterTypes) {
                return ReflectionPlugins.processGetConstructor(b, targetMethod, receiver, parameterTypes, snippetReflection, false, analysis, hosted);
            }
        });
    }

    private static boolean processForName(GraphBuilderContext b, ResolvedJavaMethod targetMethod, ValueNode name, ImageClassLoader imageClassLoader, SnippetReflectionProvider snippetReflection, boolean analysis, boolean hosted) {
        if (name.isConstant()) {
            String className = (String)snippetReflection.asObject(String.class, name.asJavaConstant());
            Class<?> clazz = imageClassLoader.findClassByName(className, false);
            if (clazz == null) {
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, throwClassNotFoundExceptionMethod)) {
                    return false;
                }
                ReflectionPlugins.throwClassNotFoundException(b, targetMethod, className);
            } else {
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, clazz)) {
                    return false;
                }
                JavaConstant hub = b.getConstantReflection().asJavaClass(b.getMetaAccess().lookupJavaType(clazz));
                ReflectionPlugins.pushConstant(b, targetMethod, hub, className);
            }
            return true;
        }
        return false;
    }

    private static boolean processGetField(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name, SnippetReflectionProvider snippetReflection, boolean declared, boolean analysis, boolean hosted) {
        if (receiver.isConstant() && name.isConstant()) {
            Class clazz = (Class)snippetReflection.asObject(Class.class, receiver.get().asJavaConstant());
            String fieldName = (String)snippetReflection.asObject(String.class, name.asJavaConstant());
            String target = clazz.getTypeName() + "." + fieldName;
            try {
                Field field;
                Field field2 = field = declared ? clazz.getDeclaredField(fieldName) : clazz.getField(fieldName);
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, field)) {
                    return false;
                }
                ReflectionPlugins.pushConstant(b, targetMethod, snippetReflection.forObject((Object)field), target);
            }
            catch (NoSuchFieldException e) {
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, throwNoSuchFieldExceptionMethod)) {
                    return false;
                }
                ReflectionPlugins.throwNoSuchFieldException(b, targetMethod, target);
            }
            return true;
        }
        return false;
    }

    private static boolean processGetMethod(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode name, ValueNode parameterTypes, SnippetReflectionProvider snippetReflection, boolean declared, boolean analysis, boolean hosted) {
        Class<?>[] paramTypes;
        if (receiver.isConstant() && name.isConstant() && (paramTypes = SubstrateGraphBuilderPlugins.extractClassArray(snippetReflection, parameterTypes, true)) != null) {
            Class clazz = (Class)snippetReflection.asObject(Class.class, receiver.get().asJavaConstant());
            String methodName = (String)snippetReflection.asObject(String.class, name.asJavaConstant());
            String target = clazz.getTypeName() + "." + methodName + "(" + Stream.of(paramTypes).map(Class::getTypeName).collect(Collectors.joining(", ")) + ")";
            try {
                Method method;
                Method method2 = method = declared ? clazz.getDeclaredMethod(methodName, paramTypes) : clazz.getMethod(methodName, paramTypes);
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, method)) {
                    return false;
                }
                ReflectionPlugins.pushConstant(b, targetMethod, snippetReflection.forObject((Object)method), target);
            }
            catch (NoSuchMethodException e) {
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, throwNoSuchMethodExceptionMethod)) {
                    return false;
                }
                ReflectionPlugins.throwNoSuchMethodException(b, targetMethod, target);
            }
            return true;
        }
        return false;
    }

    private static boolean processGetConstructor(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode parameterTypes, SnippetReflectionProvider snippetReflection, boolean declared, boolean analysis, boolean hosted) {
        Class<?>[] paramTypes;
        if (receiver.isConstant() && (paramTypes = SubstrateGraphBuilderPlugins.extractClassArray(snippetReflection, parameterTypes, true)) != null) {
            Class clazz = (Class)snippetReflection.asObject(Class.class, receiver.get().asJavaConstant());
            String target = clazz.getTypeName() + ".<init>(" + Stream.of(paramTypes).map(Class::getTypeName).collect(Collectors.joining(", ")) + ")";
            try {
                Constructor constructor;
                Constructor constructor2 = constructor = declared ? clazz.getDeclaredConstructor(paramTypes) : clazz.getConstructor(paramTypes);
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, constructor)) {
                    return false;
                }
                ReflectionPlugins.pushConstant(b, targetMethod, snippetReflection.forObject(constructor), target);
            }
            catch (NoSuchMethodException e) {
                if (ReflectionPlugins.shouldNotIntrinsify(analysis, hosted, throwNoSuchMethodExceptionMethod)) {
                    return false;
                }
                ReflectionPlugins.throwNoSuchMethodException(b, targetMethod, target);
            }
            return true;
        }
        return false;
    }

    private static boolean shouldNotIntrinsify(boolean analysis, boolean hosted, Object element) {
        if (!hosted) {
            return false;
        }
        if (analysis) {
            ((ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPluginRegistry.class)).add(element);
            return false;
        }
        return !((ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPluginRegistry.class)).contains(element);
    }

    private static void pushConstant(GraphBuilderContext b, ResolvedJavaMethod reflectionMethod, JavaConstant constant, String targetElement) {
        b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph()));
        ReflectionPlugins.traceConstant(b.getMethod(), reflectionMethod, targetElement);
    }

    private static void throwClassNotFoundException(GraphBuilderContext b, ResolvedJavaMethod reflectionMethod, String targetClass) {
        String message = targetClass + ". This exception was synthesized during native image building from a call to " + reflectionMethod.format("%H.%n(%p)") + " with a constant class name argument.";
        ReflectionPlugins.throwException(b, message, throwClassNotFoundExceptionMethod);
        ReflectionPlugins.traceException(b.getMethod(), reflectionMethod, targetClass, throwClassNotFoundExceptionMethod);
    }

    private static void throwNoSuchFieldException(GraphBuilderContext b, ResolvedJavaMethod reflectionMethod, String targetField) {
        String message = targetField + ". This exception was synthesized during native image building from a call to " + reflectionMethod.format("%H.%n(%p)") + " with a constant field name argument.";
        ReflectionPlugins.throwException(b, message, throwNoSuchFieldExceptionMethod);
        ReflectionPlugins.traceException(b.getMethod(), reflectionMethod, targetField, throwNoSuchFieldExceptionMethod);
    }

    private static void throwNoSuchMethodException(GraphBuilderContext b, ResolvedJavaMethod reflectionMethod, String targetMethod) {
        String message = targetMethod + ". This exception was synthesized during native image building from a call to " + reflectionMethod.format("%H.%n(%p)") + " with constant method name and parameter types arguments.";
        ReflectionPlugins.throwException(b, message, throwNoSuchMethodExceptionMethod);
        ReflectionPlugins.traceException(b.getMethod(), reflectionMethod, targetMethod, throwNoSuchMethodExceptionMethod);
    }

    private static void throwException(GraphBuilderContext b, String message, Method reportExceptionMethod) {
        ConstantNode messageNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(message), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        ResolvedJavaMethod exceptionMethod = b.getMetaAccess().lookupJavaMethod((Executable)reportExceptionMethod);
        assert (exceptionMethod.isStatic());
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, exceptionMethod, new ValueNode[]{messageNode}, false);
    }

    private static void traceConstant(ResolvedJavaMethod contextMethod, ResolvedJavaMethod reflectionMethod, String targetElement) {
        if (Options.ReflectionPluginTracing.getValue().booleanValue()) {
            System.out.println("Call to " + reflectionMethod.format("%H.%n(%p)") + " reached in " + contextMethod.format("%H.%n(%p)") + " for target " + targetElement + " was reduced to a constant.");
        }
    }

    private static void traceException(ResolvedJavaMethod contextMethod, ResolvedJavaMethod reflectionMethod, String targetElement, Method exceptionMethod) {
        if (Options.ReflectionPluginTracing.getValue().booleanValue()) {
            String exception = exceptionMethod.getExceptionTypes()[0].getName();
            System.out.println("Call to " + reflectionMethod.format("%H.%n(%p)") + " reached in " + contextMethod.format("%H.%n(%p)") + " for target " + targetElement + " was reduced to a \"throw new " + exception + "(...)\"");
        }
    }

    static {
        try {
            throwClassNotFoundExceptionMethod = ReflectionPluginExceptions.class.getDeclaredMethod("throwClassNotFoundException", String.class);
            throwNoSuchFieldExceptionMethod = ReflectionPluginExceptions.class.getDeclaredMethod("throwNoSuchFieldException", String.class);
            throwNoSuchMethodExceptionMethod = ReflectionPluginExceptions.class.getDeclaredMethod("throwNoSuchMethodException", String.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    static class Options {
        @Option(help={"Enable trace logging for reflection plugins."})
        static final HostedOptionKey<Boolean> ReflectionPluginTracing = new HostedOptionKey<Boolean>(false);

        Options() {
        }
    }

    static class ReflectionPluginRegistry {
        ConcurrentHashMap<Object, Boolean> analysisElements = new ConcurrentHashMap();

        ReflectionPluginRegistry() {
        }

        public void add(Object element) {
            this.analysisElements.put(element, Boolean.TRUE);
        }

        public boolean contains(Object element) {
            return this.analysisElements.containsKey(element);
        }
    }
}

