/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.image;

import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.image.NativeImageHeap;
import com.oracle.svm.hosted.meta.HostedClass;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class HeapHistogram {
    protected static boolean PrintStrings = false;
    private final Map<HostedClass, HistogramEntry> data = new HashMap<HostedClass, HistogramEntry>();
    private static final Comparator<HistogramEntry> SIZE_COMPARATOR = (o1, o2) -> Long.compare(o2.size, o1.size);
    private final String headerFormat = "%8s %8s  %6s  %6s %s\n";
    private final String entryFormat = "%8d %8d %6.2f%% %6.2f%% %s\n";

    public void add(NativeImageHeap.ObjectInfo objectInfo, long size) {
        assert (NativeImageOptions.PrintHeapHistogram.getValue().booleanValue());
        HistogramEntry entry = this.data.get(objectInfo.getClazz());
        if (entry == null) {
            entry = new HistogramEntry(objectInfo.getClazz());
            this.data.put(objectInfo.getClazz(), entry);
        }
        ++entry.count;
        entry.size += size;
        if (PrintStrings && objectInfo.getObject() instanceof String) {
            String reason = String.valueOf(objectInfo.reason);
            String value = ((String)objectInfo.getObject()).replace("\n", "");
            if (!reason.startsWith("com.oracle.svm.core.hub.DynamicHub")) {
                System.out.format("%120s ::: %s\n", value, reason);
            }
        }
    }

    public void printHeadings(String title) {
        assert (NativeImageOptions.PrintHeapHistogram.getValue().booleanValue());
        System.out.format("\n%s\n", title);
        System.out.format("%8s %8s  %6s  %6s %s\n", "Count", "Size", "Size%", "Cum%", "Class");
    }

    public void print() {
        assert (NativeImageOptions.PrintHeapHistogram.getValue().booleanValue());
        HistogramEntry[] entries = this.data.values().toArray(new HistogramEntry[this.data.size()]);
        Arrays.sort(entries, SIZE_COMPARATOR);
        long totalSize = this.getTotalSize();
        long printedSize = 0L;
        for (HistogramEntry entry : entries) {
            System.out.format("%8d %8d %6.2f%% %6.2f%% %s\n", entry.count, entry.size, (double)entry.size * 100.0 / (double)totalSize, (double)(printedSize += entry.size) * 100.0 / (double)totalSize, entry.clazz.toJavaName());
        }
    }

    public long getTotalSize() {
        long totalSize = 0L;
        for (HistogramEntry entry : this.data.values()) {
            totalSize += entry.size;
        }
        return totalSize;
    }

    public long getTotalCount() {
        long totalCount = 0L;
        for (HistogramEntry entry : this.data.values()) {
            totalCount += entry.count;
        }
        return totalCount;
    }

    static class HistogramEntry {
        protected final HostedClass clazz;
        protected long count;
        protected long size;

        HistogramEntry(HostedClass clazz) {
            this.clazz = clazz;
        }
    }
}

