/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.c.info;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.c.CTypedef;
import com.oracle.svm.core.c.struct.PinnedObjectField;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ClassInitializationFeature;
import com.oracle.svm.hosted.c.BuiltinDirectives;
import com.oracle.svm.hosted.c.NativeCodeContext;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.c.info.AccessorInfo;
import com.oracle.svm.hosted.c.info.ConstantInfo;
import com.oracle.svm.hosted.c.info.EnumConstantInfo;
import com.oracle.svm.hosted.c.info.EnumInfo;
import com.oracle.svm.hosted.c.info.EnumLookupInfo;
import com.oracle.svm.hosted.c.info.EnumValueInfo;
import com.oracle.svm.hosted.c.info.NativeCodeInfo;
import com.oracle.svm.hosted.c.info.PointerToInfo;
import com.oracle.svm.hosted.c.info.SizableInfo;
import com.oracle.svm.hosted.c.info.StructBitfieldInfo;
import com.oracle.svm.hosted.c.info.StructFieldInfo;
import com.oracle.svm.hosted.c.info.StructInfo;
import com.oracle.svm.hosted.cenum.CEnumCallWrapperMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.bytecode.BridgeMethodUtils;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.constant.CEnum;
import org.graalvm.nativeimage.c.constant.CEnumConstant;
import org.graalvm.nativeimage.c.constant.CEnumLookup;
import org.graalvm.nativeimage.c.constant.CEnumValue;
import org.graalvm.nativeimage.c.struct.CBitfield;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CFieldOffset;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.struct.RawField;
import org.graalvm.nativeimage.c.struct.RawStructure;
import org.graalvm.nativeimage.c.struct.UniqueLocationIdentity;
import org.graalvm.word.PointerBase;

public class InfoTreeBuilder {
    private final NativeLibraries nativeLibs;
    private final NativeCodeContext codeCtx;
    private final NativeCodeInfo nativeCodeInfo;

    public InfoTreeBuilder(NativeLibraries nativeLibs, NativeCodeContext codeCtx) {
        String name;
        this.nativeLibs = nativeLibs;
        this.codeCtx = codeCtx;
        boolean isBuiltin = codeCtx.getDirectives() instanceof BuiltinDirectives;
        if (codeCtx.getDirectives() != null) {
            name = codeCtx.getDirectives().getClass().getSimpleName();
        } else {
            StringBuilder nameBuilder = new StringBuilder();
            String sep = "";
            for (String headerFile : codeCtx.getDirectives().getHeaderFiles()) {
                nameBuilder.append(sep).append(headerFile);
                sep = "_";
            }
            name = nameBuilder.toString();
        }
        this.nativeCodeInfo = new NativeCodeInfo(name, codeCtx.getDirectives(), isBuiltin);
    }

    public NativeCodeInfo construct() {
        for (ResolvedJavaMethod method : this.codeCtx.getConstantAccessors()) {
            this.createConstantInfo(method);
        }
        for (ResolvedJavaType type : this.codeCtx.getStructTypes()) {
            this.createStructInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getRawStructTypes()) {
            this.createRawStructInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getPointerToTypes()) {
            this.createPointerToInfo(type);
        }
        for (ResolvedJavaType type : this.codeCtx.getEnumTypes()) {
            this.createEnumInfo(type);
        }
        return this.nativeCodeInfo;
    }

    private MetaAccessProvider getMetaAccess() {
        return this.nativeLibs.getMetaAccess();
    }

    protected void createConstantInfo(ResolvedJavaMethod method) {
        int actualParamCount = method.getSignature().getParameterCount(false);
        if (actualParamCount != 0) {
            this.nativeLibs.addError("Wrong number of parameters: expected 0; found " + actualParamCount, method);
            return;
        }
        ResolvedJavaType returnType = (ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass());
        if (returnType.getJavaKind() == JavaKind.Void || returnType.getJavaKind() == JavaKind.Object && !this.nativeLibs.isString(returnType) && !this.nativeLibs.isByteArray(returnType) && !this.nativeLibs.isWordBase(returnType)) {
            this.nativeLibs.addError("Wrong return type: expected a primitive type, String, or a Word type; found " + returnType.toJavaName(true), method);
            return;
        }
        String constantName = InfoTreeBuilder.getConstantName(method);
        SizableInfo.ElementKind elementKind = this.elementKind(returnType);
        ConstantInfo constantInfo = new ConstantInfo(constantName, elementKind, method);
        this.nativeCodeInfo.adoptChild(constantInfo);
        this.nativeLibs.registerElementInfo(method, constantInfo);
    }

    private void createPointerToInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, CPointerTo.class)) {
            return;
        }
        ArrayList<AccessorInfo> accessorInfos = new ArrayList<AccessorInfo>();
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            AccessorInfo accessorInfo = method.getSignature().getReturnKind() == JavaKind.Void ? new AccessorInfo(method, AccessorInfo.AccessorKind.SETTER, method.getSignature().getParameterCount(false) > 1, false, false) : (method.getSignature().getReturnType(method.getDeclaringClass()).equals(method.getDeclaringClass()) ? new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, method.getSignature().getParameterCount(false) > 0, false, false) : new AccessorInfo(method, AccessorInfo.AccessorKind.GETTER, method.getSignature().getParameterCount(false) > 0, false, false));
            if (!this.accessorValid(accessorInfo)) continue;
            accessorInfos.add(accessorInfo);
            this.nativeLibs.registerElementInfo(method, accessorInfo);
        }
        String typeName = this.getPointerToTypeName(type);
        String typedefName = InfoTreeBuilder.getTypedefName(type);
        PointerToInfo pointerToInfo = new PointerToInfo(typeName, typedefName, this.elementKind(accessorInfos), type);
        pointerToInfo.adoptChildren(accessorInfos);
        this.nativeCodeInfo.adoptChild(pointerToInfo);
        this.nativeLibs.registerElementInfo(type, pointerToInfo);
    }

    public static String getTypedefName(ResolvedJavaType type) {
        CTypedef typedefAnnotation = (CTypedef)type.getAnnotation(CTypedef.class);
        return typedefAnnotation != null ? typedefAnnotation.name() : null;
    }

    private void createStructInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, CStruct.class)) {
            return;
        }
        TreeMap fieldAccessorInfos = new TreeMap();
        TreeMap<String, ArrayList<AccessorInfo>> bitfieldAccessorInfos = new TreeMap<String, ArrayList<AccessorInfo>>();
        ArrayList<AccessorInfo> structAccessorInfos = new ArrayList<AccessorInfo>();
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            String fieldName;
            AccessorInfo accessorInfo;
            CField fieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CField.class);
            CFieldAddress fieldAddressAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CFieldAddress.class);
            CFieldOffset fieldOffsetAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CFieldOffset.class);
            CBitfield bitfieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CBitfield.class);
            if (fieldAnnotation != null) {
                accessorInfo = method.getSignature().getReturnKind() == JavaKind.Void ? new AccessorInfo(method, AccessorInfo.AccessorKind.SETTER, false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method)) : new AccessorInfo(method, AccessorInfo.AccessorKind.GETTER, false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method));
                fieldName = InfoTreeBuilder.getStructFieldName(method, fieldAnnotation.value(), accessorInfo.getAccessorKind());
            } else if (bitfieldAnnotation != null) {
                accessorInfo = method.getSignature().getReturnKind() == JavaKind.Void ? new AccessorInfo(method, AccessorInfo.AccessorKind.SETTER, false, this.hasLocationIdentityParameter(method), false) : new AccessorInfo(method, AccessorInfo.AccessorKind.GETTER, false, this.hasLocationIdentityParameter(method), false);
                fieldName = InfoTreeBuilder.getStructFieldName(method, bitfieldAnnotation.value(), accessorInfo.getAccessorKind());
            } else if (fieldAddressAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(method, fieldAddressAnnotation.value(), accessorInfo.getAccessorKind());
            } else if (fieldOffsetAnnotation != null) {
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.OFFSET, false, false, false);
                fieldName = InfoTreeBuilder.getStructFieldName(method, fieldOffsetAnnotation.value(), accessorInfo.getAccessorKind());
            } else if (method.getSignature().getReturnType(method.getDeclaringClass()).equals(method.getDeclaringClass())) {
                fieldName = null;
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, method.getSignature().getParameterCount(false) > 0, false, false);
            } else {
                this.nativeLibs.addError("Unexpected method without annotation", method);
                continue;
            }
            if (!this.accessorValid(accessorInfo)) continue;
            if (fieldName == null) {
                structAccessorInfos.add(accessorInfo);
            } else {
                TreeMap<String, ArrayList<AccessorInfo>> map = bitfieldAnnotation != null ? bitfieldAccessorInfos : fieldAccessorInfos;
                ArrayList<AccessorInfo> accessorInfos = (ArrayList<AccessorInfo>)map.get(fieldName);
                if (accessorInfos == null) {
                    accessorInfos = new ArrayList<AccessorInfo>();
                    map.put(fieldName, accessorInfos);
                }
                accessorInfos.add(accessorInfo);
            }
            this.nativeLibs.registerElementInfo(method, accessorInfo);
        }
        String typeName = InfoTreeBuilder.getStructName(type);
        StructInfo structInfo = StructInfo.create(typeName, type);
        structInfo.adoptChildren(structAccessorInfos);
        for (Map.Entry entry : fieldAccessorInfos.entrySet()) {
            StructFieldInfo fieldInfo = new StructFieldInfo((String)entry.getKey(), this.elementKind((Collection)entry.getValue()));
            fieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(fieldInfo);
        }
        for (Map.Entry entry : bitfieldAccessorInfos.entrySet()) {
            if (fieldAccessorInfos.containsKey(entry.getKey())) {
                this.nativeLibs.addError("Bitfield and regular field accessor methods cannot be mixed", entry.getValue(), fieldAccessorInfos.get(entry.getKey()));
            } else if (this.elementKind((Collection)entry.getValue()) != SizableInfo.ElementKind.INTEGER) {
                this.nativeLibs.addError("Bitfield accessor method must have integer kind", entry.getValue());
            }
            StructBitfieldInfo bitfieldInfo = new StructBitfieldInfo((String)entry.getKey());
            bitfieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(bitfieldInfo);
        }
        this.nativeCodeInfo.adoptChild(structInfo);
        this.nativeLibs.registerElementInfo(type, structInfo);
    }

    private void createRawStructInfo(ResolvedJavaType type) {
        if (!this.validInterfaceDefinition(type, RawStructure.class)) {
            return;
        }
        TreeMap<String, ArrayList<AccessorInfo>> fieldAccessorInfos = new TreeMap<String, ArrayList<AccessorInfo>>();
        ArrayList<AccessorInfo> structAccessorInfos = new ArrayList<AccessorInfo>();
        for (ResolvedJavaMethod method : type.getDeclaredMethods()) {
            String fieldName;
            AccessorInfo accessorInfo;
            RawField fieldAnnotation = InfoTreeBuilder.getMethodAnnotation(method, RawField.class);
            if (fieldAnnotation != null) {
                accessorInfo = method.getSignature().getReturnKind() == JavaKind.Void ? new AccessorInfo(method, AccessorInfo.AccessorKind.SETTER, false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method)) : new AccessorInfo(method, AccessorInfo.AccessorKind.GETTER, false, this.hasLocationIdentityParameter(method), InfoTreeBuilder.hasUniqueLocationIdentity(method));
                fieldName = InfoTreeBuilder.getStructFieldName(method, "", accessorInfo.getAccessorKind());
            } else if (method.getSignature().getReturnType(method.getDeclaringClass()).equals(method.getDeclaringClass())) {
                fieldName = null;
                accessorInfo = new AccessorInfo(method, AccessorInfo.AccessorKind.ADDRESS, method.getSignature().getParameterCount(false) > 0, false, false);
            } else {
                this.nativeLibs.addError("Unexpected method without annotation", method);
                continue;
            }
            if (!this.accessorValid(accessorInfo)) continue;
            if (fieldName == null) {
                structAccessorInfos.add(accessorInfo);
            } else {
                TreeMap<String, ArrayList<AccessorInfo>> map = fieldAccessorInfos;
                ArrayList<AccessorInfo> accessorInfos = (ArrayList<AccessorInfo>)map.get(fieldName);
                if (accessorInfos == null) {
                    accessorInfos = new ArrayList<AccessorInfo>();
                    map.put(fieldName, accessorInfos);
                }
                accessorInfos.add(accessorInfo);
            }
            this.nativeLibs.registerElementInfo(method, accessorInfo);
        }
        String typeName = InfoTreeBuilder.getStructName(type);
        StructInfo structInfo = StructInfo.create(typeName, type);
        structInfo.adoptChildren(structAccessorInfos);
        for (Map.Entry entry : fieldAccessorInfos.entrySet()) {
            StructFieldInfo fieldInfo = new StructFieldInfo((String)entry.getKey(), this.elementKind((Collection)entry.getValue()));
            fieldInfo.adoptChildren((Collection)entry.getValue());
            structInfo.adoptChild(fieldInfo);
        }
        this.nativeCodeInfo.adoptChild(structInfo);
        this.nativeLibs.registerElementInfo(type, structInfo);
    }

    private boolean hasLocationIdentityParameter(ResolvedJavaMethod method) {
        if (method.getSignature().getParameterCount(false) == 0) {
            return false;
        }
        JavaType lastParam = method.getSignature().getParameterType(method.getSignature().getParameterCount(false) - 1, null);
        return this.nativeLibs.getLocationIdentityType().equals(lastParam);
    }

    private static boolean hasUniqueLocationIdentity(ResolvedJavaMethod method) {
        return InfoTreeBuilder.getMethodAnnotation(method, UniqueLocationIdentity.class) != null;
    }

    private SizableInfo.ElementKind elementKind(Collection<AccessorInfo> accessorInfos) {
        SizableInfo.ElementKind overallKind = SizableInfo.ElementKind.UNKNOWN;
        AccessorInfo overallKindAccessor = null;
        block4: for (AccessorInfo accessorInfo : accessorInfos) {
            SizableInfo.ElementKind newKind;
            ResolvedJavaMethod method = (ResolvedJavaMethod)accessorInfo.getAnnotatedElement();
            switch (accessorInfo.getAccessorKind()) {
                case GETTER: {
                    newKind = this.elementKind((ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass()));
                    break;
                }
                case SETTER: {
                    newKind = this.elementKind((ResolvedJavaType)method.getSignature().getParameterType(accessorInfo.valueParameterNumber(false), method.getDeclaringClass()));
                    break;
                }
                default: {
                    continue block4;
                }
            }
            if (overallKind == SizableInfo.ElementKind.UNKNOWN) {
                overallKind = newKind;
                overallKindAccessor = accessorInfo;
                continue;
            }
            if (overallKind == newKind) continue;
            this.nativeLibs.addError("Accessor methods mix integer, floating point, and pointer kinds", overallKindAccessor.getAnnotatedElement(), method);
        }
        return overallKind;
    }

    private SizableInfo.ElementKind elementKind(ResolvedJavaType type) {
        switch (type.getJavaKind()) {
            case Boolean: 
            case Byte: 
            case Char: 
            case Short: 
            case Int: 
            case Long: {
                return SizableInfo.ElementKind.INTEGER;
            }
            case Float: 
            case Double: {
                return SizableInfo.ElementKind.FLOAT;
            }
            case Object: {
                if (this.nativeLibs.isSigned(type) || this.nativeLibs.isUnsigned(type)) {
                    return SizableInfo.ElementKind.INTEGER;
                }
                if (this.nativeLibs.isString(type)) {
                    return SizableInfo.ElementKind.STRING;
                }
                if (this.nativeLibs.isByteArray(type)) {
                    return SizableInfo.ElementKind.BYTEARRAY;
                }
                return SizableInfo.ElementKind.POINTER;
            }
        }
        return SizableInfo.ElementKind.UNKNOWN;
    }

    private boolean accessorValid(AccessorInfo accessorInfo) {
        ResolvedJavaType paramType;
        ResolvedJavaMethod method = (ResolvedJavaMethod)accessorInfo.getAnnotatedElement();
        int expectedParamCount = accessorInfo.parameterCount(false);
        int actualParamCount = method.getSignature().getParameterCount(false);
        if (actualParamCount != expectedParamCount) {
            this.nativeLibs.addError("Wrong number of parameters: expected " + expectedParamCount + "; found " + actualParamCount, method);
            return false;
        }
        if (accessorInfo.isIndexed() && (paramType = (ResolvedJavaType)method.getSignature().getParameterType(accessorInfo.indexParameterNumber(false), method.getDeclaringClass())).getJavaKind() != JavaKind.Int && paramType.getJavaKind() != JavaKind.Long && !this.nativeLibs.isSigned(paramType)) {
            this.nativeLibs.addError("Wrong type of index parameter 0: expected int, long, or Signed; found " + paramType.toJavaName(true), method);
            return false;
        }
        if (accessorInfo.hasLocationIdentityParameter() && accessorInfo.hasUniqueLocationIdentity()) {
            this.nativeLibs.addError("Method cannot have annotation @" + UniqueLocationIdentity.class.getSimpleName() + " and a LocationIdentity parameter", method);
            return false;
        }
        if (accessorInfo.hasLocationIdentityParameter()) {
            paramType = (ResolvedJavaType)method.getSignature().getParameterType(accessorInfo.locationIdentityParameterNumber(false), method.getDeclaringClass());
            if (!this.nativeLibs.getLocationIdentityType().equals(paramType)) {
                this.nativeLibs.addError("Wrong type of locationIdentity parameter: expected " + this.nativeLibs.getLocationIdentityType().toJavaName(true) + "; found " + paramType.toJavaName(true), method);
                return false;
            }
        }
        ResolvedJavaType returnType = (ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass());
        if (accessorInfo.getAccessorKind() == AccessorInfo.AccessorKind.ADDRESS && (!this.nativeLibs.isPointerBase(returnType) || this.nativeLibs.isSigned(returnType) || this.nativeLibs.isUnsigned(returnType))) {
            this.nativeLibs.addError("Wrong return type: expected a pointer type; found " + returnType.toJavaName(true), method);
            return false;
        }
        if (accessorInfo.getAccessorKind() == AccessorInfo.AccessorKind.OFFSET && !returnType.getJavaKind().isNumericInteger() && !this.nativeLibs.isUnsigned(returnType)) {
            this.nativeLibs.addError("Wrong return type: expected an integer numeric type or Unsigned; found " + returnType.toJavaName(true), method);
            return false;
        }
        if (!this.checkObjectType(returnType, method)) {
            return false;
        }
        for (int i = 0; i < method.getSignature().getParameterCount(false); ++i) {
            ResolvedJavaType paramType2 = (ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass());
            if (this.checkObjectType(paramType2, method)) continue;
            return false;
        }
        return true;
    }

    private boolean checkObjectType(ResolvedJavaType returnType, ResolvedJavaMethod method) {
        if (returnType.getJavaKind() == JavaKind.Object && !this.nativeLibs.isWordBase(returnType) && InfoTreeBuilder.getMethodAnnotation(method, PinnedObjectField.class) == null) {
            this.nativeLibs.addError("Wrong type: expected a primitive type or a Word type; found " + returnType.toJavaName(true) + ". Use the annotation @" + PinnedObjectField.class.getSimpleName() + " if you know what you are doing.", method);
            return false;
        }
        return true;
    }

    private boolean validInterfaceDefinition(ResolvedJavaType type, Class<? extends Annotation> annotationClass) {
        assert (type.getAnnotation(annotationClass) != null);
        if (!type.isInterface() || !this.nativeLibs.isPointerBase(type)) {
            this.nativeLibs.addError("Annotation @" + annotationClass.getSimpleName() + " can only be used on an interface that extends extends " + PointerBase.class.getSimpleName(), type);
            return false;
        }
        return true;
    }

    private static String removePrefix(String name, String prefix) {
        assert (prefix.length() > 0);
        String result = name;
        if (result.startsWith(prefix) && (result = result.substring(prefix.length())).startsWith("_")) {
            result = result.substring("_".length());
        }
        return result;
    }

    private static String getConstantName(ResolvedJavaMethod method) {
        CConstant constantAnnotation = InfoTreeBuilder.getMethodAnnotation(method, CConstant.class);
        String name = constantAnnotation.value();
        if (name.length() == 0) {
            name = method.getName();
            name = InfoTreeBuilder.removePrefix(name, "get");
        }
        return name;
    }

    private String getPointerToTypeName(ResolvedJavaType type) {
        CPointerTo pointerToPointerAnnotation;
        CStruct pointerToStructAnnotation;
        CPointerTo pointerToAnnotation = (CPointerTo)type.getAnnotation(CPointerTo.class);
        String nameOfCType = pointerToAnnotation.nameOfCType();
        Class pointerToType = pointerToAnnotation.value();
        do {
            pointerToStructAnnotation = pointerToType.getAnnotation(CStruct.class);
            pointerToPointerAnnotation = pointerToType.getAnnotation(CPointerTo.class);
        } while (pointerToStructAnnotation == null && pointerToPointerAnnotation == null && (pointerToType = pointerToType.getInterfaces().length == 1 ? pointerToType.getInterfaces()[0] : null) != null);
        int n = (nameOfCType.length() > 0 ? 1 : 0) + (pointerToStructAnnotation != null ? 1 : 0) + (pointerToPointerAnnotation != null ? 1 : 0);
        if (n != 1) {
            this.nativeLibs.addError("Exactly one of 1) literal C type name, 2) class annotated with @" + CStruct.class.getSimpleName() + ", or 3) class annotated with @" + CPointerTo.class.getSimpleName() + " must be specified in @" + CPointerTo.class.getSimpleName() + " annotation", type);
            return "__error";
        }
        if (pointerToStructAnnotation != null) {
            return InfoTreeBuilder.getStructName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
        }
        if (pointerToPointerAnnotation != null) {
            return this.getPointerToTypeName(this.getMetaAccess().lookupJavaType(pointerToType)) + "*";
        }
        return nameOfCType;
    }

    private static String getStructName(ResolvedJavaType type) {
        CStruct structAnnotation = (CStruct)type.getAnnotation(CStruct.class);
        if (structAnnotation == null) {
            RawStructure rsanno = (RawStructure)type.getAnnotation(RawStructure.class);
            assert (rsanno != null) : "Unexpected struct type " + type;
            return InfoTreeBuilder.getSimpleJavaName(type);
        }
        String name = structAnnotation.value();
        if (name.length() == 0) {
            name = InfoTreeBuilder.getSimpleJavaName(type);
        }
        if (structAnnotation.addStructKeyword()) {
            name = "struct " + name;
        }
        return name;
    }

    private static String getSimpleJavaName(ResolvedJavaType type) {
        String name = type.toJavaName(false);
        int innerClassSeparator = name.lastIndexOf(36);
        if (innerClassSeparator >= 0) {
            name = name.substring(innerClassSeparator + 1);
        }
        return name;
    }

    private static String getStructFieldName(ResolvedJavaMethod method, String annotationValue, AccessorInfo.AccessorKind accessorKind) {
        String name = annotationValue;
        if (name.length() == 0) {
            String prefix;
            name = method.getName();
            switch (accessorKind) {
                case GETTER: {
                    prefix = "get";
                    break;
                }
                case SETTER: {
                    prefix = "set";
                    break;
                }
                case ADDRESS: {
                    prefix = "addressOf";
                    break;
                }
                case OFFSET: {
                    prefix = "offsetOf";
                    break;
                }
                default: {
                    throw VMError.shouldNotReachHere();
                }
            }
            name = InfoTreeBuilder.removePrefix(name, prefix);
        }
        return name;
    }

    private void createEnumInfo(ResolvedJavaType type) {
        if (!this.nativeLibs.isEnum(type)) {
            this.nativeLibs.addError("Annotation @" + CEnum.class.getSimpleName() + " can only be used on an Java enumeration", type);
            return;
        }
        CEnum annotation = (CEnum)type.getAnnotation(CEnum.class);
        String name = annotation.value();
        if (!name.isEmpty()) {
            if (annotation.addEnumKeyword()) {
                name = "enum " + name;
            }
        } else {
            name = "int";
        }
        EnumInfo enumInfo = new EnumInfo(name, type);
        ClassInitializationFeature.singleton().forceInitializeHosted(type);
        for (ResolvedJavaField resolvedJavaField : type.getStaticFields()) {
            assert (Modifier.isStatic(resolvedJavaField.getModifiers()));
            if (!Modifier.isFinal(resolvedJavaField.getModifiers()) || !resolvedJavaField.getType().equals(type)) continue;
            this.createEnumConstantInfo(enumInfo, resolvedJavaField);
        }
        for (ResolvedJavaField resolvedJavaField : type.getDeclaredMethods()) {
            if (InfoTreeBuilder.getMethodAnnotation((ResolvedJavaMethod)resolvedJavaField, CEnumValue.class) != null) {
                this.createEnumValueInfo(enumInfo, (ResolvedJavaMethod)resolvedJavaField);
            }
            if (InfoTreeBuilder.getMethodAnnotation((ResolvedJavaMethod)resolvedJavaField, CEnumLookup.class) == null) continue;
            this.createEnumLookupInfo(enumInfo, (ResolvedJavaMethod)resolvedJavaField);
        }
        this.nativeCodeInfo.adoptChild(enumInfo);
        this.nativeLibs.registerElementInfo(type, enumInfo);
    }

    private void createEnumConstantInfo(EnumInfo enumInfo, ResolvedJavaField field) {
        JavaConstant enumValue = this.nativeLibs.getConstantReflection().readFieldValue(field, null);
        assert (enumValue.isNonNull() && this.nativeLibs.getMetaAccess().lookupJavaType(enumValue).equals(enumInfo.getAnnotatedElement()));
        CEnumConstant fieldAnnotation = (CEnumConstant)field.getAnnotation(CEnumConstant.class);
        String name = "";
        boolean includeInLookup = true;
        if (fieldAnnotation != null) {
            name = fieldAnnotation.value();
            includeInLookup = fieldAnnotation.includeInLookup();
        }
        if (name.length() == 0) {
            name = field.getName();
        }
        EnumConstantInfo constantInfo = new EnumConstantInfo(name, field, includeInLookup, (Enum)this.nativeLibs.getSnippetReflection().asObject(Enum.class, enumValue));
        enumInfo.adoptChild(constantInfo);
    }

    private static ResolvedJavaMethod originalMethod(ResolvedJavaMethod method) {
        assert (method instanceof AnalysisMethod);
        AnalysisMethod analysisMethod = (AnalysisMethod)method;
        assert (analysisMethod.getWrapped() instanceof CEnumCallWrapperMethod);
        CEnumCallWrapperMethod wrapperMethod = (CEnumCallWrapperMethod)analysisMethod.getWrapped();
        return wrapperMethod.getOriginal();
    }

    private void createEnumValueInfo(EnumInfo enumInfo, ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = InfoTreeBuilder.originalMethod(method);
        if (!Modifier.isNative(originalMethod.getModifiers()) || Modifier.isStatic(originalMethod.getModifiers())) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " must be a non-static native method", method);
            return;
        }
        if (method.getSignature().getParameterCount(false) != 0) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " cannot have parameters", method);
            return;
        }
        SizableInfo.ElementKind elementKind = this.elementKind((ResolvedJavaType)method.getSignature().getReturnType(method.getDeclaringClass()));
        if (elementKind != SizableInfo.ElementKind.INTEGER) {
            this.nativeLibs.addError("Method annotated with @" + CEnumValue.class.getSimpleName() + " must have an integer return type", method);
            return;
        }
        EnumValueInfo valueInfo = new EnumValueInfo(method);
        enumInfo.adoptChild(valueInfo);
        this.nativeLibs.registerElementInfo(method, valueInfo);
    }

    private void createEnumLookupInfo(EnumInfo enumInfo, ResolvedJavaMethod method) {
        ResolvedJavaMethod originalMethod = InfoTreeBuilder.originalMethod(method);
        if (!Modifier.isNative(originalMethod.getModifiers()) || !Modifier.isStatic(originalMethod.getModifiers())) {
            this.nativeLibs.addError("Method annotated with @" + CEnumLookup.class.getSimpleName() + " must be a static native method", method);
            return;
        }
        if (method.getSignature().getParameterCount(false) != 1 || this.elementKind((ResolvedJavaType)method.getSignature().getParameterType(0, method.getDeclaringClass())) != SizableInfo.ElementKind.INTEGER) {
            this.nativeLibs.addError("Method annotated with @" + CEnumLookup.class.getSimpleName() + " must have exactly one integer parameter", method);
            return;
        }
        if (!method.getSignature().getReturnType(method.getDeclaringClass()).equals(method.getDeclaringClass())) {
            this.nativeLibs.addError("Return type of method annotated with @" + CEnumLookup.class.getSimpleName() + " must be the annotation type", method);
            return;
        }
        enumInfo.needsLookup = true;
        EnumLookupInfo lookupInfo = new EnumLookupInfo(method);
        enumInfo.adoptChild(lookupInfo);
        this.nativeLibs.registerElementInfo(method, lookupInfo);
    }

    private static <T extends Annotation> T getMethodAnnotation(ResolvedJavaMethod method, Class<T> annotationClass) {
        return (T)BridgeMethodUtils.getAnnotation(annotationClass, (ResolvedJavaMethod)method);
    }
}

