/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.annotation;

import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.annotation.AnnotationSubstitutionType;
import com.oracle.svm.hosted.annotation.AnnotationSupport;
import com.oracle.svm.hosted.annotation.CustomSubstitutionField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import sun.reflect.annotation.TypeNotPresentExceptionProxy;

public class AnnotationSubstitutionField
extends CustomSubstitutionField {
    private final ResolvedJavaMethod accessorMethod;
    private final Map<JavaConstant, JavaConstant> valueCache;
    private final SnippetReflectionProvider snippetReflection;
    private final MetaAccessProvider metaAccess;

    public AnnotationSubstitutionField(AnnotationSubstitutionType declaringClass, ResolvedJavaMethod accessorMethod, SnippetReflectionProvider snippetReflection, MetaAccessProvider metaAccess) {
        super(declaringClass);
        this.accessorMethod = accessorMethod;
        this.snippetReflection = snippetReflection;
        this.valueCache = Collections.synchronizedMap(new HashMap());
        this.metaAccess = metaAccess;
    }

    public String getName() {
        return this.accessorMethod.getName();
    }

    public JavaType getType() {
        JavaType actualType = this.accessorMethod.getSignature().getReturnType(this.accessorMethod.getDeclaringClass());
        if (AnnotationSupport.isClassType(actualType, this.metaAccess)) {
            return this.metaAccess.lookupJavaType(Object.class);
        }
        return actualType;
    }

    @Override
    public JavaConstant readValue(JavaConstant receiver) {
        JavaConstant result;
        block6: {
            Object annotationFieldValue;
            block8: {
                block7: {
                    result = this.valueCache.get(receiver);
                    if (result != null) break block6;
                    try {
                        Proxy proxy = (Proxy)this.snippetReflection.asObject(Proxy.class, receiver);
                        Method reflectionMethod = proxy.getClass().getDeclaredMethod(this.accessorMethod.getName(), new Class[0]);
                        reflectionMethod.setAccessible(true);
                        annotationFieldValue = reflectionMethod.invoke((Object)proxy, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException ex) {
                        throw VMError.shouldNotReachHere(ex);
                    }
                    catch (InvocationTargetException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof TypeNotPresentException) {
                            TypeNotPresentException tnpe = (TypeNotPresentException)cause;
                            annotationFieldValue = new TypeNotPresentExceptionProxy(tnpe.typeName(), new NoClassDefFoundError(tnpe.typeName()));
                        }
                        throw VMError.shouldNotReachHere(ex);
                    }
                    if (!(annotationFieldValue instanceof Class)) break block7;
                    Class classValue = (Class)annotationFieldValue;
                    if (!NativeImageClassLoader.classIsMissing(classValue)) break block8;
                    annotationFieldValue = new TypeNotPresentExceptionProxy(classValue.getName(), new NoClassDefFoundError(classValue.getName()));
                    break block8;
                }
                if (annotationFieldValue instanceof Class[]) {
                    for (Class classValue : (Class[])annotationFieldValue) {
                        if (!NativeImageClassLoader.classIsMissing(classValue)) continue;
                        annotationFieldValue = new TypeNotPresentExceptionProxy(classValue.getName(), new NoClassDefFoundError(classValue.getName()));
                        break;
                    }
                }
            }
            result = this.snippetReflection.forBoxed(this.getJavaKind(), annotationFieldValue);
            this.valueCache.put(receiver, result);
        }
        return result;
    }

    @Override
    public boolean allowConstantFolding() {
        return true;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return true;
    }

    public String toString() {
        return "AnnotationField<" + this.format("%h.%n") + ">";
    }
}

