/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import java.net.URL;
import java.net.URLClassLoader;
import jdk.internal.org.objectweb.asm.ClassWriter;
import jdk.internal.org.objectweb.asm.Type;

public class NativeImageClassLoader
extends URLClassLoader {
    public static boolean classIsMissing(Class<?> clazz) {
        return clazz != Ghost.class && Ghost.class.isAssignableFrom(clazz);
    }

    NativeImageClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (NativeImageClassLoader.mustNotReturnGhost(true)) {
                throw e;
            }
            return this.defineClass(name);
        }
        catch (IncompatibleClassChangeError e) {
            if (NativeImageClassLoader.mustNotReturnGhost(true)) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name);
        }
        if (NativeImageClassLoader.classIsMissing(clazz) && NativeImageClassLoader.mustNotReturnGhost(false)) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    private static boolean mustNotReturnGhost(boolean checkRecursiveLoaderCall) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int imageLoaderLoadClassCalls = 0;
        for (StackTraceElement element : trace) {
            if (NativeImageClassLoader.isCallTo(element, Class.class, "forName")) {
                return true;
            }
            if (!checkRecursiveLoaderCall || !NativeImageClassLoader.isCallTo(element, NativeImageClassLoader.class, "loadClass") || ++imageLoaderLoadClassCalls <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isCallTo(StackTraceElement element, Class<?> clazz, String methodName) {
        return element.getClassName().equals(clazz.getName()) && element.getMethodName().equals(methodName);
    }

    private Class<?> defineClass(String name) {
        byte[] b = NativeImageClassLoader.generateClass(name.replace('.', '/'));
        return this.defineClass(name, b, 0, b.length);
    }

    private static byte[] generateClass(String internalName) {
        ClassWriter cw = new ClassWriter(2);
        cw.visit(52, 1537, internalName, null, "java/lang/Object", new String[]{Type.getInternalName(Ghost.class)});
        return cw.toByteArray();
    }

    public static interface Ghost {
    }
}

