/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.word.Word;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public final class ImageClassLoader {
    private static final String CLASS_EXTENSION = ".class";
    private static final int CLASS_EXTENSION_LENGTH = ".class".length();
    private static final int CLASS_LOADING_TIMEOUT_IN_MINUTES = 10;
    private final Platform platform;
    private final ClassLoader classLoader;
    private final String[] classpath;
    private final EconomicSet<Class<?>> systemClasses = EconomicSet.create();
    private final EconomicSet<Method> systemMethods = EconomicSet.create();
    private final EconomicSet<Field> systemFields = EconomicSet.create();
    private static Set<Path> excludeDirectories;

    private ImageClassLoader(Platform platform, String[] classpath, ClassLoader classLoader) {
        this.platform = platform;
        this.classpath = classpath;
        this.classLoader = classLoader;
    }

    public static ImageClassLoader create(Platform platform, String[] classpathAll, ClassLoader classLoader) {
        ArrayList<String> classpathFiltered = new ArrayList<String>(classpathAll.length);
        classpathFiltered.addAll(Arrays.asList(classpathAll));
        String sunBootClassPath = System.getProperty("sun.boot.class.path");
        if (sunBootClassPath != null) {
            for (String s : sunBootClassPath.split(File.pathSeparator)) {
                if (!s.contains("graal-sdk")) continue;
                classpathFiltered.add(s);
            }
        }
        ImageClassLoader result = new ImageClassLoader(platform, classpathFiltered.toArray(new String[classpathFiltered.size()]), classLoader);
        result.initAllClasses();
        return result;
    }

    private static Path toRealPath(Path p) {
        try {
            return p.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            throw VMError.shouldNotReachHere("Path.toRealPath failed for " + p, e);
        }
    }

    private void initAllClasses() {
        ForkJoinPool executor = new ForkJoinPool(Runtime.getRuntime().availableProcessors());
        TreeSet<Path> uniquePaths = new TreeSet<Path>(Comparator.comparing(ImageClassLoader::toRealPath));
        uniquePaths.addAll(Arrays.stream(this.classpath).flatMap(ImageClassLoader::toClassPathEntries).collect(Collectors.toList()));
        uniquePaths.parallelStream().forEach(path -> this.loadClassesFromPath(executor, (Path)path));
        executor.awaitQuiescence(10L, TimeUnit.MINUTES);
    }

    static Stream<Path> toClassPathEntries(String classPathEntry) {
        Path entry = Paths.get(classPathEntry, new String[0]);
        if (entry.getFileName() != null && entry.getFileName().toString().endsWith("*")) {
            return Arrays.stream(entry.getParent().toFile().listFiles()).filter(File::isFile).map(File::toPath);
        }
        return Stream.of(entry);
    }

    private static Set<Path> getExcludeDirectories() {
        Path root = Paths.get("/", new String[0]);
        return Arrays.asList("dev", "sys", "proc", "etc", "var", "tmp", "boot", "lost+found").stream().map(root::resolve).collect(Collectors.toSet());
    }

    private void loadClassesFromPath(ForkJoinPool executor, Path path) {
        block18: {
            if (Files.exists(path, new LinkOption[0])) {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try {
                        URI jarURI = new URI("jar:" + path.toAbsolutePath().toUri());
                        try (FileSystem jarFileSystem = FileSystems.newFileSystem(jarURI, Collections.emptyMap());){
                            this.initAllClasses(jarFileSystem.getPath("/", new String[0]), Collections.emptySet(), executor);
                            break block18;
                        }
                    }
                    catch (ClosedByInterruptException ignored) {
                        throw new InterruptImageBuilding();
                    }
                    catch (IOException e) {
                        throw VMError.shouldNotReachHere(e);
                    }
                    catch (URISyntaxException e) {
                        throw VMError.shouldNotReachHere(e);
                    }
                }
                this.initAllClasses(path, excludeDirectories, executor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findSystemElements(Class<?> systemClass) {
        Object object;
        try {
            for (Method systemMethod : systemClass.getDeclaredMethods()) {
                if (!NativeImageGenerator.includedIn(this.platform, systemMethod.getAnnotation(Platforms.class))) continue;
                object = this.systemMethods;
                synchronized (object) {
                    this.systemMethods.add((Object)systemMethod);
                }
            }
        }
        catch (Throwable t) {
            this.handleClassLoadingError(t);
        }
        try {
            for (Field systemField : systemClass.getDeclaredFields()) {
                if (!NativeImageGenerator.includedIn(this.platform, systemField.getAnnotation(Platforms.class))) continue;
                object = this.systemFields;
                synchronized (object) {
                    this.systemFields.add((Object)systemField);
                }
            }
        }
        catch (Throwable t) {
            this.handleClassLoadingError(t);
        }
    }

    private void handleClassLoadingError(Throwable t) {
    }

    private void initAllClasses(final Path root, final Set<Path> excludes, final ForkJoinPool executor) {
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (excludes.contains(dir)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (excludes.contains(file.getParent())) {
                    return FileVisitResult.SKIP_SIBLINGS;
                }
                executor.execute(() -> {
                    block6: {
                        String fileName = root.relativize(file).toString();
                        if (fileName.endsWith(ImageClassLoader.CLASS_EXTENSION)) {
                            String unversionedClassName = this.unversionedFileName(fileName);
                            String className = this.curtail(unversionedClassName, CLASS_EXTENSION_LENGTH).replace('/', '.');
                            try {
                                Class systemClass = ImageClassLoader.this.forName(className);
                                if (!ImageClassLoader.this.includedInPlatform(systemClass)) break block6;
                                EconomicSet economicSet = ImageClassLoader.this.systemClasses;
                                synchronized (economicSet) {
                                    ImageClassLoader.this.systemClasses.add((Object)systemClass);
                                }
                                ImageClassLoader.this.findSystemElements(systemClass);
                            }
                            catch (Throwable t) {
                                ImageClassLoader.this.handleClassLoadingError(t);
                            }
                        }
                    }
                });
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            private String unversionedFileName(String fileName) {
                int versionedSuffixIndex;
                String versionedPrefix = "META-INF/versions/";
                String versionedSuffix = "/";
                String result = fileName;
                if (fileName.startsWith("META-INF/versions/") && (versionedSuffixIndex = fileName.indexOf("/", "META-INF/versions/".length())) >= 0) {
                    result = fileName.substring(versionedSuffixIndex + "/".length());
                }
                return result;
            }

            private String curtail(String str, int tailLength) {
                return str.substring(0, str.length() - tailLength);
            }
        };
        try {
            Files.walkFileTree(root, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }

    private boolean includedInPlatform(Class<?> clazz) {
        Class<?> cur = clazz;
        do {
            if (NativeImageGenerator.includedIn(this.platform, cur.getAnnotation(Platforms.class))) continue;
            return false;
        } while ((cur = cur.getEnclosingClass()) != null);
        return true;
    }

    public URL findResourceByName(String resource) {
        return this.classLoader.getResource(resource);
    }

    public InputStream findResourceAsStreamByName(String resource) {
        return this.classLoader.getResourceAsStream(resource);
    }

    public Class<?> findClassByName(String name) {
        return this.findClassByName(name, true);
    }

    public Class<?> findClassByName(String name, boolean failIfClassMissing) {
        try {
            if (name.indexOf(46) == -1) {
                switch (name) {
                    case "boolean": {
                        return Boolean.TYPE;
                    }
                    case "char": {
                        return Character.TYPE;
                    }
                    case "float": {
                        return Float.TYPE;
                    }
                    case "double": {
                        return Double.TYPE;
                    }
                    case "byte": {
                        return Byte.TYPE;
                    }
                    case "short": {
                        return Short.TYPE;
                    }
                    case "int": {
                        return Integer.TYPE;
                    }
                    case "long": {
                        return Long.TYPE;
                    }
                    case "void": {
                        return Void.TYPE;
                    }
                }
            }
            return this.forName(name);
        }
        catch (ClassNotFoundException ex) {
            if (failIfClassMissing) {
                throw VMError.shouldNotReachHere("class " + name + " not found");
            }
            return null;
        }
    }

    private Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> clazz = Class.forName(name, false, this.classLoader);
        if (NativeImageClassLoader.classIsMissing(clazz)) {
            throw new ClassNotFoundException(name);
        }
        return clazz;
    }

    public List<String> getClasspath() {
        return Collections.unmodifiableList(Arrays.asList(this.classpath));
    }

    public <T> List<Class<? extends T>> findSubclasses(Class<T> baseClass) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (Class systemClass : this.systemClasses) {
            if (!baseClass.isAssignableFrom(systemClass)) continue;
            result.add(systemClass.asSubclass(baseClass));
        }
        return result;
    }

    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotationClass) {
        ArrayList result = new ArrayList();
        for (Class systemClass : this.systemClasses) {
            if (systemClass.getAnnotation(annotationClass) == null) continue;
            result.add(systemClass);
        }
        return result;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotationClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            if (method.getAnnotation(annotationClass) == null) continue;
            result.add(method);
        }
        return result;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation>[] annotationClasses) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : this.systemMethods) {
            boolean match = true;
            for (Class<? extends Annotation> annotationClass : annotationClasses) {
                if (method.getAnnotation(annotationClass) != null) continue;
                match = false;
                break;
            }
            if (!match) continue;
            result.add(method);
        }
        return result;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotationClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : this.systemFields) {
            if (field.getAnnotation(annotationClass) == null) continue;
            result.add(field);
        }
        return result;
    }

    public List<Class<? extends Annotation>> allAnnotations() {
        return StreamSupport.stream(this.systemClasses.spliterator(), false).filter(Class::isAnnotation).map(clazz -> clazz).collect(Collectors.toList());
    }

    <T extends Annotation> List<T> findAnnotations(Class<T> annotationClass) {
        ArrayList<T> result = new ArrayList<T>();
        for (Class<?> clazz : this.findAnnotatedClasses(annotationClass)) {
            result.add(clazz.getAnnotation(annotationClass));
        }
        for (Method method : this.findAnnotatedMethods(annotationClass)) {
            result.add(method.getAnnotation(annotationClass));
        }
        for (Field field : this.findAnnotatedFields(annotationClass)) {
            result.add(field.getAnnotation(annotationClass));
        }
        return result;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static boolean isHostedClass(Class<?> clazz) {
        return clazz.getName().contains("hosted") || clazz.getName().contains("hotspot");
    }

    static {
        Word.ensureInitialized();
        excludeDirectories = ImageClassLoader.getExcludeDirectories();
    }
}

