/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.ClassInitializationInfo;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

@AutomaticFeature
public final class ClassInitializationFeature
implements Feature,
RuntimeClassInitializationSupport {
    private final Map<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private UnsupportedFeatures unsupportedFeatures;

    public static ClassInitializationFeature singleton() {
        return (ClassInitializationFeature)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
    }

    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        AnalysisType aType = ClassInitializationFeature.toAnalysisType(type);
        return this.computeInitKindAndMaybeInitializeClass(aType.getJavaClass()) != InitKind.EAGER;
    }

    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ClassInitializationFeature.toAnalysisType(type).getJavaClass());
    }

    public void forceInitializeHosted(ResolvedJavaType type) {
        this.forceInitializeHosted(ClassInitializationFeature.toAnalysisType(type).getJavaClass());
    }

    public void forceInitializeHosted(Class<?> clazz) {
        InitKind initKind = this.computeInitKindAndMaybeInitializeClass(clazz);
        if (initKind == InitKind.DELAY) {
            throw UserError.abort("Cannot delay running the class initializer because class must be initialized for internal purposes: " + clazz.getTypeName());
        }
    }

    private static AnalysisType toAnalysisType(ResolvedJavaType type) {
        return type instanceof HostedType ? ((HostedType)type).getWrapped() : (AnalysisType)type;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(RuntimeClassInitializationSupport.class, (Object)this);
        ClassInitializationFeature.processOption(access, Options.DelayClassInitialization, this::delayClassInitialization);
        ClassInitializationFeature.processOption(access, Options.RerunClassInitialization, this::rerunClassInitialization);
    }

    private static void processOption(Feature.AfterRegistrationAccess access, HostedOptionKey<String[]> option, Consumer<Class<?>[]> handler) {
        for (String className : OptionUtils.flatten(",", option.getValue())) {
            if (className.length() <= 0) continue;
            Class clazz = access.findClassByName(className);
            if (clazz == null) {
                throw UserError.abort("Could not find class " + className + " that is provided by the option " + SubstrateOptionsParser.commandArgument(option, className));
            }
            handler.accept(new Class[]{clazz});
        }
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.unsupportedFeatures = access.getBigBang().getUnsupportedFeatures();
        access.registerObjectReplacer(this::checkImageHeapInstance);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        this.checkDelayedInitialization();
        for (AnalysisType type : access.getUniverse().getTypes()) {
            DynamicHub hub;
            if (!type.isInTypeCheck() && !type.isInstantiated() || (hub = access.getHostVM().dynamicHub((ResolvedJavaType)type)).getClassInitializationInfo() != null) continue;
            this.buildClassInitializationInfo(access, type, hub);
            access.requireAnalysisIteration();
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.unsupportedFeatures = null;
    }

    public void afterImageWrite(Feature.AfterImageWriteAccess a) {
        this.checkDelayedInitialization();
    }

    private Object checkImageHeapInstance(Object obj) {
        if (obj != null && this.computeInitKindAndMaybeInitializeClass(obj.getClass()) != InitKind.EAGER) {
            throw new UnsupportedFeatureException("No instances are allowed in the image heap for a class that is initialized or reinitialized at image runtime: " + obj.getClass().getTypeName());
        }
        return obj;
    }

    private void checkDelayedInitialization() {
        for (Map.Entry<Class<?>, InitKind> entry : this.classInitKinds.entrySet()) {
            if (entry.getValue() != InitKind.DELAY || UnsafeAccess.UNSAFE.shouldBeInitialized(entry.getKey())) continue;
            throw UserError.abort("Class that is marked for delaying initialization to run time got initialized during image building: " + entry.getKey().getTypeName());
        }
    }

    private ClassInitializationInfo buildClassInitializationInfo(FeatureImpl.DuringAnalysisAccessImpl access, AnalysisType type, DynamicHub hub) {
        ClassInitializationInfo info;
        if (this.shouldInitializeAtRuntime((ResolvedJavaType)type)) {
            AnalysisMethod classInitializer = type.getClassInitializer();
            if (classInitializer != null) {
                access.registerAsCompiled(classInitializer);
            }
            info = new ClassInitializationInfo(MethodPointer.factory((ResolvedJavaMethod)classInitializer));
        } else {
            info = ClassInitializationInfo.INITIALIZED_INFO_SINGLETON;
        }
        hub.setClassInitializationInfo(info, ClassInitializationFeature.hasDefaultMethods((ResolvedJavaType)type), ClassInitializationFeature.declaresDefaultMethods((ResolvedJavaType)type));
        return info;
    }

    private static boolean hasDefaultMethods(ResolvedJavaType type) {
        if (!type.isInterface() && type.getSuperclass() != null && ClassInitializationFeature.hasDefaultMethods(type.getSuperclass())) {
            return true;
        }
        for (ResolvedJavaType iface : type.getInterfaces()) {
            if (!ClassInitializationFeature.hasDefaultMethods(iface)) continue;
            return true;
        }
        return ClassInitializationFeature.declaresDefaultMethods(type);
    }

    private static boolean declaresDefaultMethods(ResolvedJavaType type) {
        return ClassInitializationFeature.declaresDefaultMethods(ClassInitializationFeature.toAnalysisType(type).getJavaClass());
    }

    private static boolean declaresDefaultMethods(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isDefault()) continue;
            assert (!Modifier.isStatic(method.getModifiers())) : "Default method that is static?";
            return true;
        }
        return false;
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true);
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoizeEager) {
        InitKind result = this.classInitKinds.get(clazz);
        if (result != null) {
            return result;
        }
        result = InitKind.EAGER;
        if (clazz.getSuperclass() != null) {
            result = result.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoizeEager));
        }
        if ((result = result.max(this.processInterfaces(clazz, memoizeEager))) != InitKind.EAGER || memoizeEager) {
            if (result != InitKind.DELAY) {
                result = result.max(this.ensureClassInitialized(clazz));
            }
            InitKind previous = this.classInitKinds.put(clazz, result);
            assert (previous == null || previous == result) : "Overwriting existing value";
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager) {
        InitKind result = InitKind.EAGER;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = ClassInitializationFeature.declaresDefaultMethods(iface) ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager)) : result.max(this.processInterfaces(iface, memoizeEager));
        }
        return result;
    }

    private InitKind ensureClassInitialized(Class<?> clazz) {
        try {
            UnsafeAccess.UNSAFE.ensureClassInitialized(clazz);
            return InitKind.EAGER;
        }
        catch (Throwable ex) {
            if (NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time because either option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + " or option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " is used for image building. Use the option " + SubstrateOptionsParser.commandArgument(Options.DelayClassInitialization, clazz.getTypeName()) + " to explicitly request delayed initialization of this class.");
            } else {
                String msg = "Class initialization failed: " + clazz.getTypeName();
                if (this.unsupportedFeatures != null) {
                    this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, ex);
                } else {
                    throw UserError.abort(msg, ex);
                }
            }
            return InitKind.DELAY;
        }
    }

    public void delayClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            ClassInitializationFeature.checkEagerInitialization(clazz);
            if (!UnsafeAccess.UNSAFE.shouldBeInitialized(clazz)) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            InitKind previousKind = this.classInitKinds.put(clazz, InitKind.DELAY);
            if (previousKind == InitKind.EAGER) {
                throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: " + clazz.getTypeName());
            }
            if (previousKind != InitKind.RERUN) continue;
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: " + clazz.getTypeName());
        }
    }

    public void rerunClassInitialization(Class<?>[] classes) {
        for (Class<?> clazz : classes) {
            ClassInitializationFeature.checkEagerInitialization(clazz);
            try {
                UnsafeAccess.UNSAFE.ensureClassInitialized(clazz);
            }
            catch (Throwable ex) {
                throw UserError.abort("Class initialization failed: " + clazz.getTypeName(), ex);
            }
            this.computeInitKindAndMaybeInitializeClass(clazz, false);
            InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RERUN);
            if (previousKind == InitKind.EAGER) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
            }
            if (previousKind != InitKind.DELAY) continue;
            throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register re-running the class initializer: " + clazz.getTypeName());
        }
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized eagerly because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization: " + clazz.getTypeName());
        }
    }

    static enum InitKind {
        EAGER,
        RERUN,
        DELAY;


        InitKind max(InitKind other) {
            return this.ordinal() > other.ordinal() ? this : other;
        }
    }

    public static class Options {
        @APIOption(name="delay-class-initialization-to-runtime")
        @Option(help={"A comma-separated list of classes (and implicitly all of their subclasses) that are initialized at runtime and not during image building"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> DelayClassInitialization = new HostedOptionKey<Object>(null);
        @APIOption(name="rerun-class-initialization-at-runtime")
        @Option(help={"A comma-separated list of classes (and implicitly all of their subclasses) that are initialized both at runtime and during image building"}, type=OptionType.User)
        public static final HostedOptionKey<String[]> RerunClassInitialization = new HostedOptionKey<Object>(null);
    }
}

