/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.meta.SharedRuntimeMethod;
import com.oracle.svm.core.hub.AnnotationsEncoding;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.Replaced;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.meta.EncodedLineNumberTable;
import com.oracle.svm.graal.meta.SubstrateSignature;
import com.oracle.svm.graal.meta.SubstrateType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.DefaultProfilingInfo;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CEntryPoint;

public class SubstrateMethod
implements SharedRuntimeMethod,
Replaced {
    private final byte[] encodedLineNumberTable;
    private final int modifiers;
    private final String name;
    private final int hashCode;
    private SubstrateType declaringClass;
    private int encodedGraphStartOffset;
    private int vTableIndex;
    private Object annotationsEncoding;
    private int codeOffsetInImage;
    private int deoptOffsetInImage;
    @UnknownObjectField(types={SubstrateMethod[].class, SubstrateMethod.class}, canBeNull=true)
    protected Object implementations;
    private final boolean neverInline;
    private final boolean bridge;
    private SubstrateSignature signature;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateMethod(ResolvedJavaMethod original, HostedStringDeduplication stringTable) {
        this.encodedLineNumberTable = EncodedLineNumberTable.encode(original.getLineNumberTable());
        assert (original.getAnnotation(CEntryPoint.class) == null) : "Can't compile entry point method";
        this.modifiers = original.getModifiers();
        this.name = stringTable.deduplicate(original.getName(), true);
        this.neverInline = original.getAnnotation(NeverInline.class) != null;
        this.hashCode = original.hashCode();
        this.implementations = new SubstrateMethod[0];
        this.encodedGraphStartOffset = -1;
        this.bridge = original.isBridge();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public boolean setAnnotationsEncoding(Object annotationsEncoding) {
        boolean result = this.annotationsEncoding != annotationsEncoding;
        this.annotationsEncoding = annotationsEncoding;
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getAnnotationsEncoding() {
        return this.annotationsEncoding;
    }

    public byte[] getEncodedLineNumberTable() {
        return this.encodedLineNumberTable;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public void setLinks(SubstrateSignature signature, SubstrateType declaringClass) {
        this.signature = signature;
        this.declaringClass = declaringClass;
    }

    public boolean setImplementations(SubstrateMethod[] rawImplementations) {
        Object newImplementations = rawImplementations.length == 0 ? null : (rawImplementations.length == 1 ? rawImplementations[0] : (!(this.implementations instanceof SubstrateMethod[]) || !Arrays.equals((SubstrateMethod[])this.implementations, rawImplementations) ? rawImplementations : this.implementations));
        boolean result = this.implementations != newImplementations;
        this.implementations = newImplementations;
        return result;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getRawImplementations() {
        return this.implementations;
    }

    public void setSubstrateData(int vTableIndex, int codeOffsetInImage, int deoptOffsetInImage) {
        this.vTableIndex = vTableIndex;
        this.codeOffsetInImage = codeOffsetInImage;
        this.deoptOffsetInImage = deoptOffsetInImage;
    }

    @Override
    public int getCodeOffsetInImage() {
        assert (this.codeOffsetInImage != 0);
        return this.codeOffsetInImage;
    }

    @Override
    public int getDeoptOffsetInImage() {
        return this.deoptOffsetInImage;
    }

    @Override
    public int getEncodedGraphStartOffset() {
        return this.encodedGraphStartOffset;
    }

    public void setEncodedGraphStartOffset(long encodedGraphStartOffset) {
        this.encodedGraphStartOffset = TypeConversion.asS4((long)encodedGraphStartOffset);
    }

    @Override
    public boolean isEntryPoint() {
        return false;
    }

    public SubstrateMethod[] getImplementations() {
        if (this.implementations == null) {
            return new SubstrateMethod[0];
        }
        if (this.implementations instanceof SubstrateMethod) {
            return new SubstrateMethod[]{(SubstrateMethod)this.implementations};
        }
        return (SubstrateMethod[])this.implementations;
    }

    @Override
    public boolean isDeoptTarget() {
        return false;
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public int getVTableIndex() {
        if (this.vTableIndex < 0) {
            throw VMError.shouldNotReachHere("no vtable index");
        }
        return this.vTableIndex;
    }

    @Override
    public Deoptimizer.StubType getDeoptStubType() {
        return Deoptimizer.StubType.NoDeoptStub;
    }

    public String getName() {
        return this.name;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public byte[] getCode() {
        return null;
    }

    public int getCodeSize() {
        return 0;
    }

    public SubstrateType getDeclaringClass() {
        return this.declaringClass;
    }

    public int getMaxLocals() {
        return this.getSignature().getParameterCount(!Modifier.isStatic(this.getModifiers())) * 2;
    }

    public int getMaxStackSize() {
        return 2;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isClassInitializer() {
        assert (!"<clinit>".equals(this.name) || !this.isStatic()) : "class initializers are executed during native image generation and are never in the native image";
        return false;
    }

    public boolean isConstructor() {
        return "<init>".equals(this.name) && !this.isStatic();
    }

    public boolean canBeStaticallyBound() {
        return this.equals(this.implementations);
    }

    public ExceptionHandler[] getExceptionHandlers() {
        throw VMError.shouldNotReachHere();
    }

    public StackTraceElement asStackTraceElement(int bci) {
        int lineNumber = EncodedLineNumberTable.getLineNumber(bci, this.encodedLineNumberTable);
        return new StackTraceElement(this.getDeclaringClass().toClassName(), this.getName(), this.getDeclaringClass().getSourceFileName(), lineNumber);
    }

    public ProfilingInfo getProfilingInfo(boolean includeNormal, boolean includeOSR) {
        return DefaultProfilingInfo.get((TriState)TriState.UNKNOWN);
    }

    public void reprofile() {
        throw VMError.unimplemented();
    }

    public ConstantPool getConstantPool() {
        throw VMError.shouldNotReachHere();
    }

    public Annotation[] getAnnotations() {
        return AnnotationsEncoding.getAnnotations(this.annotationsEncoding);
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return AnnotationsEncoding.getAnnotation(this.annotationsEncoding, annotationClass);
    }

    public Annotation[][] getParameterAnnotations() {
        throw VMError.unimplemented();
    }

    public Type[] getGenericParameterTypes() {
        throw VMError.unimplemented();
    }

    public boolean canBeInlined() {
        return !this.hasNeverInlineDirective();
    }

    public boolean hasNeverInlineDirective() {
        return this.neverInline || this.encodedGraphStartOffset < 0;
    }

    public boolean shouldBeInlined() {
        return false;
    }

    public LineNumberTable getLineNumberTable() {
        return EncodedLineNumberTable.decode(this.encodedLineNumberTable);
    }

    public LocalVariableTable getLocalVariableTable() {
        return null;
    }

    public Constant getEncoding() {
        throw VMError.unimplemented();
    }

    public boolean isInVirtualMethodTable(ResolvedJavaType resolved) {
        throw VMError.unimplemented();
    }

    public boolean isSynthetic() {
        return false;
    }

    public boolean isVarArgs() {
        throw VMError.unimplemented();
    }

    public boolean isBridge() {
        return this.bridge;
    }

    public boolean isDefault() {
        throw VMError.unimplemented();
    }

    public SpeculationLog getSpeculationLog() {
        throw VMError.shouldNotReachHere();
    }

    public String toString() {
        return "SubstrateMethod<" + this.format("%h.%n") + ">";
    }
}

