/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.deopt.DeoptTester;
import com.oracle.svm.core.deopt.DeoptimizationCounters;
import com.oracle.svm.core.deopt.DeoptimizationRuntime;
import com.oracle.svm.core.deopt.DeoptimizationSupport;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.snippets.DeoptTestSnippets;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.util.CounterFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.meta.HostedMetaAccess;
import com.oracle.svm.hosted.meta.MethodPointer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

public final class DeoptimizationFeature
implements GraalFeature {
    private static final Method deoptStubMethod;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(CounterFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(DeoptimizationSupport.class, (Object)new DeoptimizationSupport());
        ImageSingletons.add(DeoptimizationCounters.class, (Object)new DeoptimizationCounters());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        access.registerAsCompiled(deoptStubMethod);
        access.registerAsCompiled((AnalysisMethod)DeoptimizationRuntime.DEOPTIMIZE.findMethod((MetaAccessProvider)access.getMetaAccess()));
        if (DeoptTester.enabled()) {
            access.getBigBang().addRootMethod((AnalysisMethod)DeoptTester.DEOPTTEST.findMethod((MetaAccessProvider)access.getMetaAccess()));
        }
    }

    @Override
    public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
        foreignCalls.put(DeoptimizationRuntime.DEOPTIMIZE, new SubstrateForeignCallLinkage(providers, DeoptimizationRuntime.DEOPTIMIZE));
        if (DeoptTester.enabled()) {
            foreignCalls.put(DeoptTester.DEOPTTEST, new SubstrateForeignCallLinkage(providers, DeoptTester.DEOPTTEST));
        }
    }

    @Override
    public void registerLowerings(RuntimeConfiguration runtimeConfig, OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings, boolean hosted) {
        if (DeoptTester.enabled()) {
            DeoptTestSnippets.registerLowerings(options, factories, providers, snippetReflection, lowerings);
        }
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        HostedMetaAccess metaAccess = config.getMetaAccess();
        DeoptimizationSupport.setDeoptStubPointer(MethodPointer.factory(metaAccess.lookupJavaMethod(deoptStubMethod)));
    }

    static {
        try {
            deoptStubMethod = Deoptimizer.class.getMethod("deoptStub", DeoptimizedFrame.class);
        }
        catch (NoSuchMethodException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

