/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.linux;

import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.posix.headers.Time;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.constant.CConstant;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.struct.CFieldAddress;
import org.graalvm.nativeimage.c.struct.CPointerTo;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
@Platforms(value={Platform.LINUX.class})
public class LinuxTime
extends Time {
    @CConstant
    public static native int CLOCK_REALTIME();

    @CConstant
    public static native int CLOCK_MONOTONIC();

    @CConstant
    public static native int CLOCK_PROCESS_CPUTIME_ID();

    @CConstant
    public static native int CLOCK_THREAD_CPUTIME_ID();

    @CConstant
    public static native int TIMER_ABSTIME();

    @CFunction
    @CLibrary(value="rt")
    public static native int clock_getres(int var0, Time.timespec var1);

    @CFunction(transition=CFunction.Transition.NO_TRANSITION)
    @CLibrary(value="rt")
    public static native int clock_gettime(int var0, Time.timespec var1);

    @CFunction
    @CLibrary(value="rt")
    public static native int clock_settime(int var0, Time.timespec var1);

    @CFunction
    @CLibrary(value="rt")
    public static native int clock_nanosleep(int var0, int var1, Time.timespec var2, Time.timespec var3);

    @CFunction
    @CLibrary(value="rt")
    public static native int clock_getcpuclockid(int var0, CIntPointer var1);

    @CFunction
    public static native int timer_delete(timer_t var0);

    @CFunction
    public static native int timer_settime(timer_t var0, int var1, itimerspec var2, itimerspec var3);

    @CFunction
    public static native int timer_gettime(timer_t var0, itimerspec var1);

    @CFunction
    public static native int timer_getoverrun(timer_t var0);

    @CFunction
    public static native int timespec_get(Time.timespec var0, int var1);

    @CFunction
    public static native int getdate_err();

    @CFunction
    public static native Time.tm getdate(CCharPointer var0);

    @CFunction
    public static native int getdate_r(CCharPointer var0, Time.tm var1);

    @CPointerTo(nameOfCType="timer_t")
    public static interface timer_tPointer
    extends PointerBase {
    }

    public static interface timer_t
    extends PointerBase {
    }

    @CStruct(addStructKeyword=true)
    public static interface itimerspec
    extends PointerBase {
        @CFieldAddress
        public Time.timespec it_interval();

        @CFieldAddress
        public Time.timespec it_value();
    }
}

