/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.os.IsDefined;
import com.oracle.svm.core.posix.JavaNetNetUtil;
import com.oracle.svm.core.posix.JavaNetNetUtilMD;
import com.oracle.svm.core.posix.JavavmExportJvm;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.Target_java_lang_System;
import com.oracle.svm.core.posix.Target_jvm;
import com.oracle.svm.core.posix.Target_os;
import com.oracle.svm.core.posix.Util_java_net_InetAddressContainer;
import com.oracle.svm.core.posix.Util_java_net_PlainSocketImpl;
import com.oracle.svm.core.posix.Util_java_net_SocketImpl;
import com.oracle.svm.core.posix.Util_jni;
import com.oracle.svm.core.posix.VmPrimsJVM;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.LibC;
import com.oracle.svm.core.posix.headers.NetinetIn;
import com.oracle.svm.core.posix.headers.Poll;
import com.oracle.svm.core.posix.headers.Socket;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.VMError;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketTimeoutException;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CIntPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;
import sun.net.ConnectionResetException;

@TargetClass(className="java.net.PlainSocketImpl")
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_net_PlainSocketImpl {
    Target_java_net_PlainSocketImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    void socketCreate(boolean stream) throws IOException, InterruptedException {
        ServerSocket ssObj;
        CIntPointer argPointer;
        int type;
        int n = type = stream ? Socket.SOCK_STREAM() : Socket.SOCK_DGRAM();
        int domain = IsDefined.socket_AF_INET6() ? (JavaNetNetUtil.ipv6_available() ? Socket.AF_INET6() : Socket.AF_INET()) : Socket.AF_INET();
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("null fd object");
        }
        int fd = Socket.socket(domain, type, 0);
        if (fd == Target_jvm.JVM_IO_ERR()) {
            JavaNetNetUtilMD.NET_ThrowNew(Errno.errno(), "can't create socket");
            return;
        }
        if (IsDefined.socket_AF_INET6() && domain == Socket.AF_INET6()) {
            argPointer = (CIntPointer)StackValue.get(CIntPointer.class);
            argPointer.write(0);
            if (Socket.setsockopt(fd, NetinetIn.IPPROTO_IPV6(), NetinetIn.IPV6_V6ONLY(), (PointerBase)argPointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    JavaNetNetUtilMD.NET_ThrowNew(Errno.errno(), "cannot set IPPROTO_IPV6");
                }
                finally {
                    Unistd.close(fd);
                }
            }
        }
        if ((ssObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).serverSocket) != null) {
            argPointer = (CIntPointer)StackValue.get(CIntPointer.class);
            argPointer.write(1);
            Util_java_net_PlainSocketImpl.SET_NONBLOCKING(fd);
            if (Socket.setsockopt(fd, Socket.SOL_SOCKET(), Socket.SO_REUSEADDR(), (PointerBase)argPointer, SizeOf.get(CIntPointer.class)) < 0) {
                try {
                    JavaNetNetUtilMD.NET_ThrowNew(Errno.errno(), "cannot set SO_REUSEADDR");
                }
                finally {
                    Unistd.close(fd);
                }
            }
        }
        PosixUtils.setFD(fdObj, fd);
    }

    @Substitute
    int socketAvailable() throws IOException {
        CIntPointer ret_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        ret_Pointer.write(-1);
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (!CTypeConversion.toBoolean((int)VmPrimsJVM.JVM_SocketAvailable(fd, ret_Pointer))) {
            if (Errno.errno() == Errno.ECONNRESET()) {
                throw new ConnectionResetException("");
            }
            throw new SocketException(PosixUtils.lastErrorString("ioctl FIONREAD failed"));
        }
        return ret_Pointer.read();
    }

    @Substitute
    void socketBind(InetAddress iaObj, int localportArg) throws IOException {
        int localport = localportArg;
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(0);
        Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (iaObj == null) {
            throw new NullPointerException("iaObj is null.");
        }
        if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(iaObj, localport, him, len_Pointer, Util_jni.JNI_TRUE()) != 0) {
            return;
        }
        JavaNetNetUtilMD.setDefaultScopeID(him);
        if (JavaNetNetUtilMD.NET_Bind(fd, him, len_Pointer.read()) < 0) {
            if (Errno.errno() == Errno.EADDRINUSE() || Errno.errno() == Errno.EADDRNOTAVAIL() || Errno.errno() == Errno.EPERM() || Errno.errno() == Errno.EACCES()) {
                throw new BindException(PosixUtils.lastErrorString("Bind failed"));
            }
            throw new SocketException(PosixUtils.lastErrorString("Bind failed"));
        }
        Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).address = iaObj;
        if (localport == 0) {
            if (VmPrimsJVM.JVM_GetSockName(fd, him, len_Pointer) == -1) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket name"));
            }
            Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).localport = localport = JavaNetNetUtilMD.NET_GetPortFromSockaddr(him);
        } else {
            Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).localport = localport;
        }
    }

    @Substitute
    void socketClose0(boolean useDeferredClose) throws IOException {
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("socket already closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (fd != -1) {
            if (useDeferredClose && Util_java_net_PlainSocketImpl.marker_fd >= 0) {
                JavaNetNetUtilMD.NET_Dup2(Util_java_net_PlainSocketImpl.marker_fd, fd);
            } else {
                PosixUtils.setFD(fdObj, -1);
                JavaNetNetUtilMD.NET_SocketClose(fd);
            }
        }
    }

    @Substitute
    void socketConnect(InetAddress iaObj, int port, int timeoutArg) throws IOException {
        int timeout = timeoutArg;
        int localport = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).localport;
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(0);
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        int trafficClass = Util_java_net_PlainSocketImpl.as_Target_java_net_AbstractPlainSocketImpl((Target_java_net_PlainSocketImpl)this).trafficClass;
        Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        CIntPointer connect_rv_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        connect_rv_Pointer.write(-1);
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (iaObj == null) {
            throw new NullPointerException("inet address argument null.");
        }
        if (JavaNetNetUtilMD.NET_InetAddressToSockaddr(iaObj, port, him, len_Pointer, Util_jni.JNI_TRUE()) != 0) {
            return;
        }
        JavaNetNetUtilMD.setDefaultScopeID(him);
        if (IsDefined.socket_AF_INET6() && trafficClass != 0 && JavaNetNetUtil.ipv6_available()) {
            JavaNetNetUtilMD.NET_SetTrafficClass(him, trafficClass);
        }
        if (timeout <= 0) {
            connect_rv_Pointer.write(JavaNetNetUtilMD.NET_Connect(fd, him, len_Pointer.read()));
        } else {
            Util_java_net_PlainSocketImpl.SET_NONBLOCKING(fd);
            connect_rv_Pointer.write(Socket.connect(fd, him, len_Pointer.read()));
            if (connect_rv_Pointer.read() != 0) {
                CIntPointer optlen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
                long prevTime = Target_java_lang_System.currentTimeMillis();
                if (Errno.errno() != Errno.EINPROGRESS()) {
                    try {
                        throw new ConnectException(PosixUtils.lastErrorString("connect failed"));
                    }
                    catch (Throwable throwable) {
                        Util_java_net_PlainSocketImpl.SET_BLOCKING(fd);
                        throw throwable;
                    }
                }
                while (true) {
                    Poll.pollfd pfd = (Poll.pollfd)StackValue.get(Poll.pollfd.class);
                    pfd.set_fd(fd);
                    pfd.set_events(Poll.POLLOUT());
                    Errno.set_errno(0);
                    connect_rv_Pointer.write(JavaNetNetUtilMD.NET_Poll(pfd, 1, timeout));
                    if (connect_rv_Pointer.read() >= 0 || Errno.errno() != Errno.EINTR()) break;
                    long newTime = Target_java_lang_System.currentTimeMillis();
                    if ((timeout = (int)((long)timeout - (newTime - prevTime))) <= 0) {
                        connect_rv_Pointer.write(0);
                        break;
                    }
                    prevTime = newTime;
                }
                if (connect_rv_Pointer.read() == 0) {
                    try {
                        throw new SocketTimeoutException("connect timed out");
                    }
                    catch (Throwable throwable) {
                        Util_java_net_PlainSocketImpl.SET_BLOCKING(fd);
                        VmPrimsJVM.JVM_SocketShutdown(fd, 2);
                        throw throwable;
                    }
                }
                optlen_Pointer.write(SizeOf.get(CIntPointer.class));
                if (VmPrimsJVM.JVM_GetSockOpt(fd, Socket.SOL_SOCKET(), Socket.SO_ERROR(), (CCharPointer)connect_rv_Pointer, optlen_Pointer) < 0) {
                    connect_rv_Pointer.write(Errno.errno());
                }
            }
            Util_java_net_PlainSocketImpl.SET_BLOCKING(fd);
            if (connect_rv_Pointer.read() != 0) {
                Errno.set_errno(connect_rv_Pointer.read());
                connect_rv_Pointer.write(Target_jvm.JVM_IO_ERR());
            }
        }
        if (connect_rv_Pointer.read() < 0) {
            if (IsDefined.__linux__() && connect_rv_Pointer.read() == Target_jvm.JVM_IO_ERR() && Errno.errno() == Errno.EINVAL()) {
                throw new SocketException("Invalid argument or cannot assign requested address");
            }
            if (connect_rv_Pointer.read() == Target_jvm.JVM_IO_INTR()) {
                throw new InterruptedIOException("operation interrupted");
            }
            if (Errno.errno() == Errno.EPROTO()) {
                throw new ProtocolException(PosixUtils.lastErrorString("Protocol error"));
            }
            if (Errno.errno() == Errno.ECONNREFUSED()) {
                throw new ConnectException(PosixUtils.lastErrorString("Connection refused"));
            }
            if (Errno.errno() == Errno.ETIMEDOUT()) {
                throw new ConnectException(PosixUtils.lastErrorString("Connection timed out"));
            }
            if (Errno.errno() == Errno.EHOSTUNREACH()) {
                throw new NoRouteToHostException(PosixUtils.lastErrorString("Host unreachable"));
            }
            if (Errno.errno() == Errno.EADDRNOTAVAIL()) {
                throw new NoRouteToHostException(PosixUtils.lastErrorString("Address not available"));
            }
            if (Errno.errno() == Errno.EISCONN() || Errno.errno() == Errno.EBADF()) {
                throw new SocketException(PosixUtils.lastErrorString("Socket closed"));
            }
            throw new SocketException(PosixUtils.lastErrorString("connect failed"));
        }
        PosixUtils.setFD(fdObj, fd);
        Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).address = iaObj;
        Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).port = port;
        if (localport == 0) {
            len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (VmPrimsJVM.JVM_GetSockName(fd, him, len_Pointer) == -1) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket name"));
            }
            Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).localport = localport = JavaNetNetUtilMD.NET_GetPortFromSockaddr(him);
        }
    }

    @Substitute
    void socketListen(int countArg) throws IOException {
        int count = countArg;
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (count == Integer.MAX_VALUE) {
            --count;
        }
        if (VmPrimsJVM.JVM_Listen(fd, count) == JavavmExportJvm.JvmIoErrorCode.JVM_IO_ERR()) {
            throw new SocketException(PosixUtils.lastErrorString("Listen failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    void socketAccept(SocketImpl socket) throws IOException {
        int thisLocalPort;
        InetAddress socketAddressObj;
        CIntPointer port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int timeout = Util_java_net_PlainSocketImpl.as_Target_java_net_AbstractPlainSocketImpl((Target_java_net_PlainSocketImpl)this).timeout;
        long prevTime = 0L;
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        int newfd = -1;
        Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
        CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
        if (fdObj == null) {
            throw new SocketException("Socket closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        if (socket == null) {
            throw new NullPointerException("socket is null");
        }
        try {
            while (true) {
                int ret;
                if (prevTime == 0L && timeout > 0) {
                    prevTime = System.currentTimeMillis();
                }
                if ((ret = timeout <= 0 ? JavaNetNetUtilMD.NET_Timeout(fd, -1L) : JavaNetNetUtilMD.NET_Timeout(fd, timeout)) == 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                if (ret == Target_jvm.JVM_IO_ERR()) {
                    if (Errno.errno() == Errno.EBADF()) {
                        throw new SocketException("Socket closed");
                    }
                    if (Errno.errno() == Errno.ENOMEM()) {
                        throw new OutOfMemoryError("NET_Timeout native heap allocation failed");
                    }
                    throw new SocketException(PosixUtils.lastErrorString("Accept failed"));
                }
                if (ret == Target_jvm.JVM_IO_INTR()) {
                    throw new InterruptedIOException("operation interrupted");
                }
                newfd = JavaNetNetUtilMD.NET_Accept(fd, him, len_Pointer);
                if (newfd >= 0) {
                    Util_java_net_PlainSocketImpl.SET_BLOCKING(newfd);
                    break;
                }
                if (Errno.errno() != Errno.ECONNABORTED() && Errno.errno() != Errno.EWOULDBLOCK()) break;
                if (!CTypeConversion.toBoolean((int)timeout)) continue;
                long currTime = System.currentTimeMillis();
                if ((timeout = (int)((long)timeout - (currTime - prevTime))) <= 0) {
                    throw new SocketTimeoutException("Accept timed out");
                }
                prevTime = currTime;
            }
            if (newfd < 0) {
                if (newfd == -2) {
                    throw new InterruptedIOException("operation interrupted");
                }
                if (Errno.errno() == Errno.EINVAL()) {
                    Errno.set_errno(Errno.EBADF());
                }
                if (Errno.errno() == Errno.EBADF()) {
                    throw new SocketException("Socket closed");
                }
                throw new SocketException(PosixUtils.lastErrorString("Accept failed"));
            }
        }
        finally {
            socketAddressObj = JavaNetNetUtil.NET_SockaddrToInetAddress(him, port_Pointer);
            if (socketAddressObj == null) {
                Unistd.close(newfd);
            }
        }
        FileDescriptor socketFdObj = Util_java_net_SocketImpl.from_SocketImpl((SocketImpl)socket).fd;
        PosixUtils.setFD(socketFdObj, newfd);
        Util_java_net_SocketImpl.from_SocketImpl((SocketImpl)socket).address = socketAddressObj;
        Util_java_net_SocketImpl.from_SocketImpl((SocketImpl)socket).port = port_Pointer.read();
        Util_java_net_SocketImpl.from_SocketImpl((SocketImpl)socket).localport = thisLocalPort = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).localport;
    }

    @Substitute
    void socketShutdown(int howto) throws IOException {
        FileDescriptor fdObj = Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd;
        if (fdObj == null) {
            throw new SocketException("socket already closed");
        }
        int fd = PosixUtils.getFD(fdObj);
        VmPrimsJVM.JVM_SocketShutdown(fd, howto);
    }

    @Substitute
    static void initProto() {
        VMError.unimplemented();
    }

    @Substitute
    void socketSetOption(int cmd, boolean on, Object value) throws SocketException {
        int optlen;
        CIntPointer level_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optname_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int sizeof_optval = SizeOf.get(Socket.linger.class);
        VMError.guarantee(SizeOf.get(CIntPointer.class) <= sizeof_optval, "sizeof(int) <= sizeof(union optval)");
        VMError.guarantee(SizeOf.get(Socket.linger.class) <= sizeof_optval, "sizeof(struct linger) <= sizeof(union optval)");
        WordPointer optval_Pointer = (WordPointer)StackValue.get((int)sizeof_optval);
        int fd = PosixUtils.getFD(Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd);
        if (fd < 0) {
            throw new SocketException("Socket closed");
        }
        if (cmd == 4102) {
            return;
        }
        if (CTypeConversion.toBoolean((int)JavaNetNetUtilMD.NET_MapSocketOption(cmd, level_Pointer, optname_Pointer))) {
            throw new SocketException("Invalid option");
        }
        switch (cmd) {
            case 3: 
            case 128: 
            case 4097: 
            case 4098: {
                Integer valueInteger = (Integer)value;
                if (cmd == 128) {
                    if (on) {
                        ((Socket.linger)optval_Pointer).set_l_onoff(1);
                        ((Socket.linger)optval_Pointer).set_l_linger(valueInteger);
                    } else {
                        ((Socket.linger)optval_Pointer).set_l_onoff(0);
                        ((Socket.linger)optval_Pointer).set_l_linger(0);
                    }
                    optlen = SizeOf.get(Socket.linger.class);
                    LibC.memcpy(optval_Pointer, (PointerBase)optval_Pointer, WordFactory.unsigned((int)optlen));
                    break;
                }
                ((CIntPointer)optval_Pointer).write(valueInteger.intValue());
                optlen = SizeOf.get(CIntPointer.class);
                LibC.memcpy(optval_Pointer, (PointerBase)optval_Pointer, WordFactory.unsigned((int)optlen));
                break;
            }
            default: {
                ((CIntPointer)optval_Pointer).write(on ? 1 : 0);
                optlen = SizeOf.get(CIntPointer.class);
                LibC.memcpy(optval_Pointer, (PointerBase)optval_Pointer, WordFactory.unsigned((int)optlen));
            }
        }
        if (JavaNetNetUtilMD.NET_SetSockOpt(fd, level_Pointer.read(), optname_Pointer.read(), optval_Pointer, optlen) < 0) {
            if (Errno.errno() == Errno.EINVAL()) {
                throw new SocketException("Invalid option or socket reset by remote peer");
            }
            throw new SocketException(PosixUtils.lastErrorString("Error setting socket option"));
        }
    }

    @Substitute
    int socketGetOption(int cmd, Object iaContainerObj) throws SocketException {
        CIntPointer level_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optname_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        CIntPointer optlen_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
        int sizeof_optval = SizeOf.get(Socket.linger.class);
        VMError.guarantee(SizeOf.get(CIntPointer.class) <= sizeof_optval, "sizeof(int) <= sizeof(union optval)");
        VMError.guarantee(SizeOf.get(Socket.linger.class) <= sizeof_optval, "sizeof(struct linger) <= sizeof(union optval)");
        WordPointer optval_Pointer = (WordPointer)StackValue.get((int)sizeof_optval);
        int fd = PosixUtils.getFD(Util_java_net_PlainSocketImpl.as_Target_java_net_SocketImpl((Target_java_net_PlainSocketImpl)this).fd);
        if (fd < 0) {
            throw new SocketException("Socket closed");
        }
        if (cmd == 15) {
            Socket.sockaddr him = (Socket.sockaddr)StackValue.get((int)JavaNetNetUtilMD.SOCKADDR_LEN());
            CIntPointer len_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            CIntPointer port_Pointer = (CIntPointer)StackValue.get(CIntPointer.class);
            len_Pointer.write(JavaNetNetUtilMD.SOCKADDR_LEN());
            if (Target_os.get_sock_name(fd, him, len_Pointer) < 0) {
                throw new SocketException(PosixUtils.lastErrorString("Error getting socket name"));
            }
            InetAddress iaObj = JavaNetNetUtil.NET_SockaddrToInetAddress(him, port_Pointer);
            if (iaObj == null) {
                return -1;
            }
            if (Util_java_net_InetAddressContainer.setAddr(iaContainerObj, iaObj)) {
                return 0;
            }
            return -1;
        }
        if (CTypeConversion.toBoolean((int)JavaNetNetUtilMD.NET_MapSocketOption(cmd, level_Pointer, optname_Pointer))) {
            throw new SocketException("Invalid option");
        }
        if (cmd == 128) {
            optlen_Pointer.write(SizeOf.get(Socket.linger.class));
        } else {
            optlen_Pointer.write(SizeOf.get(CIntPointer.class));
        }
        if (JavaNetNetUtilMD.NET_GetSockOpt(fd, level_Pointer.read(), optname_Pointer.read(), (PointerBase)optval_Pointer, optlen_Pointer) < 0) {
            throw new SocketException(PosixUtils.lastErrorString("Error getting socket option"));
        }
        switch (cmd) {
            case 128: {
                if (CTypeConversion.toBoolean((int)((Socket.linger)optval_Pointer).l_onoff())) {
                    return ((Socket.linger)optval_Pointer).l_linger();
                }
                return -1;
            }
            case 3: 
            case 4097: 
            case 4098: {
                return ((CIntPointer)optval_Pointer).read();
            }
        }
        if (((CIntPointer)optval_Pointer).read() == 0) {
            return -1;
        }
        return 1;
    }

    @Substitute
    void socketSendUrgentData(int data) throws IOException {
        VMError.unimplemented();
    }
}

