/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.jdk.JDK8OrEarlier;
import com.oracle.svm.core.posix.Java_lang_UNIXProcess_Supplement;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullInputStream;
import com.oracle.svm.core.posix.Target_java_lang_ProcessBuilder_NullOutputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeInputStream;
import com.oracle.svm.core.posix.Target_java_lang_UNIXProcess_ProcessPipeOutputStream;
import com.oracle.svm.core.posix.headers.Errno;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.posix.headers.Wait;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CIntPointer;

@TargetClass(className="java.lang.UNIXProcess", onlyWith={JDK8OrEarlier.class})
@Platforms(value={Platform.LINUX.class, Platform.DARWIN.class})
final class Target_java_lang_UNIXProcess {
    @Delete
    static final Executor processReaperExecutor = null;
    @Alias
    int pid;
    @Alias
    OutputStream stdin;
    @Alias
    InputStream stdout;
    @Alias
    InputStream stderr;
    @Alias
    int exitcode;
    @Alias
    boolean hasExited;

    Target_java_lang_UNIXProcess() {
    }

    /*
     * Exception decompiling
     */
    @Substitute
    int forkAndExec(int mode, byte[] helperpath, byte[] file, byte[] argBlock, int argCount, byte[] envBlock, int envCount, byte[] dir, int[] fds, boolean redirectErrorStream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Substitute
    void initStreams(int[] fds) {
        Object in = Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE;
        if (fds[0] != -1) {
            in = new Target_java_lang_UNIXProcess_ProcessPipeOutputStream(fds[0]);
        }
        this.stdin = KnownIntrinsics.unsafeCast(in, OutputStream.class);
        Object out = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[1] != -1) {
            out = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[1]);
        }
        this.stdout = KnownIntrinsics.unsafeCast(out, InputStream.class);
        Object err = Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE;
        if (fds[2] != -1) {
            err = new Target_java_lang_UNIXProcess_ProcessPipeInputStream(fds[2]);
        }
        this.stderr = KnownIntrinsics.unsafeCast(err, InputStream.class);
        Thread reaperThread = Java_lang_UNIXProcess_Supplement.reaperFactory.newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int status = Target_java_lang_UNIXProcess.this.waitForProcessExit(Target_java_lang_UNIXProcess.this.pid);
                Target_java_lang_UNIXProcess target_java_lang_UNIXProcess = Target_java_lang_UNIXProcess.this;
                synchronized (target_java_lang_UNIXProcess) {
                    Target_java_lang_UNIXProcess.this.exitcode = status;
                    Target_java_lang_UNIXProcess.this.hasExited = true;
                    Target_java_lang_UNIXProcess.this.notifyAll();
                }
                if (Target_java_lang_UNIXProcess.this.stdout != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stdout, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (Target_java_lang_UNIXProcess.this.stderr != Target_java_lang_ProcessBuilder_NullInputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stderr, Target_java_lang_UNIXProcess_ProcessPipeInputStream.class).processExited();
                }
                if (Target_java_lang_UNIXProcess.this.stdin != Target_java_lang_ProcessBuilder_NullOutputStream.INSTANCE) {
                    KnownIntrinsics.unsafeCast(Target_java_lang_UNIXProcess.this.stdin, Target_java_lang_UNIXProcess_ProcessPipeOutputStream.class).processExited();
                }
            }
        });
        reaperThread.start();
    }

    @Substitute
    int waitForProcessExit(int ppid) {
        CIntPointer statusptr = (CIntPointer)StackValue.get(CIntPointer.class);
        while (Wait.waitpid(ppid, statusptr, 0) < 0) {
            if (Errno.errno() == Errno.ECHILD()) {
                return 0;
            }
            if (Errno.errno() == Errno.EINTR()) continue;
            return -1;
        }
        int status = statusptr.read();
        if (Wait.WIFEXITED(status)) {
            return Wait.WEXITSTATUS(status);
        }
        if (Wait.WIFSIGNALED(status)) {
            return 128 + Wait.WTERMSIG(status);
        }
        return status;
    }

    @Substitute
    static void destroyProcess(int ppid, boolean force) {
        int sig = force ? Signal.SignalEnum.SIGKILL.getCValue() : Signal.SignalEnum.SIGTERM.getCValue();
        Signal.kill(ppid, sig);
    }
}

