/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.IsolateEnterStub;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.snippets.ImplicitExceptions;
import com.oracle.svm.core.stack.StackFrameVisitor;
import java.util.ArrayList;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public class StackTraceBuilder
implements StackFrameVisitor {
    private final ArrayList<StackTraceElement> trace = new ArrayList();
    private final boolean filterExceptions;

    public StackTraceBuilder(boolean filterExceptions) {
        this.filterExceptions = filterExceptions;
    }

    @Override
    public boolean visitFrame(Pointer sp, CodePointer ip, DeoptimizedFrame deoptimizedFrame) {
        if (deoptimizedFrame != null) {
            for (DeoptimizedFrame.VirtualFrame frame = deoptimizedFrame.getTopFrame(); frame != null; frame = frame.getCaller()) {
                this.addToTrace(frame.getFrameInfo());
            }
        } else {
            CodeInfoQueryResult codeInfo = CodeInfoTable.lookupCodeInfoQueryResult(ip);
            for (FrameInfoQueryResult frameInfo = codeInfo.getFrameInfo(); frameInfo != null; frameInfo = frameInfo.getCaller()) {
                this.addToTrace(frameInfo);
            }
        }
        return true;
    }

    private void addToTrace(FrameInfoQueryResult frameInfo) {
        StackTraceElement sourceReference = frameInfo.getSourceReference();
        if (!IsolateEnterStub.class.getName().equals(sourceReference.getClassName())) {
            if (this.filterExceptions && ImplicitExceptions.class.getName().equals(sourceReference.getClassName())) {
                this.trace.clear();
            } else {
                this.trace.add(sourceReference);
            }
        }
    }

    public StackTraceElement[] getTrace() {
        return this.trace.toArray(new StackTraceElement[this.trace.size()]);
    }
}

