/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.heap.DiscoverableReference;
import com.oracle.svm.core.heap.FeebleReferenceList;
import com.oracle.svm.core.jdk.UninterruptibleUtils;

@UnknownClass
public class FeebleReference<T>
extends DiscoverableReference {
    private UninterruptibleUtils.AtomicReference<FeebleReferenceList<T>> list;
    private FeebleReference<? extends T> next;

    public static <T> FeebleReference<T> factory(T referent, FeebleReferenceList<T> list) {
        return new FeebleReference<T>(referent, list);
    }

    public T get() {
        return (T)this.getReferentObject();
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public boolean isEnlisted() {
        return this.next != this;
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    public FeebleReferenceList<T> getList() {
        return this.list.get();
    }

    public FeebleReferenceList<T> clearList() {
        return this.list.getAndSet(null);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    FeebleReference<? extends T> listGetNext() {
        return this.isEnlisted() ? this.next : null;
    }

    void listPrepend(FeebleReference<?> newNext) {
        assert (newNext != this) : "Creating self-loop.";
        this.next = FeebleReference.uncheckedNarrow(newNext);
    }

    @Uninterruptible(reason="Called from uninterruptible code.")
    void listRemove() {
        this.next = this;
    }

    protected FeebleReference(T referent, FeebleReferenceList<T> list) {
        super(referent);
        this.list = new UninterruptibleUtils.AtomicReference<FeebleReferenceList<FeebleReferenceList<T>>>(list);
        FeebleReferenceList.clean(this);
    }

    static <S> FeebleReference<S> uncheckedNarrow(FeebleReference<?> fr) {
        return fr;
    }
}

