/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.heap.ObjectReferenceVisitor;
import com.oracle.svm.core.heap.SubstrateReferenceMap;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.word.Pointer;

class CollectingObjectReferenceVisitor
implements ObjectReferenceVisitor {
    protected final SubstrateReferenceMap result = new SubstrateReferenceMap();

    CollectingObjectReferenceVisitor() {
    }

    @Override
    public boolean visitObjectReference(Pointer objRef, boolean compressed) {
        int offset = NumUtil.safeToInt((long)objRef.rawValue());
        assert (!this.result.isOffsetMarked(offset));
        this.result.markReferenceAtOffset(offset, compressed);
        return true;
    }
}

