/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.config.ConfigurationValues;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CodePointer;
import org.graalvm.word.Pointer;

public abstract class FrameAccess {
    @Fold
    public static FrameAccess singleton() {
        return (FrameAccess)ImageSingletons.lookup(FrameAccess.class);
    }

    public abstract CodePointer readReturnAddress(Pointer var1);

    public abstract void writeReturnAddress(Pointer var1, CodePointer var2);

    @Fold
    public static int returnAddressSize() {
        return ConfigurationValues.getTarget().arch.getReturnAddressSize();
    }

    public abstract int savedBasePointerSize();

    @Fold
    public static int wordSize() {
        return ConfigurationValues.getTarget().arch.getWordSize();
    }

    public static int uncompressedReferenceSize() {
        return FrameAccess.wordSize();
    }

    public static JavaKind getWordKind() {
        return ConfigurationValues.getTarget().wordJavaKind;
    }

    public static Stamp getWordStamp() {
        return StampFactory.forKind((JavaKind)ConfigurationValues.getTarget().wordJavaKind);
    }
}

