/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent;

import com.oracle.svm.agent.AgentIsolate;
import com.oracle.svm.agent.BreakpointInterceptor;
import com.oracle.svm.agent.JniCallInterceptor;
import com.oracle.svm.agent.Support;
import com.oracle.svm.agent.TraceFileWriter;
import com.oracle.svm.agent.TraceProcessorWriterAdapter;
import com.oracle.svm.agent.TraceWriter;
import com.oracle.svm.agent.jvmti.JvmtiEnv;
import com.oracle.svm.agent.jvmti.JvmtiEvent;
import com.oracle.svm.agent.jvmti.JvmtiEventCallbacks;
import com.oracle.svm.agent.jvmti.JvmtiEventMode;
import com.oracle.svm.agent.restrict.AbstractAccessVerifier;
import com.oracle.svm.agent.restrict.JniAccessVerifier;
import com.oracle.svm.agent.restrict.ProxyAccessVerifier;
import com.oracle.svm.agent.restrict.ReflectAccessVerifier;
import com.oracle.svm.agent.restrict.ResourceAccessVerifier;
import com.oracle.svm.agent.restrict.TypeAccessChecker;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.json.JsonWriter;
import com.oracle.svm.configure.trace.AccessAdvisor;
import com.oracle.svm.configure.trace.TraceProcessor;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.jni.JNIObjectHandles;
import com.oracle.svm.jni.nativeapi.JNIEnvironment;
import com.oracle.svm.jni.nativeapi.JNIErrors;
import com.oracle.svm.jni.nativeapi.JNIJavaVM;
import com.oracle.svm.jni.nativeapi.JNIObjectHandle;
import com.oracle.svm.jni.nativeapi.JNIVersion;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.ProcessProperties;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.UnmanagedMemory;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public final class Agent {
    public static final String AGENT_NAME = "native-image-agent";
    public static final String MESSAGE_PREFIX = "native-image-agent: ";
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");
    private static final String oHJNIConfigurationResources = Agent.oH(ConfigurationFiles.Options.JNIConfigurationResources);
    private static final String oHReflectionConfigurationResources = Agent.oH(ConfigurationFiles.Options.ReflectionConfigurationResources);
    private static final String oHDynamicProxyConfigurationResources = Agent.oH(ConfigurationFiles.Options.DynamicProxyConfigurationResources);
    private static final String oHResourceConfigurationResources = Agent.oH(ConfigurationFiles.Options.ResourceConfigurationResources);
    private static final String oHConfigurationResourceRoots = Agent.oH(ConfigurationFiles.Options.ConfigurationResourceRoots);
    private static TraceWriter traceWriter;
    private static Path configOutputDirPath;
    private static AccessAdvisor accessAdvisor;
    private static final Pattern propertyBlacklist;
    private static final Pattern propertyWhitelist;
    private static final CEntryPointLiteral<CFunctionPointer> onVMInitLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onVMStartLiteral;
    private static final CEntryPointLiteral<CFunctionPointer> onThreadEndLiteral;

    private static <T> String oH(OptionKey<T> option) {
        return "-H:" + option.getName();
    }

    private static String getTokenValue(String token) {
        return token.substring(token.indexOf(61) + 1);
    }

    @CEntryPoint(name="Agent_OnLoad")
    @CEntryPointOptions(prologue=CEntryPointSetup.EnterCreateIsolatePrologue.class, epilogue=AgentIsolate.Epilogue.class)
    public static int onLoad(JNIJavaVM vm, CCharPointer options, PointerBase reserved) {
        AbstractAccessVerifier verifier;
        AgentIsolate.setGlobalIsolate(CurrentIsolate.getIsolate());
        String traceOutputFile = null;
        String configOutputDir = null;
        ConfigurationSet restrictConfigs = new ConfigurationSet();
        ConfigurationSet mergeConfigs = new ConfigurationSet();
        boolean restrict = false;
        boolean noFilter = false;
        boolean build = false;
        if (options.isNonNull() && SubstrateUtil.strlen((CCharPointer)options).aboveThan(0)) {
            String[] optionTokens = Support.fromCString(options).split(",");
            if (optionTokens.length == 0) {
                System.err.println("native-image-agent: invalid option string. Please read CONFIGURE.md.");
                return 1;
            }
            for (String token : optionTokens) {
                if (token.startsWith("trace-output=")) {
                    if (traceOutputFile != null) {
                        System.err.println("native-image-agent: cannot specify trace-output= more than once.");
                        return 1;
                    }
                    traceOutputFile = Agent.getTokenValue(token);
                    continue;
                }
                if (token.startsWith("config-output-dir=") || token.startsWith("config-merge-dir=")) {
                    if (configOutputDir != null) {
                        System.err.println("native-image-agent: cannot specify more than one of config-output-dir= or config-merge-dir=.");
                        return 1;
                    }
                    configOutputDir = Agent.transformPath(Agent.getTokenValue(token));
                    if (!token.startsWith("config-merge-dir=")) continue;
                    mergeConfigs.addDirectory(Paths.get(configOutputDir, new String[0]));
                    continue;
                }
                if (token.startsWith("restrict-all-dir")) {
                    restrictConfigs.addDirectory(Paths.get(Agent.getTokenValue(token), new String[0]));
                    continue;
                }
                if (token.equals("restrict")) {
                    restrict = true;
                    continue;
                }
                if (token.startsWith("restrict=")) {
                    restrict = Boolean.parseBoolean(Agent.getTokenValue(token));
                    continue;
                }
                if (token.equals("no-filter")) {
                    noFilter = true;
                    continue;
                }
                if (token.startsWith("no-filter=")) {
                    noFilter = Boolean.parseBoolean(Agent.getTokenValue(token));
                    continue;
                }
                if (token.equals("build")) {
                    build = true;
                    continue;
                }
                if (token.startsWith("build=")) {
                    build = Boolean.parseBoolean(Agent.getTokenValue(token));
                    continue;
                }
                System.err.println("native-image-agent: unsupported option: '" + token + "'. Please read CONFIGURE.md.");
                return 1;
            }
        } else {
            configOutputDir = Agent.transformPath("native-image-agent_config-pid{pid}-{datetime}/");
            System.err.println("native-image-agent: no options provided, writing to directory: " + configOutputDir);
        }
        if (configOutputDir != null) {
            if (traceOutputFile != null) {
                System.err.println("native-image-agent: can only once specify exactly one of trace-output=, config-output-dir= or config-merge-dir=.");
                return 1;
            }
            try {
                configOutputDirPath = Paths.get(configOutputDir, new String[0]);
                if (!Files.isDirectory(configOutputDirPath, new LinkOption[0])) {
                    Files.createDirectory(configOutputDirPath, new FileAttribute[0]);
                }
                Function<IOException, Exception> handler = e -> {
                    if (e instanceof NoSuchFileException) {
                        System.err.println("native-image-agent: warning: file " + ((NoSuchFileException)e).getFile() + " for merging could not be found, skipping");
                        return null;
                    }
                    return e;
                };
                TraceProcessor processor = new TraceProcessor(mergeConfigs.loadJniConfig(handler), mergeConfigs.loadReflectConfig(handler), mergeConfigs.loadProxyConfig(handler), mergeConfigs.loadResourceConfig(handler));
                processor.setFilterEnabled(!noFilter);
                traceWriter = new TraceProcessorWriterAdapter(processor);
            }
            catch (Throwable t) {
                System.err.println(MESSAGE_PREFIX + t);
                return 2;
            }
        }
        if (traceOutputFile != null) {
            try {
                Path path = Paths.get(Agent.transformPath(traceOutputFile), new String[0]);
                traceWriter = new TraceFileWriter(path);
            }
            catch (Throwable t) {
                System.err.println(MESSAGE_PREFIX + t);
                return 2;
            }
        }
        WordPointer jvmtiPtr = (WordPointer)StackValue.get(WordPointer.class);
        Support.checkJni(vm.getFunctions().getGetEnv().invoke(vm, (PointerBase)jvmtiPtr, 805372416));
        JvmtiEnv jvmti = (JvmtiEnv)jvmtiPtr.read();
        if (build) {
            int status = Agent.buildImage(jvmti);
            System.exit(status);
        }
        HashMap<URI, FileSystem> temporaryFileSystems = new HashMap<URI, FileSystem>();
        if (restrict && !Agent.addRestrictConfigs(jvmti, restrictConfigs, temporaryFileSystems)) {
            return 2;
        }
        JvmtiEventCallbacks callbacks = (JvmtiEventCallbacks)UnmanagedMemory.calloc((int)SizeOf.get(JvmtiEventCallbacks.class));
        callbacks.setVMInit(onVMInitLiteral.getFunctionPointer());
        callbacks.setVMStart(onVMStartLiteral.getFunctionPointer());
        callbacks.setThreadEnd(onThreadEndLiteral.getFunctionPointer());
        accessAdvisor = new AccessAdvisor();
        TypeAccessChecker reflectAccessChecker = null;
        try {
            verifier = null;
            if (!restrictConfigs.getReflectConfigPaths().isEmpty()) {
                reflectAccessChecker = new TypeAccessChecker(restrictConfigs.loadReflectConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
                verifier = new ReflectAccessVerifier(reflectAccessChecker, accessAdvisor);
            }
            ProxyAccessVerifier proxyVerifier = null;
            if (!restrictConfigs.getProxyConfigPaths().isEmpty()) {
                proxyVerifier = new ProxyAccessVerifier(restrictConfigs.loadProxyConfig(ConfigurationSet.FAIL_ON_EXCEPTION), accessAdvisor);
            }
            ResourceAccessVerifier resourceVerifier = null;
            if (!restrictConfigs.getResourceConfigPaths().isEmpty()) {
                resourceVerifier = new ResourceAccessVerifier(restrictConfigs.loadResourceConfig(ConfigurationSet.FAIL_ON_EXCEPTION), accessAdvisor);
            }
            BreakpointInterceptor.onLoad(jvmti, callbacks, traceWriter, verifier, proxyVerifier, resourceVerifier);
        }
        catch (Throwable t) {
            System.err.println(MESSAGE_PREFIX + t);
            return 3;
        }
        try {
            verifier = null;
            if (!restrictConfigs.getJniConfigPaths().isEmpty()) {
                TypeAccessChecker accessChecker = new TypeAccessChecker(restrictConfigs.loadJniConfig(ConfigurationSet.FAIL_ON_EXCEPTION));
                verifier = new JniAccessVerifier(accessChecker, reflectAccessChecker, accessAdvisor);
            }
            JniCallInterceptor.onLoad(traceWriter, (JniAccessVerifier)verifier);
        }
        catch (Throwable t) {
            System.err.println(MESSAGE_PREFIX + t);
            return 4;
        }
        for (FileSystem fileSystem : temporaryFileSystems.values()) {
            try {
                fileSystem.close();
            }
            catch (IOException e2) {
                System.err.println("native-image-agent: restrict mode could not close jar filesystem " + fileSystem);
                e2.printStackTrace();
            }
        }
        Support.check(jvmti.getFunctions().SetEventCallbacks().invoke(jvmti, callbacks, SizeOf.get(JvmtiEventCallbacks.class)));
        UnmanagedMemory.free((PointerBase)callbacks);
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_VM_START, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_VM_INIT, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        Support.check(jvmti.getFunctions().SetEventNotificationMode().invoke(jvmti, JvmtiEventMode.JVMTI_ENABLE, JvmtiEvent.JVMTI_EVENT_THREAD_END, (JNIObjectHandle)JNIObjectHandles.nullHandle()));
        return 0;
    }

    private static boolean addRestrictConfigs(JvmtiEnv jvmti, ConfigurationSet restrictConfigs, Map<URI, FileSystem> temporaryFileSystems) {
        Path workDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        AddURI addURI = (target, classpathEntry, resourceLocation) -> {
            boolean added = false;
            if (Files.isDirectory(classpathEntry, new LinkOption[0])) {
                Path resourcePath = classpathEntry.resolve(Paths.get(resourceLocation, new String[0]));
                if (Files.isReadable(resourcePath)) {
                    added = target.add(resourcePath.toUri());
                }
            } else {
                URI jarFileURI = URI.create("jar:" + classpathEntry.toUri());
                try {
                    FileSystem prevJarFS = (FileSystem)temporaryFileSystems.get(jarFileURI);
                    FileSystem jarFS = prevJarFS == null ? FileSystems.newFileSystem(jarFileURI, Collections.emptyMap()) : prevJarFS;
                    Path resourcePath = jarFS.getPath("/" + resourceLocation, new String[0]);
                    if (Files.isReadable(resourcePath)) {
                        added = target.add(resourcePath.toUri());
                    }
                    if (prevJarFS == null) {
                        if (added) {
                            temporaryFileSystems.put(jarFileURI, jarFS);
                        } else {
                            jarFS.close();
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("native-image-agent: restrict mode could not access " + classpathEntry + " as a jar file");
                }
            }
            if (added) {
                System.err.println("native-image-agent: restrict mode added " + resourceLocation + " from " + workDir.relativize(classpathEntry));
            }
        };
        String classpath = Support.getSystemProperty(jvmti, "java.class.path");
        if (classpath == null) {
            System.err.println("native-image-agent: restrict mode could not determine classpath");
            return false;
        }
        try {
            Map extractionResults = NativeImage.extractEmbeddedImageArgs((Path)workDir, (String[])SubstrateUtil.split((String)classpath, (String)File.pathSeparator));
            extractionResults.forEach((cpEntry, imageArgs) -> {
                for (String imageArg : imageArgs) {
                    String[] optionParts = SubstrateUtil.split((String)imageArg, (String)"=");
                    String argName = optionParts[0];
                    if (oHJNIConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getJniConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHReflectionConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getReflectConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHDynamicProxyConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getProxyConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (oHResourceConfigurationResources.equals(argName)) {
                        addURI.add(restrictConfigs.getResourceConfigPaths(), (Path)cpEntry, optionParts[1]);
                        continue;
                    }
                    if (!oHConfigurationResourceRoots.equals(argName)) continue;
                    String resourceLocation = optionParts[1];
                    addURI.add(restrictConfigs.getJniConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "jni-config.json");
                    addURI.add(restrictConfigs.getReflectConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "reflect-config.json");
                    addURI.add(restrictConfigs.getProxyConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "proxy-config.json");
                    addURI.add(restrictConfigs.getResourceConfigPaths(), (Path)cpEntry, resourceLocation + "/" + "resource-config.json");
                }
            });
        }
        catch (NativeImage.NativeImageError err) {
            System.err.println("native-image-agent: restrict mode could not extract restrict configuration from classpath");
            err.printStackTrace();
            return false;
        }
        return true;
    }

    private static int buildImage(JvmtiEnv jvmti) {
        String[] keys;
        System.out.println("Building native image ...");
        String classpath = Support.getSystemProperty(jvmti, "java.class.path");
        if (classpath == null) {
            System.err.println("native-image-agent: build mode could not determine classpath");
            return 1;
        }
        String javaCommand = Support.getSystemProperty(jvmti, "sun.java.command");
        String mainClassMissing = "native-image-agent: build mode could not determine main class";
        if (javaCommand == null) {
            System.err.println(mainClassMissing);
            return 1;
        }
        String mainClass = SubstrateUtil.split((String)javaCommand, (String)" ")[0];
        if (mainClass.isEmpty()) {
            System.err.println(mainClassMissing);
            return 1;
        }
        ArrayList<String> buildArgs = new ArrayList<String>();
        for (String key : keys = Support.getSystemProperties(jvmti)) {
            boolean blacklisted;
            boolean whitelisted = propertyWhitelist.matcher(key).matches();
            boolean bl = blacklisted = !whitelisted && propertyBlacklist.matcher(key).matches();
            if (blacklisted) continue;
            buildArgs.add("-D" + key + "=" + Support.getSystemProperty(jvmti, key));
        }
        if (mainClass.toLowerCase().endsWith(".jar")) {
            buildArgs.add("-jar");
        } else {
            buildArgs.addAll(Arrays.asList("-cp", classpath));
        }
        buildArgs.add(mainClass);
        String enableAgentRestrictArg = "-agentlib:native-image-agent=restrict";
        buildArgs.add(Agent.oH(FallbackExecutor.Options.FallbackExecutorJavaArg) + "=" + enableAgentRestrictArg);
        buildArgs.add("native-image-agent.build");
        Path javaHome = Paths.get(Support.getSystemProperty(jvmti, "java.home"), new String[0]);
        String userDirStr = Support.getSystemProperty(jvmti, "user.dir");
        NativeImage.agentBuild((Path)javaHome, userDirStr == null ? null : Paths.get(userDirStr, new String[0]), buildArgs);
        return 0;
    }

    private static String transformPath(String path) {
        String result = path;
        if (result.contains("{pid}")) {
            result = result.replace("{pid}", Long.toString(ProcessProperties.getProcessID()));
        }
        if (result.contains("{datetime}")) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
            fmt.setTimeZone(UTC_TIMEZONE);
            result = result.replace("{datetime}", fmt.format(new Date()));
        }
        return result;
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    public static void onVMInit(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
        accessAdvisor.setInLivePhase(true);
        BreakpointInterceptor.onVMInit(jvmti, jni);
        if (traceWriter != null) {
            traceWriter.tracePhaseChange("live");
        }
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    public static void onVMStart(JvmtiEnv jvmti, JNIEnvironment jni) {
        Support.initialize(jvmti, jni);
        JniCallInterceptor.onVMStart(jvmti);
        if (traceWriter != null) {
            traceWriter.tracePhaseChange("start");
        }
    }

    @CEntryPoint(name="Agent_OnUnload")
    @CEntryPointOptions(prologue=AgentIsolate.Prologue.class, epilogue=AgentIsolate.Epilogue.class)
    public static void onUnload(JNIJavaVM vm) {
        if (traceWriter != null) {
            traceWriter.tracePhaseChange("unload");
            traceWriter.close();
            if (configOutputDirPath != null) {
                TraceProcessor p = ((TraceProcessorWriterAdapter)traceWriter).getProcessor();
                try {
                    try (JsonWriter writer = new JsonWriter(configOutputDirPath.resolve("reflect-config.json"), new OpenOption[0]);){
                        p.getReflectionConfiguration().printJson(writer);
                    }
                    writer = new JsonWriter(configOutputDirPath.resolve("jni-config.json"), new OpenOption[0]);
                    var3_4 = null;
                    try {
                        p.getJniConfiguration().printJson(writer);
                    }
                    catch (Throwable throwable) {
                        var3_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (var3_4 != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    var3_4.addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                    writer = new JsonWriter(configOutputDirPath.resolve("proxy-config.json"), new OpenOption[0]);
                    var3_4 = null;
                    try {
                        p.getProxyConfiguration().printJson(writer);
                    }
                    catch (Throwable throwable) {
                        var3_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (var3_4 != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    var3_4.addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                    writer = new JsonWriter(configOutputDirPath.resolve("resource-config.json"), new OpenOption[0]);
                    var3_4 = null;
                    try {
                        p.getResourceConfiguration().printJson(writer);
                    }
                    catch (Throwable throwable) {
                        var3_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (writer != null) {
                            if (var3_4 != null) {
                                try {
                                    writer.close();
                                }
                                catch (Throwable throwable) {
                                    var3_4.addSuppressed(throwable);
                                }
                            } else {
                                writer.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("native-image-agent: error when writing configuration files: " + e.toString());
                }
                configOutputDirPath = null;
            }
            traceWriter = null;
        }
    }

    private static void cleanupOnUnload(JNIJavaVM vm) {
        WordPointer jniPtr = (WordPointer)StackValue.get(WordPointer.class);
        if (vm.getFunctions().getGetEnv().invoke(vm, (PointerBase)jniPtr, JNIVersion.JNI_VERSION_1_6()) != JNIErrors.JNI_OK()) {
            jniPtr.write((WordBase)WordFactory.nullPointer());
        }
        JNIEnvironment env = (JNIEnvironment)jniPtr.read();
        JniCallInterceptor.onUnload();
        BreakpointInterceptor.onUnload(env);
        Support.destroy(env);
        AgentIsolate.resetGlobalIsolate();
    }

    @CEntryPoint
    @CEntryPointOptions(prologue=AgentIsolate.EnterOrBailoutPrologue.class, epilogue=CEntryPointSetup.LeaveDetachThreadEpilogue.class)
    public static void onThreadEnd(JvmtiEnv jvmti, JNIEnvironment jni, JNIObjectHandle thread) {
    }

    private Agent() {
    }

    static {
        propertyBlacklist = Pattern.compile("(java\\..*)|(sun\\..*)|(jvmci\\..*)");
        propertyWhitelist = Pattern.compile("(java\\.library\\.path)|(java\\.io\\.tmpdir)");
        onVMInitLiteral = CEntryPointLiteral.create(Agent.class, (String)"onVMInit", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class});
        onVMStartLiteral = CEntryPointLiteral.create(Agent.class, (String)"onVMStart", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class});
        onThreadEndLiteral = CEntryPointLiteral.create(Agent.class, (String)"onThreadEnd", (Class[])new Class[]{JvmtiEnv.class, JNIEnvironment.class, JNIObjectHandle.class});
    }

    static interface AddURI {
        public void add(Set<URI> var1, Path var2, String var3);
    }
}

