/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.DefaultUnsafePartition;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.api.UnsafePartitionKind;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ConstantContextSensitiveObject;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.util.GuardedAnnotationAccess;

public class AnalysisType
implements WrappedJavaType,
OriginalClassProvider,
Comparable<AnalysisType> {
    private static final AtomicReferenceFieldUpdater<AnalysisType, ConcurrentHashMap> UNSAFE_ACCESS_FIELDS_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, ConcurrentHashMap.class, "unsafeAccessedFields");
    private static final AtomicReferenceFieldUpdater<AnalysisType, ConstantContextSensitiveObject> UNIQUE_CONSTANT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AnalysisType.class, ConstantContextSensitiveObject.class, "uniqueConstant");
    private final AnalysisUniverse universe;
    private final ResolvedJavaType wrapped;
    private boolean isInHeap;
    private boolean isAllocated;
    private boolean isInTypeCheck;
    private boolean reachabilityListenerNotified;
    private boolean unsafeFieldsRecomputed;
    private boolean unsafeAccessedFieldsRegistered;
    private volatile ConcurrentHashMap<UnsafePartitionKind, Collection<AnalysisField>> unsafeAccessedFields;
    AnalysisType[] subTypes;
    private final int id;
    private final JavaKind storageKind;
    private AnalysisObject contextInsensitiveAnalysisObject;
    private ConcurrentMap<Constant, ConstantContextSensitiveObject> constantObjectsCache;
    private volatile ConstantContextSensitiveObject uniqueConstant;
    private List<AnalysisType> referencedTypes;
    private final ConcurrentHashMap<ResolvedJavaMethod, Object> resolvedMethods = new ConcurrentHashMap(15);
    private static final Object NULL_METHOD = new Object();
    private final AnalysisType componentType;
    private final AnalysisType elementalType;
    private final AnalysisType[] interfaces;
    private boolean isArray;
    public volatile AllInstantiatedTypeFlow assignableTypes;
    public volatile AllInstantiatedTypeFlow assignableTypesNonNull;
    private final AnalysisField[][] instanceFieldsCache = new AnalysisField[2][];
    private static final int ANNOTATION = 8192;

    AnalysisType(AnalysisUniverse universe, ResolvedJavaType javaType, JavaKind storageKind, AnalysisType objectType) {
        this.universe = universe;
        this.wrapped = javaType;
        this.isArray = this.wrapped.isArray();
        this.storageKind = storageKind;
        this.unsafeAccessedFieldsRegistered = false;
        if (universe.analysisPolicy().needsConstantCache()) {
            this.constantObjectsCache = new ConcurrentHashMap<Constant, ConstantContextSensitiveObject>();
        }
        this.getSuperclass();
        this.interfaces = this.convertTypes(this.wrapped.getInterfaces());
        if (this.isArray()) {
            this.componentType = universe.lookup((JavaType)this.wrapped.getComponentType());
            int dimension = 0;
            AnalysisType elemType = this;
            while (elemType.isArray()) {
                elemType = elemType.getComponentType();
                ++dimension;
            }
            if (elemType.getSuperclass() != null) {
                elemType.getSuperclass().getArrayClass(dimension);
            }
            this.elementalType = elemType;
            if (dimension >= 2) {
                objectType.getArrayClass(dimension - 1);
            }
            for (AnalysisType interf : elemType.getInterfaces()) {
                interf.getArrayClass(dimension);
            }
        } else {
            this.componentType = null;
            this.elementalType = this;
        }
        this.id = universe.nextTypeId.getAndIncrement();
        this.contextInsensitiveAnalysisObject = new AnalysisObject(universe, this);
        this.referencedTypes = null;
        assert (this.getSuperclass() == null || this.getId() > this.getSuperclass().getId());
    }

    private AnalysisType[] convertTypes(ResolvedJavaType[] originalTypes) {
        ArrayList<AnalysisType> result = new ArrayList<AnalysisType>(originalTypes.length);
        for (ResolvedJavaType originalType : originalTypes) {
            if (!this.universe.platformSupported((AnnotatedElement)originalType)) continue;
            result.add(this.universe.lookup((JavaType)originalType));
        }
        return result.toArray(new AnalysisType[result.size()]);
    }

    public AnalysisType getArrayClass(int dimension) {
        AnalysisType result = this;
        for (int i = 0; i < dimension; ++i) {
            result = result.getArrayClass();
        }
        return result;
    }

    public void cleanupAfterAnalysis() {
        this.assignableTypes = null;
        this.assignableTypesNonNull = null;
        this.contextInsensitiveAnalysisObject = null;
        this.constantObjectsCache = null;
        this.uniqueConstant = null;
        this.unsafeAccessedFields = null;
    }

    public int getId() {
        return this.id;
    }

    public AnalysisObject getContextInsensitiveAnalysisObject() {
        return this.contextInsensitiveAnalysisObject;
    }

    public AnalysisObject getCachedConstantObject(BigBang bb, JavaConstant constant) {
        assert (bb.analysisPolicy().needsConstantCache()) : "The analysis policy doesn't specify the need for a constants cache.";
        assert (bb.trackConcreteAnalysisObjects(this));
        assert (!(constant instanceof PrimitiveConstant)) : "The analysis should not model PrimitiveConstant.";
        if (this.uniqueConstant != null) {
            return this.uniqueConstant;
        }
        if (this.constantObjectsCache.size() > (Integer)PointstoOptions.MaxConstantObjectsPerType.getValue(bb.getOptions())) {
            this.mergeConstantObjects(bb);
            return this.uniqueConstant;
        }
        AnalysisObject result = (AnalysisObject)this.constantObjectsCache.get(constant);
        if (result == null) {
            ConstantContextSensitiveObject newValue = new ConstantContextSensitiveObject(bb, this, constant);
            ConstantContextSensitiveObject oldValue = this.constantObjectsCache.putIfAbsent((Constant)constant, newValue);
            AnalysisObject analysisObject = result = oldValue != null ? oldValue : newValue;
            if (((Boolean)PointstoOptions.ProfileConstantObjects.getValue(bb.getOptions())).booleanValue()) {
                BigBang.ConstantObjectsProfiler.registerConstant(this);
                BigBang.ConstantObjectsProfiler.maybeDumpConstantHistogram();
            }
        }
        return result;
    }

    private void mergeConstantObjects(BigBang bb) {
        ConstantContextSensitiveObject uConstant = new ConstantContextSensitiveObject(bb, this, null);
        if (UNIQUE_CONSTANT_UPDATER.compareAndSet(this, null, uConstant)) {
            this.constantObjectsCache.values().stream().forEach(constantObject -> constantObject.mergeInstanceFieldsFlows(bb, this.uniqueConstant));
        }
    }

    public List<AnalysisType> getReferencedTypes(BigBang bb) {
        if (this.referencedTypes == null) {
            HashSet referencedTypesSet = new HashSet();
            if (this.isArray()) {
                if (this.getContextInsensitiveAnalysisObject().isObjectArray()) {
                    for (AnalysisType type : this.getContextInsensitiveAnalysisObject().getArrayElementsFlow(bb, false).getState().types()) {
                        type.getTypeFlow(bb, false).getState().types().forEach(referencedTypesSet::add);
                    }
                }
            } else {
                for (AnalysisField field : this.getInstanceFields(true)) {
                    TypeState state = field.getInstanceFieldTypeState();
                    if (state.isUnknown()) continue;
                    for (AnalysisType type : state.types()) {
                        type.getTypeFlow(bb, false).getState().types().forEach(referencedTypesSet::add);
                    }
                }
            }
            this.referencedTypes = new ArrayList<AnalysisType>(referencedTypesSet);
        }
        return this.referencedTypes;
    }

    public AllInstantiatedTypeFlow getTypeFlow(BigBang bb, boolean includeNull) {
        if (this.assignableTypes == null) {
            this.createTypeFlows(bb);
        }
        if (includeNull) {
            return this.assignableTypes;
        }
        return this.assignableTypesNonNull;
    }

    private synchronized void createTypeFlows(BigBang bb) {
        if (this.assignableTypes != null) {
            return;
        }
        AllInstantiatedTypeFlow newAssignableTypes = new AllInstantiatedTypeFlow(this);
        AllInstantiatedTypeFlow newAssignableTypesNonNull = new AllInstantiatedTypeFlow(this);
        this.updateTypeFlows(bb, newAssignableTypes, newAssignableTypesNonNull);
        this.assignableTypesNonNull = newAssignableTypesNonNull;
        this.assignableTypes = newAssignableTypes;
    }

    public static void updateAssignableTypes(BigBang bb) {
        List<AnalysisType> allTypes = bb.getUniverse().getTypes();
        ArrayList changedFlows = new ArrayList();
        HashMap<Integer, BitSet> newAssignableTypes = new HashMap<Integer, BitSet>();
        for (AnalysisType analysisType : allTypes) {
            if (!analysisType.isInstantiated()) continue;
            int arrayDimension = 0;
            AnalysisType elementalType = analysisType;
            while (elementalType.isArray()) {
                elementalType = elementalType.getComponentType();
                ++arrayDimension;
            }
            AnalysisType.addTypeToAssignableLists(analysisType.getId(), elementalType, arrayDimension, newAssignableTypes, true, bb);
            if (arrayDimension > 0) {
                AnalysisType.addTypeToAssignableLists(analysisType.getId(), analysisType, 0, newAssignableTypes, true, bb);
            }
            for (int i = 0; i < arrayDimension; ++i) {
                AnalysisType.addTypeToAssignableLists(analysisType.getId(), bb.getObjectType(), i, newAssignableTypes, false, bb);
            }
            if (elementalType.isPrimitive()) continue;
            AnalysisType.addTypeToAssignableLists(analysisType.getId(), bb.getObjectType(), arrayDimension, newAssignableTypes, false, bb);
        }
        for (AnalysisType analysisType : allTypes) {
            if (analysisType.assignableTypes == null) continue;
            TypeState assignableTypeState = TypeState.forNull();
            if (newAssignableTypes.get(analysisType.getId()) != null) {
                BitSet assignableTypes = (BitSet)newAssignableTypes.get(analysisType.getId());
                if (analysisType.assignableTypes.getState().hasExactTypes(assignableTypes)) continue;
                assignableTypeState = TypeState.forExactTypes(bb, (BitSet)newAssignableTypes.get(analysisType.getId()), true);
            }
            AnalysisType.updateFlow(bb, analysisType.assignableTypes, assignableTypeState, changedFlows);
            AnalysisType.updateFlow(bb, analysisType.assignableTypesNonNull, assignableTypeState.forNonNull(bb), changedFlows);
        }
        for (TypeFlow typeFlow : changedFlows) {
            bb.postFlow(typeFlow);
        }
    }

    private static void addTypeToAssignableLists(int typeIdToAdd, AnalysisType elementalType, int arrayDimension, Map<Integer, BitSet> newAssignableTypes, boolean processSuperclass, BigBang bb) {
        if (elementalType == null) {
            return;
        }
        AnalysisType addTo = elementalType;
        for (int i = 0; i < arrayDimension; ++i) {
            addTo = addTo.getArrayClass();
        }
        int addToId = addTo.getId();
        if (!newAssignableTypes.containsKey(addToId)) {
            newAssignableTypes.put(addToId, new BitSet());
        }
        newAssignableTypes.get(addToId).set(typeIdToAdd);
        if (processSuperclass) {
            AnalysisType.addTypeToAssignableLists(typeIdToAdd, elementalType.getSuperclass(), arrayDimension, newAssignableTypes, true, bb);
        }
        for (AnalysisType interf : elementalType.getInterfaces()) {
            AnalysisType.addTypeToAssignableLists(typeIdToAdd, interf, arrayDimension, newAssignableTypes, false, bb);
        }
    }

    private void updateTypeFlows(BigBang bb, TypeFlow<?> assignable, TypeFlow<?> assignableNonNull) {
        AnalysisType superType;
        if (this.isPrimitive() || this.isJavaLangObject()) {
            return;
        }
        if (this.isInterface()) {
            superType = bb.getObjectType();
        } else {
            superType = this.getSuperclass();
            while (superType.assignableTypes == null) {
                superType = superType.getSuperclass();
            }
        }
        TypeState superAssignableTypeState = superType.assignableTypes.getState();
        BitSet assignableTypesSet = new BitSet();
        for (AnalysisType type : superAssignableTypeState.types()) {
            if (!this.isAssignableFrom(type)) continue;
            assignableTypesSet.set(type.getId());
        }
        TypeState assignableTypeState = TypeState.forExactTypes(bb, assignableTypesSet, true);
        AnalysisType.updateFlow(bb, assignable, assignableTypeState);
        AnalysisType.updateFlow(bb, assignableNonNull, assignableTypeState.forNonNull(bb));
    }

    private static void updateFlow(BigBang bb, TypeFlow<?> flow, TypeState newState) {
        AnalysisType.updateFlow(bb, flow, newState, null);
    }

    private static void updateFlow(BigBang bb, TypeFlow<?> flow, TypeState newState, List<TypeFlow<?>> changedFlows) {
        if (!flow.getState().equals(newState)) {
            flow.setState(bb, newState);
            if (changedFlows != null && (flow.getUses().size() > 0 || flow.getObservers().size() > 0)) {
                changedFlows.add(flow);
            }
        }
    }

    public void registerAsInHeap() {
        assert (this.isArray() || this.isInstanceClass() && !Modifier.isAbstract(this.getModifiers()));
        this.isInHeap = true;
        this.universe.hostVM.checkForbidden(this, UsageKind.InHeap);
    }

    public void registerAsAllocated(Node node) {
        assert (this.isArray() || this.isInstanceClass() && !Modifier.isAbstract(this.getModifiers())) : this;
        if (!this.isAllocated) {
            this.isAllocated = true;
        }
        this.universe.hostVM.checkForbidden(this, UsageKind.Allocated);
    }

    public void registerAsInTypeCheck() {
        this.isInTypeCheck = true;
        this.universe.hostVM.checkForbidden(this, UsageKind.InTypeCheck);
    }

    public boolean getReachabilityListenerNotified() {
        return this.reachabilityListenerNotified;
    }

    public void setReachabilityListenerNotified(boolean reachabilityListenerNotified) {
        this.reachabilityListenerNotified = reachabilityListenerNotified;
    }

    public void registerUnsafeFieldsRecomputed() {
        this.unsafeFieldsRecomputed = true;
    }

    public void registerUnsafeAccessedField(AnalysisField field, UnsafePartitionKind partitionKind) {
        Collection<AnalysisField> unsafePartition;
        this.unsafeAccessedFieldsRegistered = true;
        if (this.unsafeAccessedFields == null) {
            UNSAFE_ACCESS_FIELDS_UPDATER.compareAndSet(this, null, new ConcurrentHashMap());
        }
        if ((unsafePartition = this.unsafeAccessedFields.get(partitionKind)) == null) {
            ConcurrentLinkedQueue<AnalysisField> newPartition = new ConcurrentLinkedQueue<AnalysisField>();
            ConcurrentLinkedQueue<AnalysisField> oldPartition = this.unsafeAccessedFields.putIfAbsent(partitionKind, newPartition);
            Collection<AnalysisField> collection = unsafePartition = oldPartition != null ? oldPartition : newPartition;
        }
        assert (!unsafePartition.contains(field)) : "Field " + field + " already registered as unsafe accessed with " + this;
        unsafePartition.add(field);
    }

    private boolean hasUnsafeAccessedFields() {
        return this.unsafeAccessedFieldsRegistered || this.getSuperclass() != null && this.getSuperclass().hasUnsafeAccessedFields();
    }

    public List<AnalysisField> unsafeAccessedFields() {
        return this.unsafeAccessedFields(DefaultUnsafePartition.get());
    }

    public List<AnalysisField> unsafeAccessedFields(UnsafePartitionKind partitionKind) {
        if (!this.hasUnsafeAccessedFields()) {
            return Collections.emptyList();
        }
        return this.allUnsafeAccessedFields(partitionKind);
    }

    private List<AnalysisField> allUnsafeAccessedFields(UnsafePartitionKind partitionKind) {
        ArrayList<AnalysisField> unsafePartition = new ArrayList<AnalysisField>();
        unsafePartition.addAll(this.unsafeAccessedFields != null && this.unsafeAccessedFields.containsKey(partitionKind) ? this.unsafeAccessedFields.get(partitionKind) : Collections.emptyList());
        if (this.getSuperclass() != null) {
            List<AnalysisField> superFileds = this.getSuperclass().allUnsafeAccessedFields(partitionKind);
            unsafePartition.addAll(superFileds);
        }
        return unsafePartition;
    }

    public boolean isInstantiated() {
        return this.isInHeap || this.isAllocated;
    }

    public boolean unsafeFieldsRecomputed() {
        return this.unsafeFieldsRecomputed;
    }

    public boolean isInTypeCheck() {
        return this.isInTypeCheck;
    }

    public final JavaKind getStorageKind() {
        return this.storageKind;
    }

    public boolean isWordType() {
        return this.getJavaKind() != this.getStorageKind();
    }

    @Override
    public ResolvedJavaType getWrapped() {
        return this.universe.substitutions.resolve(this.wrapped);
    }

    public ResolvedJavaType getWrappedWithoutResolve() {
        return this.wrapped;
    }

    @Override
    public Class<?> getJavaClass() {
        return OriginalClassProvider.getJavaClass(this.universe.getOriginalSnippetReflection(), this.wrapped);
    }

    public final String getName() {
        return this.wrapped.getName();
    }

    public final JavaKind getJavaKind() {
        return this.wrapped.getJavaKind();
    }

    public final AnalysisType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public final boolean hasFinalizer() {
        return false;
    }

    public final Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        return new Assumptions.AssumptionResult((Object)false);
    }

    public final boolean isInitialized() {
        return this.universe.hostVM.isInitialized(this);
    }

    public void initialize() {
        if (!this.wrapped.isInitialized()) {
            throw GraalError.shouldNotReachHere((String)("Classes can only be initialized using methods in ClassInitializationFeature: " + this.toClassName()));
        }
    }

    public final AnalysisType getArrayClass() {
        return this.universe.lookup((JavaType)this.wrapped.getArrayClass());
    }

    public boolean isInterface() {
        return this.wrapped.isInterface();
    }

    public boolean isEnum() {
        return this.wrapped.isEnum();
    }

    public boolean isInstanceClass() {
        return this.wrapped.isInstanceClass();
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean isPrimitive() {
        return this.wrapped.isPrimitive();
    }

    public int getModifiers() {
        return this.wrapped.getModifiers();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        ResolvedJavaType subst = this.universe.substitutions.resolve(((AnalysisType)other).wrapped);
        return this.wrapped.isAssignableFrom(subst);
    }

    public boolean isInstance(JavaConstant obj) {
        return this.wrapped.isInstance(this.universe.toHosted(obj));
    }

    public AnalysisType getSuperclass() {
        return this.universe.lookup((JavaType)this.wrapped.getSuperclass());
    }

    public AnalysisType[] getInterfaces() {
        return this.interfaces;
    }

    public ResolvedJavaType getSingleImplementor() {
        return this;
    }

    public AnalysisType findLeastCommonAncestor(ResolvedJavaType otherType) {
        ResolvedJavaType subst = this.universe.substitutions.resolve(((AnalysisType)otherType).wrapped);
        return this.universe.lookup((JavaType)this.wrapped.findLeastCommonAncestor(subst));
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        Assumptions.AssumptionResult wrappedResult = this.wrapped.findLeafConcreteSubtype();
        if (wrappedResult != null && wrappedResult.isAssumptionFree()) {
            return new Assumptions.AssumptionResult((Object)this.universe.lookup((JavaType)wrappedResult.getResult()));
        }
        return null;
    }

    public AnalysisType getComponentType() {
        return this.componentType;
    }

    public ResolvedJavaType getElementalType() {
        return this.elementalType;
    }

    public AnalysisMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        Object resolvedMethod = this.resolvedMethods.get(method);
        if (resolvedMethod == null) {
            Object oldResolvedMethod;
            ResolvedJavaType substCallerType;
            ResolvedJavaMethod substMethod = this.universe.substitutions.resolve(((AnalysisMethod)method).wrapped);
            Object newResolvedMethod = this.universe.lookup((JavaMethod)this.wrapped.resolveMethod(substMethod, substCallerType = substMethod.getDeclaringClass()));
            if (newResolvedMethod == null) {
                newResolvedMethod = NULL_METHOD;
            }
            resolvedMethod = (oldResolvedMethod = this.resolvedMethods.putIfAbsent(method, newResolvedMethod)) != null ? oldResolvedMethod : newResolvedMethod;
        }
        return resolvedMethod == NULL_METHOD ? null : (AnalysisMethod)resolvedMethod;
    }

    public AnalysisMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        return (AnalysisMethod)WrappedJavaType.super.resolveConcreteMethod(method, callerType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        return null;
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        return this.universe.lookup((JavaField)this.wrapped.findInstanceFieldWithOffset(offset, expectedKind));
    }

    public AnalysisField[] getInstanceFields(boolean includeSuperclasses) {
        int cacheIdx = includeSuperclasses ? 1 : 0;
        AnalysisField[] result = this.instanceFieldsCache[cacheIdx];
        if (result != null) {
            return result;
        }
        this.instanceFieldsCache[cacheIdx] = this.convertInstanceFields(includeSuperclasses);
        return this.instanceFieldsCache[cacheIdx];
    }

    private AnalysisField[] convertInstanceFields(boolean includeSupeclasses) {
        ArrayList<AnalysisField> list = new ArrayList<AnalysisField>();
        if (includeSupeclasses && this.getSuperclass() != null) {
            list.addAll(Arrays.asList(this.getSuperclass().getInstanceFields(true)));
        }
        return this.convertFields(this.wrapped.getInstanceFields(false), list, includeSupeclasses);
    }

    private AnalysisField[] convertFields(ResolvedJavaField[] original, List<AnalysisField> list, boolean listIncludesSuperClassesFields) {
        for (int i = 0; i < original.length; ++i) {
            if (original[i].isInternal()) continue;
            try {
                AnalysisField aField = this.universe.lookup((JavaField)original[i]);
                if (aField == null) continue;
                if (listIncludesSuperClassesFields) {
                    aField.setPosition(list.size());
                }
                list.add(aField);
                continue;
            }
            catch (UnsupportedFeatureException unsupportedFeatureException) {
                // empty catch block
            }
        }
        return list.toArray(new AnalysisField[list.size()]);
    }

    public AnalysisField[] getStaticFields() {
        return this.convertFields(this.wrapped.getStaticFields(), new ArrayList<AnalysisField>(), false);
    }

    public Annotation[] getAnnotations() {
        return GuardedAnnotationAccess.getAnnotations((AnnotatedElement)this.wrapped);
    }

    public Annotation[] getDeclaredAnnotations() {
        return GuardedAnnotationAccess.getDeclaredAnnotations((AnnotatedElement)this.wrapped);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)this.wrapped, annotationClass);
    }

    public String getSourceFileName() {
        return this.wrapped.isPrimitive() ? null : this.wrapped.getSourceFileName();
    }

    public String toString() {
        return "AnalysisType<" + this.toJavaName(true) + ", allocated: " + this.isAllocated + ", inHeap: " + this.isInHeap + ", inTypeCheck: " + this.isInTypeCheck + ">";
    }

    public boolean isLocal() {
        try {
            return this.wrapped.isLocal();
        }
        catch (InternalError e) {
            this.universe.hostVM().warn("unknown locality of class " + this.wrapped.getName() + ", assuming class is not local. To remove the warning report an issue to the library or language author. The issue is caused by " + this.wrapped.getName() + " which is not following the naming convention.");
            return false;
        }
    }

    public boolean isMember() {
        return this.wrapped.isMember();
    }

    public AnalysisType getEnclosingType() {
        ResolvedJavaType wrappedEnclosingType;
        try {
            wrappedEnclosingType = this.wrapped.getEnclosingType();
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
        return this.universe.lookup((JavaType)wrappedEnclosingType);
    }

    public AnalysisMethod[] getDeclaredConstructors() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredConstructors());
    }

    public AnalysisMethod[] getDeclaredMethods() {
        return this.universe.lookup((JavaMethod[])this.wrapped.getDeclaredMethods());
    }

    public AnalysisMethod getClassInitializer() {
        return this.universe.lookup((JavaMethod)this.wrapped.getClassInitializer());
    }

    public boolean isLinked() {
        return this.wrapped.isLinked();
    }

    public boolean isCloneableWithAllocation() {
        throw JVMCIError.unimplemented();
    }

    public ResolvedJavaType getHostClass() {
        return this.universe.lookup((JavaType)this.wrapped.getHostClass());
    }

    @Override
    public int compareTo(AnalysisType other) {
        return Integer.compare(this.id, other.id);
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public boolean isAnnotation() {
        return (this.getModifiers() & 0x2000) != 0;
    }

    public static enum UsageKind {
        InHeap,
        Allocated,
        InTypeCheck;

    }
}

