/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.flow.AllInstantiatedTypeFlow;
import com.oracle.graal.pointsto.flow.CloneTypeFlow;
import com.oracle.graal.pointsto.flow.DynamicNewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReturnTypeFlow;
import com.oracle.graal.pointsto.flow.InitialParamTypeFlow;
import com.oracle.graal.pointsto.flow.InitialReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.InstanceOfTypeFlow;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.LoadFieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlowBuilder;
import com.oracle.graal.pointsto.flow.MonitorEnterTypeFlow;
import com.oracle.graal.pointsto.flow.NewInstanceTypeFlow;
import com.oracle.graal.pointsto.flow.OffsetLoadTypeFlow;
import com.oracle.graal.pointsto.flow.SourceTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.common.JVMCIError;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.java.BytecodeParser;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.options.OptionValues;

public class MethodTypeFlow
extends TypeFlow<AnalysisMethod> {
    protected MethodFlowsGraph originalMethodFlows;
    protected final ConcurrentMap<AnalysisContext, MethodFlowsGraph> clonedMethodFlows;
    private int localCallingContextDepth;
    private final AnalysisMethod method;
    private StructuredGraph graphRef;
    private volatile boolean methodParsed;
    private InvokeTypeFlow parsingReason;
    private ParameterNode returnedParameter;

    public MethodTypeFlow(OptionValues options, AnalysisMethod method) {
        super(method, null);
        this.method = method;
        this.localCallingContextDepth = (Integer)PointstoOptions.MaxCallingContextDepth.getValue(options);
        this.originalMethodFlows = new MethodFlowsGraph(method);
        this.clonedMethodFlows = new ConcurrentHashMap<AnalysisContext, MethodFlowsGraph>(4, 0.75f, 1);
    }

    public AnalysisMethod getMethod() {
        return this.method;
    }

    public InvokeTypeFlow getParsingReason() {
        return this.parsingReason;
    }

    public StackTraceElement[] getParsingContext() {
        ArrayList<StackTraceElement> parsingContext = new ArrayList<StackTraceElement>();
        InvokeTypeFlow invokeFlow = this.parsingReason;
        while (invokeFlow != null) {
            AnalysisMethod caller = invokeFlow.location.getMethod();
            Invoke invokeNode = invokeFlow.invoke();
            parsingContext.add(caller.asStackTraceElement(invokeNode.bci()));
            invokeFlow = invokeFlow.location.getMethod().getTypeFlow().parsingReason;
        }
        return parsingContext.toArray(new StackTraceElement[parsingContext.size()]);
    }

    public MethodFlowsGraph addContext(BigBang bb, AnalysisContext calleeContext, InvokeTypeFlow reason) {
        this.ensureParsed(bb, reason);
        AnalysisContext newContext = bb.contextPolicy().peel(calleeContext, this.localCallingContextDepth);
        MethodFlowsGraph methodFlows = (MethodFlowsGraph)this.clonedMethodFlows.get(newContext);
        if (methodFlows == null) {
            MethodFlowsGraph newFlows = new MethodFlowsGraph(this.method, newContext);
            newFlows.cloneOriginalFlows(bb);
            MethodFlowsGraph oldFlows = this.clonedMethodFlows.putIfAbsent(newContext, newFlows);
            MethodFlowsGraph methodFlowsGraph = methodFlows = oldFlows != null ? oldFlows : newFlows;
            if (oldFlows == null) {
                methodFlows.linkClones(bb);
            }
        }
        return methodFlows;
    }

    public AnalysisContext[] getContexts() {
        Set contexts = this.clonedMethodFlows.keySet();
        return contexts.toArray(new AnalysisContext[contexts.size()]);
    }

    public int getLocalCallingContextDepth() {
        return this.localCallingContextDepth;
    }

    public Map<AnalysisContext, MethodFlowsGraph> getMethodContextFlows() {
        return this.clonedMethodFlows;
    }

    public Collection<MethodFlowsGraph> getFlows() {
        return this.clonedMethodFlows.values();
    }

    public MethodFlowsGraph getFlows(AnalysisContext calleeContext) {
        return (MethodFlowsGraph)this.clonedMethodFlows.get(calleeContext);
    }

    public void setResult(FormalReturnTypeFlow result) {
        this.originalMethodFlows.setResult(result);
    }

    public void setParameter(int index, FormalParamTypeFlow parameter) {
        this.originalMethodFlows.setParameter(index, parameter);
    }

    public void setInitialReceiverFlow(BigBang bb, AnalysisType declaringType) {
        AllInstantiatedTypeFlow declaringTypeFlow = declaringType.getTypeFlow(bb, false);
        InitialReceiverTypeFlow initialReceiverFlow = new InitialReceiverTypeFlow(this.method, declaringType);
        declaringTypeFlow.addUse(bb, initialReceiverFlow);
        this.originalMethodFlows.setInitialParameterFlow(initialReceiverFlow, 0);
    }

    public void setInitialParameterFlow(BigBang bb, AnalysisType declaredType, int i) {
        AllInstantiatedTypeFlow declaredTypeFlow = declaredType.getTypeFlow(bb, true);
        InitialParamTypeFlow initialParameterFlow = new InitialParamTypeFlow(this.method, declaredType, i);
        declaredTypeFlow.addUse(bb, initialParameterFlow);
        this.originalMethodFlows.setInitialParameterFlow(initialParameterFlow, i);
    }

    public void addAllocation(NewInstanceTypeFlow sourceFlow) {
        this.originalMethodFlows.addAllocation(sourceFlow);
    }

    protected void addDynamicAllocation(DynamicNewInstanceTypeFlow sourceFlow) {
        this.originalMethodFlows.addDynamicAllocation(sourceFlow);
    }

    protected void addClone(CloneTypeFlow sourceFlow) {
        this.originalMethodFlows.addClone(sourceFlow);
    }

    protected void addSource(SourceTypeFlow sourceFlow) {
        this.originalMethodFlows.addSource(sourceFlow);
    }

    protected void addInstanceOf(Object key, InstanceOfTypeFlow instanceOf) {
        this.originalMethodFlows.addInstanceOf(key, instanceOf);
    }

    protected void addMiscEntry(TypeFlow<?> input) {
        this.originalMethodFlows.addMiscEntryFlow(input);
    }

    protected void addMonitorEntryFlow(MonitorEnterTypeFlow monitorEntryFlow) {
        this.originalMethodFlows.addMonitorEntry(monitorEntryFlow);
    }

    protected void addFieldLoad(LoadFieldTypeFlow sourceFlow) {
        this.originalMethodFlows.addFieldLoad(sourceFlow);
    }

    protected void addIndexedLoad(OffsetLoadTypeFlow.LoadIndexedTypeFlow sourceFlow) {
        this.originalMethodFlows.addIndexedLoad(sourceFlow);
    }

    protected void addInvoke(Object key, InvokeTypeFlow invokeTypeFlow) {
        this.originalMethodFlows.addInvoke(key, invokeTypeFlow);
    }

    public MethodFlowsGraph getOriginalMethodFlows() {
        return this.originalMethodFlows;
    }

    public TypeState foldTypeFlow(BigBang bb, TypeFlow<?> originalTypeFlow) {
        if (originalTypeFlow == null) {
            return null;
        }
        TypeState result = TypeState.forEmpty();
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            TypeState cloneState = clonedTypeFlow.getState();
            TypeState cloneStateCopy = TypeState.forContextInsensitiveTypeState(bb, cloneState);
            result = TypeState.forUnion(bb, result, cloneStateCopy);
        }
        return result;
    }

    protected FormalParamTypeFlow getParameterFlow(int idx) {
        return this.originalMethodFlows.getParameter(idx);
    }

    public TypeState getParameterTypeState(BigBang bb, int parameter) {
        return this.foldTypeFlow(bb, this.originalMethodFlows.getParameter(parameter));
    }

    protected FormalReturnTypeFlow getResultFlow() {
        return this.originalMethodFlows.getResult();
    }

    public Collection<InvokeTypeFlow> getInvokes() {
        return this.originalMethodFlows.getInvokeFlows();
    }

    public StructuredGraph getGraph() {
        return this.graphRef;
    }

    private ParameterNode computeReturnedParamter() {
        if (this.graphRef == null) {
            return null;
        }
        ParameterNode retParam = null;
        for (ParameterNode param : this.graphRef.getNodes(ParameterNode.TYPE)) {
            if (!(param.stamp(NodeView.DEFAULT) instanceof ObjectStamp)) continue;
            boolean returnsParameter = true;
            NodeIterable retIterable = this.graphRef.getNodes(ReturnNode.TYPE);
            returnsParameter &= retIterable.count() > 0;
            for (ReturnNode ret : retIterable) {
                returnsParameter &= ret.result() == param;
            }
            if (!returnsParameter) continue;
            retParam = param;
        }
        return retParam;
    }

    protected ParameterNode getReturnedParameter() {
        return this.returnedParameter;
    }

    public void ensureParsed(BigBang bb, InvokeTypeFlow reason) {
        if (!this.methodParsed) {
            this.doParse(bb, reason);
        }
    }

    private synchronized void doParse(BigBang bb, InvokeTypeFlow reason) {
        if (!this.methodParsed) {
            this.parsingReason = reason;
            try {
                MethodTypeFlowBuilder builder = bb.createMethodTypeFlowBuilder(bb, this);
                builder.apply();
                this.graphRef = builder.graph;
            }
            catch (BytecodeParser.BytecodeParserError ex) {
                if (ex.getCause() instanceof UnsupportedFeatureException) {
                    Throwable cause = ex;
                    if (ex.getCause().getCause() != null) {
                        cause = ex.getCause();
                    }
                    String message = cause.getMessage();
                    bb.getUnsupportedFeatures().addMessage(this.method.format("%H.%n(%p)"), this.method, message, ex.context(), cause.getCause());
                }
                throw AnalysisError.parsingError(this.method, ex);
            }
            catch (Throwable t) {
                throw AnalysisError.parsingError(this.method, t);
            }
            this.originalMethodFlows.linearizeGraph();
            bb.numParsedGraphs.incrementAndGet();
            this.returnedParameter = this.computeReturnedParamter();
            this.methodParsed = true;
        }
    }

    @Override
    public void update(BigBang bb) {
        JVMCIError.shouldNotReachHere();
    }

    @Override
    public String toString() {
        return "MethodTypeFlow<" + this.method + ">";
    }
}

