// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: PointstoOptions.java
package com.oracle.graal.pointsto.api;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class PointstoOptions_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AllocationSiteSensitiveHeap": {
            return OptionDescriptor.create(
                /*name*/ "AllocationSiteSensitiveHeap",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "A context sensitive heap means that each heap allocated object is modeled by using at least the allocation site.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "AllocationSiteSensitiveHeap",
                /*option*/ PointstoOptions.AllocationSiteSensitiveHeap);
        }
        case "AnalysisContextSensitivity": {
            return OptionDescriptor.create(
                /*name*/ "AnalysisContextSensitivity",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Controls the static analysis context sensitivity. Available values: insens (context insensitive analysis), allocsens (context insensitive analysis, context insensitive heap, allocation site sensitive heap), _1obj (1 object sensitive analysis with a context insensitive heap), _2obj1h (2 object sensitive with a 1 context sensitive heap)",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "AnalysisContextSensitivity",
                /*option*/ PointstoOptions.AnalysisContextSensitivity);
        }
        case "AnalysisSizeCutoff": {
            return OptionDescriptor.create(
                /*name*/ "AnalysisSizeCutoff",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of type and method profiles returned by the static analysis. -1 indicates no limitation.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "AnalysisSizeCutoff",
                /*option*/ PointstoOptions.AnalysisSizeCutoff);
        }
        case "DivertParameterReturningMethod": {
            return OptionDescriptor.create(
                /*name*/ "DivertParameterReturningMethod",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Analysis: Detect methods that return one of their parameters and hardwire the parameter straight to the return.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "DivertParameterReturningMethod",
                /*option*/ PointstoOptions.DivertParameterReturningMethod);
        }
        case "ExtendedAsserts": {
            return OptionDescriptor.create(
                /*name*/ "ExtendedAsserts",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable extended asserts which slow down analysis.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "ExtendedAsserts",
                /*option*/ PointstoOptions.ExtendedAsserts);
        }
        case "HybridStaticContext": {
            return OptionDescriptor.create(
                /*name*/ "HybridStaticContext",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable hybrid context for static methods, i.e. uses invocation site as context for static methods.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "HybridStaticContext",
                /*option*/ PointstoOptions.HybridStaticContext);
        }
        case "InspectServerContentPath": {
            return OptionDescriptor.create(
                /*name*/ "InspectServerContentPath",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Path to the contents of the Inspect web server.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "InspectServerContentPath",
                /*option*/ PointstoOptions.InspectServerContentPath);
        }
        case "LimitObjectArrayLength": {
            return OptionDescriptor.create(
                /*name*/ "LimitObjectArrayLength",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable a limit for the number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "LimitObjectArrayLength",
                /*option*/ PointstoOptions.LimitObjectArrayLength);
        }
        case "MaxCallingContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxCallingContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum length of the methods context chains.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxCallingContextDepth",
                /*option*/ PointstoOptions.MaxCallingContextDepth);
        }
        case "MaxCallingContextWidth": {
            return OptionDescriptor.create(
                /*name*/ "MaxCallingContextWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of contexts to record for a method. It only affects the analysis when the max and min calling context depth are different.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxCallingContextWidth",
                /*option*/ PointstoOptions.MaxCallingContextWidth);
        }
        case "MaxConstantObjectsPerType": {
            return OptionDescriptor.create(
                /*name*/ "MaxConstantObjectsPerType",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of constant objects recorded for each type before merging the constants into one unique constant object per type. The analysis must be heap sensitive. It has a minimum value of 1.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxConstantObjectsPerType",
                /*option*/ PointstoOptions.MaxConstantObjectsPerType);
        }
        case "MaxHeapContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxHeapContextDepth",
                /*option*/ PointstoOptions.MaxHeapContextDepth);
        }
        case "MaxHeapContextWidth": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapContextWidth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of contexts to record for a heap object.  It only affects the analysis when the max and min calling context depth are different.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxHeapContextWidth",
                /*option*/ PointstoOptions.MaxHeapContextWidth);
        }
        case "MaxObjectSetSize": {
            return OptionDescriptor.create(
                /*name*/ "MaxObjectSetSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum number of objects recorded for each type of a type state before disabling heap sensitivity for that type. The analysis must be heap sensitive. It has a minimum value of 1.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MaxObjectSetSize",
                /*option*/ PointstoOptions.MaxObjectSetSize);
        }
        case "MinCallingContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MinCallingContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The minimum length of the methods context chains.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MinCallingContextDepth",
                /*option*/ PointstoOptions.MinCallingContextDepth);
        }
        case "MinHeapContextDepth": {
            return OptionDescriptor.create(
                /*name*/ "MinHeapContextDepth",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The minimum length of the context used to model a heap object in addition to the allocation site; used only when ContextSensitiveHeap is enabled.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "MinHeapContextDepth",
                /*option*/ PointstoOptions.MinHeapContextDepth);
        }
        case "PrintSynchronizedAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "PrintSynchronizedAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print types used for Java synchronization.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "PrintSynchronizedAnalysis",
                /*option*/ PointstoOptions.PrintSynchronizedAnalysis);
        }
        case "ProfileAnalysisOperations": {
            return OptionDescriptor.create(
                /*name*/ "ProfileAnalysisOperations",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the progress of the static analysis.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "ProfileAnalysisOperations",
                /*option*/ PointstoOptions.ProfileAnalysisOperations);
        }
        case "ProfileConstantObjects": {
            return OptionDescriptor.create(
                /*name*/ "ProfileConstantObjects",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the creation of constant objects.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "ProfileConstantObjects",
                /*option*/ PointstoOptions.ProfileConstantObjects);
        }
        case "ReportAnalysisStatistics": {
            return OptionDescriptor.create(
                /*name*/ "ReportAnalysisStatistics",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report analysis statistics.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "ReportAnalysisStatistics",
                /*option*/ PointstoOptions.ReportAnalysisStatistics);
        }
        case "ReportUnsupportedFeaturesDuringAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "ReportUnsupportedFeaturesDuringAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Unsupported features are fatal.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "ReportUnsupportedFeaturesDuringAnalysis",
                /*option*/ PointstoOptions.ReportUnsupportedFeaturesDuringAnalysis);
        }
        case "TrackAccessChain": {
            return OptionDescriptor.create(
                /*name*/ "TrackAccessChain",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the callers for methods and accessing methods for fields.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "TrackAccessChain",
                /*option*/ PointstoOptions.TrackAccessChain);
        }
        case "TrackInputFlows": {
            return OptionDescriptor.create(
                /*name*/ "TrackInputFlows",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Track the input for type flows.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "TrackInputFlows",
                /*option*/ PointstoOptions.TrackInputFlows);
        }
        case "UnresolvedIsError": {
            return OptionDescriptor.create(
                /*name*/ "UnresolvedIsError",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Report unresolved elements as errors.",
                /*declaringClass*/ PointstoOptions.class,
                /*fieldName*/ "UnresolvedIsError",
                /*option*/ PointstoOptions.UnresolvedIsError);
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 24;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AllocationSiteSensitiveHeap");
                    case 1: return get("AnalysisContextSensitivity");
                    case 2: return get("AnalysisSizeCutoff");
                    case 3: return get("DivertParameterReturningMethod");
                    case 4: return get("ExtendedAsserts");
                    case 5: return get("HybridStaticContext");
                    case 6: return get("InspectServerContentPath");
                    case 7: return get("LimitObjectArrayLength");
                    case 8: return get("MaxCallingContextDepth");
                    case 9: return get("MaxCallingContextWidth");
                    case 10: return get("MaxConstantObjectsPerType");
                    case 11: return get("MaxHeapContextDepth");
                    case 12: return get("MaxHeapContextWidth");
                    case 13: return get("MaxObjectSetSize");
                    case 14: return get("MinCallingContextDepth");
                    case 15: return get("MinHeapContextDepth");
                    case 16: return get("PrintSynchronizedAnalysis");
                    case 17: return get("ProfileAnalysisOperations");
                    case 18: return get("ProfileConstantObjects");
                    case 19: return get("ReportAnalysisStatistics");
                    case 20: return get("ReportUnsupportedFeaturesDuringAnalysis");
                    case 21: return get("TrackAccessChain");
                    case 22: return get("TrackInputFlows");
                    case 23: return get("UnresolvedIsError");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
