/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.word.WordBase;

public class AnalysisUniverse
implements Universe {
    protected final HostVM hostVM;
    private static final int ESTIMATED_FIELDS_PER_TYPE = 3;
    public static final int ESTIMATED_NUMBER_OF_TYPES = 2000;
    static final int ESTIMATED_METHODS_PER_TYPE = 15;
    private final ConcurrentMap<ResolvedJavaType, Object> types = new ConcurrentHashMap<ResolvedJavaType, Object>(2000);
    private final ConcurrentMap<ResolvedJavaField, AnalysisField> fields = new ConcurrentHashMap<ResolvedJavaField, AnalysisField>(6000);
    private final ConcurrentMap<ResolvedJavaMethod, AnalysisMethod> methods = new ConcurrentHashMap<ResolvedJavaMethod, AnalysisMethod>(30000);
    private final ConcurrentMap<Signature, WrappedSignature> signatures = new ConcurrentHashMap<Signature, WrappedSignature>(30000);
    private final ConcurrentMap<ConstantPool, WrappedConstantPool> constantPools = new ConcurrentHashMap<ConstantPool, WrappedConstantPool>(2000);
    private boolean sealed;
    private volatile AnalysisType[] typesById = new AnalysisType[2000];
    final AtomicInteger nextTypeId = new AtomicInteger();
    final AtomicInteger nextMethodId = new AtomicInteger(1);
    final AtomicInteger nextFieldId = new AtomicInteger(1);
    boolean analysisDataValid;
    protected final SubstitutionProcessor substitutions;
    private Function<Object, Object>[] objectReplacers;
    private SubstitutionProcessor[] featureSubstitutions;
    private SubstitutionProcessor[] featureNativeSubstitutions;
    private final MetaAccessProvider originalMetaAccess;
    private final SnippetReflectionProvider originalSnippetReflection;
    private final SnippetReflectionProvider snippetReflection;
    private AnalysisType objectClass;
    private TargetDescription target;

    public AnalysisUniverse(HostVM hostVM, TargetDescription target, SubstitutionProcessor substitutions, MetaAccessProvider originalMetaAccess, SnippetReflectionProvider originalSnippetReflection, SnippetReflectionProvider snippetReflection) {
        this.substitutions = substitutions;
        this.target = target;
        this.originalMetaAccess = originalMetaAccess;
        this.originalSnippetReflection = originalSnippetReflection;
        this.hostVM = hostVM;
        this.snippetReflection = snippetReflection;
        this.sealed = false;
        this.objectReplacers = new Function[0];
        this.featureSubstitutions = new SubstitutionProcessor[0];
        this.featureNativeSubstitutions = new SubstitutionProcessor[0];
    }

    public HostVM getHostVM() {
        return this.hostVM;
    }

    public int getNextTypeId() {
        return this.nextTypeId.get();
    }

    public int getNextMethodId() {
        return this.nextMethodId.get();
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean sealed() {
        return this.sealed;
    }

    public void setAnalysisDataValid(BigBang bb, boolean dataIsValid) {
        if (dataIsValid) {
            this.buildSubTypes();
            this.collectMethodImplementations(bb);
        }
        this.analysisDataValid = dataIsValid;
    }

    AnalysisType optionalLookup(ResolvedJavaType type) {
        Object claim = this.types.get(type);
        if (claim instanceof AnalysisType) {
            return (AnalysisType)claim;
        }
        return null;
    }

    @Override
    public HostVM hostVM() {
        return this.hostVM;
    }

    @Override
    public AnalysisType lookup(JavaType type) {
        JavaType result = this.lookupAllowUnresolved(type);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaType) {
            return (AnalysisType)result;
        }
        throw new UnsupportedFeatureException("Unresolved type found. Probably there are some compilation or classpath problems. " + type.toJavaName(true));
    }

    @Override
    public JavaType lookupAllowUnresolved(JavaType rawType) {
        if (rawType == null) {
            return null;
        }
        if (!(rawType instanceof ResolvedJavaType)) {
            return rawType;
        }
        assert (!(rawType instanceof AnalysisType)) : "lookupAllowUnresolved does not support analysis types.";
        ResolvedJavaType hostType = (ResolvedJavaType)rawType;
        ResolvedJavaType type = this.substitutions.lookup(hostType);
        AnalysisType result = this.optionalLookup(type);
        if (result == null) {
            result = this.createType(type);
        }
        assert (this.typesById[result.getId()].equals(result));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Bug in findbugs")
    private AnalysisType createType(ResolvedJavaType type) {
        String claim;
        block18: {
            Object result;
            if (!this.hostVM.platformSupported(type)) {
                throw new UnsupportedFeatureException("type is not available in this platform: " + type.toJavaName(true));
            }
            if (this.sealed && !type.isArray()) {
                throw AnalysisError.typeNotFound(type);
            }
            claim = Thread.currentThread().getName();
            block6: while (true) {
                if ((result = this.types.putIfAbsent(type, claim)) instanceof AnalysisType) {
                    return (AnalysisType)result;
                }
                if (result == null) break block18;
                do {
                    if ((result = this.types.get(type)) == null) continue block6;
                    if (result != claim) continue;
                    throw JVMCIError.shouldNotReachHere((String)"Deadlock creating new types");
                } while (!(result instanceof AnalysisType));
                break;
            }
            return (AnalysisType)result;
        }
        try {
            JavaKind storageKind = this.getStorageKind(type, this.originalMetaAccess, this.getTarget());
            AnalysisType newValue = new AnalysisType(this, type, storageKind, this.objectClass);
            this.hostVM.registerType(newValue);
            AnalysisUniverse analysisUniverse = this;
            synchronized (analysisUniverse) {
                if (newValue.getId() >= this.typesById.length) {
                    this.typesById = Arrays.copyOf(this.typesById, this.typesById.length * 2);
                }
                assert (this.typesById[newValue.getId()] == null);
                this.typesById[newValue.getId()] = newValue;
                if (newValue.isJavaLangObject()) {
                    assert (this.objectClass == null);
                    this.objectClass = newValue;
                }
            }
            Object oldValue = this.types.put(type, newValue);
            assert (oldValue == claim);
            claim = null;
            ResolvedJavaType enclosingType = newValue.getWrapped().getEnclosingType();
            if (enclosingType != null && !this.types.containsKey(enclosingType)) {
                newValue.getEnclosingType();
            }
            AnalysisType analysisType = newValue;
            return analysisType;
        }
        finally {
            if (claim != null) {
                this.types.remove(type, claim);
            }
        }
    }

    public JavaKind getStorageKind(ResolvedJavaType type, MetaAccessProvider metaAccess, TargetDescription targetDescription) {
        if (metaAccess.lookupJavaType(WordBase.class).isAssignableFrom(this.substitutions.resolve(type))) {
            return targetDescription.wordJavaKind;
        }
        return type.getJavaKind();
    }

    @Override
    public AnalysisField lookup(JavaField field) {
        JavaField result = this.lookupAllowUnresolved(field);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaField) {
            return (AnalysisField)result;
        }
        throw new UnsupportedFeatureException("Unresolved field found. Probably there are some compilation or classpath problems. " + field.format("%H.%n"));
    }

    @Override
    public JavaField lookupAllowUnresolved(JavaField rawField) {
        AnalysisField result;
        if (rawField == null) {
            return null;
        }
        if (!(rawField instanceof ResolvedJavaField)) {
            return rawField;
        }
        assert (!(rawField instanceof AnalysisField));
        ResolvedJavaField field = (ResolvedJavaField)rawField;
        if (!this.sealed) {
            this.lookup((JavaType)field.getDeclaringClass());
        }
        if ((result = (AnalysisField)this.fields.get(field = this.substitutions.lookup(field))) == null) {
            result = this.createField(field);
        }
        return result;
    }

    private AnalysisField createField(ResolvedJavaField field) {
        if (!this.hostVM.platformSupported(field)) {
            throw new UnsupportedFeatureException("field is not available in this platform: " + field.format("%H.%n"));
        }
        if (this.sealed) {
            return null;
        }
        AnalysisField newValue = new AnalysisField(this, field);
        AnalysisField oldValue = this.fields.putIfAbsent(field, newValue);
        return oldValue != null ? oldValue : newValue;
    }

    @Override
    public AnalysisMethod lookup(JavaMethod method) {
        JavaMethod result = this.lookupAllowUnresolved(method);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaMethod) {
            return (AnalysisMethod)result;
        }
        throw new UnsupportedFeatureException("Unresolved method found. Probably there are some compilation or classpath problems. " + method.format("%H.%n(%p)"));
    }

    @Override
    public JavaMethod lookupAllowUnresolved(JavaMethod rawMethod) {
        if (rawMethod == null) {
            return null;
        }
        if (!(rawMethod instanceof ResolvedJavaMethod)) {
            return rawMethod;
        }
        assert (!(rawMethod instanceof AnalysisMethod));
        ResolvedJavaMethod method = (ResolvedJavaMethod)rawMethod;
        AnalysisMethod result = (AnalysisMethod)this.methods.get(method = this.substitutions.lookup(method));
        if (result == null) {
            result = this.createMethod(method);
        }
        return result;
    }

    private AnalysisMethod createMethod(ResolvedJavaMethod method) {
        if (!this.hostVM.platformSupported(method)) {
            throw new UnsupportedFeatureException("Method " + method.format("%H.%n(%p) is not available in this platform."));
        }
        if (this.sealed) {
            return null;
        }
        AnalysisMethod newValue = new AnalysisMethod(this, method);
        AnalysisMethod oldValue = this.methods.putIfAbsent(method, newValue);
        return oldValue != null ? oldValue : newValue;
    }

    public AnalysisMethod[] lookup(JavaMethod[] inputs) {
        ArrayList<AnalysisMethod> result = new ArrayList<AnalysisMethod>(inputs.length);
        for (JavaMethod method : inputs) {
            AnalysisMethod aMethod;
            if (!this.hostVM.platformSupported((ResolvedJavaMethod)method) || (aMethod = this.lookup(method)) == null) continue;
            result.add(aMethod);
        }
        return result.toArray(new AnalysisMethod[result.size()]);
    }

    @Override
    public WrappedSignature lookup(Signature signature, WrappedJavaType defaultAccessingClass) {
        assert (!(signature instanceof WrappedSignature));
        WrappedSignature result = (WrappedSignature)this.signatures.get(signature);
        if (result == null) {
            WrappedSignature newValue = new WrappedSignature(this, signature, defaultAccessingClass);
            WrappedSignature oldValue = this.signatures.putIfAbsent(signature, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    @Override
    public WrappedConstantPool lookup(ConstantPool constantPool, WrappedJavaType defaultAccessingClass) {
        assert (!(constantPool instanceof WrappedConstantPool));
        WrappedConstantPool result = (WrappedConstantPool)this.constantPools.get(constantPool);
        if (result == null) {
            WrappedConstantPool newValue = new WrappedConstantPool(this, constantPool, defaultAccessingClass);
            WrappedConstantPool oldValue = this.constantPools.putIfAbsent(constantPool, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    @Override
    public JavaConstant lookup(JavaConstant constant) {
        if (constant == null) {
            return null;
        }
        if (constant.getJavaKind().isObject() && !constant.isNull()) {
            return this.snippetReflection.forObject(this.originalSnippetReflection.asObject(Object.class, constant));
        }
        return constant;
    }

    public JavaConstant toHosted(JavaConstant constant) {
        if (constant == null) {
            return null;
        }
        if (constant.getJavaKind().isObject() && !constant.isNull()) {
            return this.originalSnippetReflection.forObject(this.getSnippetReflection().asObject(Object.class, constant));
        }
        return constant;
    }

    public List<AnalysisType> getTypes() {
        return Collections.unmodifiableList(Arrays.asList(this.typesById).subList(0, this.getNextTypeId()));
    }

    public AnalysisType getType(int typeId) {
        AnalysisType result = this.typesById[typeId];
        assert (result.getId() == typeId);
        return result;
    }

    public Collection<AnalysisField> getFields() {
        return this.fields.values();
    }

    public Collection<AnalysisMethod> getMethods() {
        return this.methods.values();
    }

    public void registerObjectReplacer(Function<Object, Object> replacer) {
        assert (replacer != null);
        this.objectReplacers = Arrays.copyOf(this.objectReplacers, this.objectReplacers.length + 1);
        this.objectReplacers[this.objectReplacers.length - 1] = replacer;
    }

    public void registerFeatureSubstitution(SubstitutionProcessor substitution) {
        SubstitutionProcessor[] subs = this.featureSubstitutions;
        subs = Arrays.copyOf(subs, subs.length + 1);
        subs[subs.length - 1] = substitution;
        this.featureSubstitutions = subs;
    }

    public SubstitutionProcessor[] getFeatureSubstitutions() {
        return this.featureSubstitutions;
    }

    public void registerFeatureNativeSubstitution(SubstitutionProcessor substitution) {
        SubstitutionProcessor[] nativeSubs = this.featureNativeSubstitutions;
        nativeSubs = Arrays.copyOf(nativeSubs, nativeSubs.length + 1);
        nativeSubs[nativeSubs.length - 1] = substitution;
        this.featureNativeSubstitutions = nativeSubs;
    }

    public SubstitutionProcessor[] getFeatureNativeSubstitutions() {
        return this.featureNativeSubstitutions;
    }

    public Object replaceObject(Object source) {
        if (source == null) {
            return null;
        }
        Object destination = source;
        for (Function<Object, Object> replacer : this.objectReplacers) {
            destination = replacer.apply(destination);
        }
        return destination;
    }

    public TargetDescription getTarget() {
        return this.target;
    }

    private void buildSubTypes() {
        HashMap allSubTypes = new HashMap();
        AnalysisType objectType = null;
        for (AnalysisType type : this.getTypes()) {
            allSubTypes.put(type, new HashSet());
            if (!type.isInstanceClass() || type.getSuperclass() != null) continue;
            objectType = type;
        }
        assert (objectType != null);
        for (AnalysisType type : this.getTypes()) {
            if (type.getSuperclass() != null) {
                ((Set)allSubTypes.get(type.getSuperclass())).add(type);
            }
            if (type.isInterface() && type.getInterfaces().length == 0) {
                ((Set)allSubTypes.get(objectType)).add(type);
            }
            for (AnalysisType interf : type.getInterfaces()) {
                ((Set)allSubTypes.get(interf)).add(type);
            }
        }
        for (AnalysisType type : this.getTypes()) {
            Set subTypesSet = (Set)allSubTypes.get(type);
            type.subTypes = subTypesSet.toArray(new AnalysisType[subTypesSet.size()]);
        }
    }

    private void collectMethodImplementations(BigBang bb) {
        for (AnalysisMethod method : this.methods.values()) {
            HashSet<AnalysisMethod> implementations = new HashSet<AnalysisMethod>();
            if (method.wrapped.canBeStaticallyBound() || method.isConstructor()) {
                if (method.isImplementationInvoked()) {
                    implementations.add(method);
                }
            } else {
                try {
                    this.collectMethodImplementations(method, method.getDeclaringClass(), implementations);
                }
                catch (UnsupportedFeatureException ex) {
                    String message = String.format("Error while collecting implementations of %s : %s%n", method.format("%H.%n(%p)"), ex.getMessage());
                    bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, message, null, ex.getCause());
                }
            }
            method.implementations = implementations.toArray(new AnalysisMethod[implementations.size()]);
        }
    }

    private boolean collectMethodImplementations(AnalysisMethod method, AnalysisType holder, Set<AnalysisMethod> implementations) {
        AnalysisMethod aResolved;
        boolean holderOrSubtypeInstantiated = holder.isInstantiated();
        for (AnalysisType subClass : holder.subTypes) {
            holderOrSubtypeInstantiated |= this.collectMethodImplementations(method, subClass, implementations);
        }
        if ((holderOrSubtypeInstantiated || method.isIntrinsicMethod()) && (aResolved = holder.resolveConcreteMethod(method, null)) != null && aResolved.isImplementationInvoked()) {
            implementations.add(aResolved);
        }
        return holderOrSubtypeInstantiated;
    }

    @Override
    public SnippetReflectionProvider getSnippetReflection() {
        return this.snippetReflection;
    }

    public SnippetReflectionProvider getOriginalSnippetReflection() {
        return this.originalSnippetReflection;
    }

    @Override
    public ResolvedJavaMethod resolveSubstitution(ResolvedJavaMethod method) {
        return this.substitutions.resolve(method);
    }
}

