/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.util.AnalysisError;
import java.lang.reflect.Method;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.debug.GraalError;

public class WrappedConstantPool
implements ConstantPool {
    private final Universe universe;
    protected final ConstantPool wrapped;
    private final WrappedJavaType defaultAccessingClass;
    private static final Method hsLoadReferencedType;

    public WrappedConstantPool(Universe universe, ConstantPool wrapped, WrappedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int length() {
        return this.wrapped.length();
    }

    public void loadReferencedType(int cpi, int opcode) {
        try {
            if (this.wrapped instanceof WrappedConstantPool) {
                this.wrapped.loadReferencedType(cpi, opcode);
            } else {
                hsLoadReferencedType.invoke((Object)this.wrapped, cpi, opcode, false);
            }
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnsupportedFeatureException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        ResolvedJavaMethod substMethod = this.universe.resolveSubstitution(((WrappedJavaMethod)method).getWrapped());
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupField(cpi, substMethod, opcode));
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode));
    }

    public JavaMethod lookupMethodInWrapped(int cpi, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupMethodInWrapped(cpi, opcode);
        }
        return this.wrapped.lookupMethod(cpi, opcode);
    }

    public JavaType lookupTypeInWrapped(int cpi, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupTypeInWrapped(cpi, opcode);
        }
        return this.wrapped.lookupType(cpi, opcode);
    }

    public JavaField lookupFieldInWrapped(int cpi, ResolvedJavaMethod method, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupFieldInWrapped(cpi, method, opcode);
        }
        return this.wrapped.lookupField(cpi, method, opcode);
    }

    public JavaType lookupType(int cpi, int opcode) {
        try {
            return this.universe.lookupAllowUnresolved(this.wrapped.lookupType(cpi, opcode));
        }
        catch (AnalysisError.TypeNotFoundError e) {
            return null;
        }
    }

    public WrappedSignature lookupSignature(int cpi) {
        return this.universe.lookup(this.wrapped.lookupSignature(cpi), this.defaultAccessingClass);
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        return this.universe.lookup(this.wrapped.lookupAppendix(cpi, opcode));
    }

    public String lookupUtf8(int cpi) {
        return this.wrapped.lookupUtf8(cpi);
    }

    public Object lookupConstant(int cpi) {
        Object con = this.wrapped.lookupConstant(cpi);
        if (con instanceof JavaType) {
            if (con instanceof ResolvedJavaType) {
                return this.universe.lookup((JavaType)((ResolvedJavaType)con));
            }
            return con;
        }
        if (con instanceof JavaConstant) {
            return this.universe.lookup((JavaConstant)con);
        }
        throw JVMCIError.unimplemented();
    }

    static {
        try {
            Class<?> hsConstantPool = Class.forName("jdk.vm.ci.hotspot.HotSpotConstantPool");
            hsLoadReferencedType = hsConstantPool.getDeclaredMethod("loadReferencedType", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            hsLoadReferencedType.setAccessible(true);
        }
        catch (ReflectiveOperationException ex) {
            throw GraalError.shouldNotReachHere((String)"JVMCI 0.47 or later, or JDK 11 is required for Substrate VM: could not find method HotSpotConstantPool.loadReferencedType");
        }
    }
}

