/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.object;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.flow.context.object.ContextSensitiveAnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import jdk.vm.ci.meta.JavaConstant;

public class ConstantContextSensitiveObject
extends ContextSensitiveAnalysisObject {
    private final JavaConstant constant;

    public ConstantContextSensitiveObject(BigBang bb, AnalysisType type) {
        this(bb, type, null);
    }

    public ConstantContextSensitiveObject(BigBang bb, AnalysisType type, JavaConstant constant) {
        super(bb.getUniverse(), type, AnalysisObject.AnalysisObjectKind.ConstantContextSensitive);
        assert (bb.trackConcreteAnalysisObjects(type));
        this.constant = constant;
    }

    public JavaConstant getConstant() {
        return this.constant;
    }

    public boolean isMergedConstantObject() {
        return this.constant == null;
    }

    @Override
    public void noteMerge(BigBang bb) {
        assert (bb.analysisPolicy().isMergingEnabled());
        if (!this.merged && !this.isEmptyObjectArrayConstant(bb)) {
            super.noteMerge(bb);
        }
    }

    @Override
    public boolean isEmptyObjectArrayConstant(BigBang bb) {
        if (this.isMergedConstantObject()) {
            return false;
        }
        return AnalysisObject.isEmptyObjectArrayConstant(bb, this.getConstant());
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString()).append("  ");
        if (this.constant == null) {
            result.append("MERGED CONSTANT");
        }
        return result.toString();
    }
}

