/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.flow.FieldTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.typestate.TypeState;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.java.StoreFieldNode;

public abstract class StoreFieldTypeFlow
extends TypeFlow<StoreFieldNode> {
    protected final AnalysisField field;

    public StoreFieldTypeFlow(StoreFieldNode node) {
        super(node, null);
        this.field = (AnalysisField)node.field();
    }

    public StoreFieldTypeFlow(StoreFieldTypeFlow original, MethodFlowsGraph methodFlows) {
        super(original, methodFlows);
        this.field = original.field;
    }

    public AnalysisField field() {
        return this.field;
    }

    public static class StoreInstanceFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final TypeFlow<?> valueFlow;
        private final TypeFlow<?> objectFlow;

        StoreInstanceFieldTypeFlow(StoreFieldNode node, TypeFlow<?> valueFlow, TypeFlow<?> objectFlow) {
            super(node);
            this.valueFlow = valueFlow;
            this.objectFlow = objectFlow;
        }

        StoreInstanceFieldTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StoreInstanceFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.objectFlow = methodFlows.lookupCloneOf(bb, original.objectFlow);
        }

        public StoreInstanceFieldTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new StoreInstanceFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add);
        }

        @Override
        public void onObservedUpdate(BigBang bb) {
            assert (this.isClone());
            TypeState objectState = this.objectFlow.getState();
            if (objectState.isUnknown()) {
                bb.reportIllegalUnknownUse(this.graphRef.getMethod(), (Node)this.source, "Illegal: Storing into UnknownTypeState objects. Field: " + this.field);
                return;
            }
            for (AnalysisObject receiver : objectState.objects()) {
                FieldTypeFlow fieldFlow = receiver.getInstanceFieldFlow(bb, this.field, true);
                this.addUse(bb, fieldFlow);
            }
        }

        @Override
        public TypeFlow<?> receiver() {
            return this.objectFlow;
        }

        public TypeState getObjectState() {
            return this.objectFlow.getState();
        }

        @Override
        public String toString() {
            return "StoreInstanceFieldTypeFlow<" + this.getState() + ">";
        }
    }

    public static class StoreStaticFieldTypeFlow
    extends StoreFieldTypeFlow {
        private final FieldTypeFlow fieldFlow;
        private final TypeFlow<?> valueFlow;

        StoreStaticFieldTypeFlow(StoreFieldNode node, TypeFlow<?> valueFlow, FieldTypeFlow fieldFlow) {
            super(node);
            this.valueFlow = valueFlow;
            this.fieldFlow = fieldFlow;
        }

        StoreStaticFieldTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, StoreStaticFieldTypeFlow original) {
            super(original, methodFlows);
            this.valueFlow = methodFlows.lookupCloneOf(bb, original.valueFlow);
            this.fieldFlow = original.fieldFlow;
        }

        public StoreFieldTypeFlow copy(BigBang bb, MethodFlowsGraph methodFlows) {
            return new StoreStaticFieldTypeFlow(bb, methodFlows, this);
        }

        @Override
        public void initClone(BigBang bb) {
            this.addUse(bb, this.fieldFlow);
        }

        @Override
        public boolean addState(BigBang bb, TypeState add) {
            assert (this.isClone());
            return super.addState(bb, add);
        }

        @Override
        public String toString() {
            return "StoreStaticFieldTypeFlow<" + this.getState() + ">";
        }
    }
}

