/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.BytecodeLocation;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;

public abstract class InvokeTypeFlow
extends TypeFlow<MethodCallTargetNode> {
    protected final BytecodeLocation location;
    protected final TypeFlow<?>[] actualParameters;
    protected ActualReturnTypeFlow actualReturn;
    protected final Invoke invoke;
    protected final InvokeTypeFlow originalInvoke;

    protected InvokeTypeFlow(Invoke invoke, MethodCallTargetNode target, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn, BytecodeLocation location) {
        super(target, null);
        this.originalInvoke = null;
        this.location = location;
        this.invoke = invoke;
        this.actualParameters = actualParameters;
        this.actualReturn = actualReturn;
        this.getTargetMethod().registerAsInvoked(this);
    }

    protected InvokeTypeFlow(BigBang bb, MethodFlowsGraph methodFlows, InvokeTypeFlow original) {
        super(original, methodFlows);
        this.originalInvoke = original;
        this.location = original.location;
        this.invoke = original.invoke;
        this.actualReturn = original.getActualReturn() != null ? (ActualReturnTypeFlow)methodFlows.lookupCloneOf(bb, original.getActualReturn()) : null;
        this.actualParameters = new TypeFlow[original.actualParameters.length];
        for (int i = 0; i < original.actualParameters.length; ++i) {
            if (original.getActualParameter(i) == null) continue;
            this.actualParameters[i] = methodFlows.lookupCloneOf(bb, original.getActualParameter(i));
        }
    }

    public BytecodeLocation getLocation() {
        return this.location;
    }

    public DebugContext getDebug() {
        return this.invoke.asNode().getDebug();
    }

    public AnalysisMethod getTargetMethod() {
        return (AnalysisMethod)((MethodCallTargetNode)this.getSource()).targetMethod();
    }

    public int actualParametersCount() {
        return this.actualParameters.length;
    }

    public Invoke invoke() {
        return this.invoke;
    }

    public TypeFlow<?>[] getActualParameters() {
        return this.actualParameters;
    }

    public TypeFlow<?> getReceiver() {
        return this.actualParameters[0];
    }

    public TypeFlow<?> getActualParameter(int index) {
        return this.actualParameters[index];
    }

    public TypeFlow<?> getActualReturn() {
        return this.actualReturn;
    }

    public void setActualReturn(ActualReturnTypeFlow actualReturn) {
        this.actualReturn = actualReturn;
    }

    public TypeFlow<?> getResult() {
        return this.actualReturn;
    }

    @Override
    public boolean addState(BigBang bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }

    protected void updateReceiver(BigBang bb, MethodFlowsGraph calleeFlows, AnalysisObject receiverObject) {
        TypeState receiverTypeState = TypeState.forExactType(bb, receiverObject, false);
        this.updateReceiver(bb, calleeFlows, receiverTypeState);
    }

    protected void updateReceiver(BigBang bb, MethodFlowsGraph calleeFlows, TypeState receiverTypeState) {
        FormalReceiverTypeFlow formalReceiverFlow = calleeFlows.getFormalReceiver();
        if (formalReceiverFlow != null) {
            formalReceiverFlow.addReceiverState(bb, receiverTypeState);
        }
        if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
            ParameterNode paramNode = calleeFlows.getMethod().getTypeFlow().getReturnedParameter();
            if (this.actualReturn != null && paramNode != null && paramNode.index() == 0) {
                this.actualReturn.addState(bb, receiverTypeState);
            }
        }
    }

    protected void linkCallee(BigBang bb, boolean isStatic, MethodFlowsGraph calleeFlows) {
        TypeFlow<Object> actualParam;
        for (int i = 0; i < this.actualParameters.length; ++i) {
            actualParam = this.actualParameters[i];
            FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
            if (actualParam == null || formalParam == null) continue;
            actualParam.addUse(bb, formalParam);
        }
        if (this.actualReturn != null) {
            if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
                ParameterNode paramNode = calleeFlows.getMethod().getTypeFlow().getReturnedParameter();
                if (paramNode != null) {
                    if (isStatic || paramNode.index() != 0) {
                        actualParam = this.actualParameters[paramNode.index()];
                        actualParam.addUse(bb, this.actualReturn);
                    }
                } else if (calleeFlows.getResult() != null) {
                    calleeFlows.getResult().addUse(bb, this.actualReturn);
                }
            } else if (calleeFlows.getResult() != null) {
                calleeFlows.getResult().addUse(bb, this.actualReturn);
            }
        }
        assert (this.isClone() && this.originalInvoke != null);
        calleeFlows.getMethod().registerAsImplementationInvoked(this.originalInvoke);
    }

    public abstract Collection<AnalysisMethod> getCallees();

    public boolean canBeStaticallyBound() {
        boolean triviallyStaticallyBound = this.invoke.callTarget().targetMethod().canBeStaticallyBound();
        if (triviallyStaticallyBound) {
            assert (this.getCallees().size() <= 1) : "Statically bound result mismatch between analysis and host VM.";
            return true;
        }
        return this.getCallees().size() == 1;
    }

    public abstract Collection<MethodFlowsGraph> getCalleesFlows(BigBang var1);
}

