/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.constraints;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.constraints.ShortestInvokeChainPrinter;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;

public class UnsupportedFeatures {
    private final ConcurrentHashMap<String, Data> messages = new ConcurrentHashMap();

    public void addMessage(String key, AnalysisMethod method, String message) {
        this.addMessage(key, method, message, null, null);
    }

    public void addMessage(String key, AnalysisMethod method, String message, String trace) {
        this.addMessage(key, method, message, trace, null);
    }

    public void addMessage(String key, AnalysisMethod method, String message, String trace, Throwable originalException) {
        this.messages.putIfAbsent(key, new Data(key, method, message, trace, originalException));
    }

    public void report(BigBang bb) {
        if (this.exist()) {
            String unsupportedFeaturesMessage;
            ArrayList<Data> entries = new ArrayList<Data>(this.messages.values());
            Collections.sort(entries);
            boolean singleEntry = entries.size() == 1;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(outputStream);
            for (Data entry : entries) {
                if (!singleEntry) {
                    printStream.println("Error: " + entry.message);
                }
                if (entry.trace != null) {
                    printStream.println("Trace: " + entry.trace);
                }
                if (entry.method != null) {
                    printStream.println("Call path from entry point to " + entry.method.format("%H.%n(%p)") + ": ");
                    ShortestInvokeChainPrinter.print(bb, entry.method, printStream);
                    printStream.println();
                }
                if (singleEntry || entry.originalException == null || entry.originalException instanceof UnsupportedFeatureException) continue;
                printStream.print("Original exception that caused the problem: ");
                entry.originalException.printStackTrace(printStream);
            }
            printStream.close();
            if (singleEntry) {
                unsupportedFeaturesMessage = ((Data)entries.get((int)0)).message + "\nDetailed message:\n" + outputStream.toString();
                throw new UnsupportedFeatureException(unsupportedFeaturesMessage, ((Data)entries.get((int)0)).originalException);
            }
            unsupportedFeaturesMessage = "Unsupported features in " + entries.size() + " methods\nDetailed message:\n" + outputStream.toString();
            throw new UnsupportedFeatureException(unsupportedFeaturesMessage);
        }
    }

    public boolean exist() {
        return !this.messages.isEmpty();
    }

    public void checkMethod(AnalysisMethod method, StructuredGraph graph) {
        ValueNode receiver;
        if (method.isEntryPoint() && !Modifier.isStatic(graph.method().getModifiers()) && (receiver = graph.start().stateAfter().localAt(0)) != null && receiver.usages().count() > 0) {
            throw new UnsupportedFeatureException("Entry point is non-static and uses its receiver: " + method.format("%r %H.%n(%p)"));
        }
    }

    static class Data
    implements Comparable<Data> {
        protected final String key;
        protected final AnalysisMethod method;
        protected final String message;
        protected final String trace;
        protected final Throwable originalException;

        Data(String key, AnalysisMethod method, String message, String trace, Throwable originalException) {
            this.key = key;
            this.method = method;
            this.message = message != null ? message : "";
            this.trace = trace;
            this.originalException = originalException;
        }

        @Override
        public int compareTo(Data other) {
            int result = this.message.compareTo(other.message);
            if (result == 0) {
                result = this.key.compareTo(other.key);
            }
            return result;
        }
    }
}

