/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JGeometry
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4792272186565640701L;
    public static final int GTYPE_POINT = 1;
    public static final int GTYPE_CURVE = 2;
    public static final int GTYPE_POLYGON = 3;
    public static final int GTYPE_COLLECTION = 4;
    public static final int GTYPE_MULTIPOINT = 5;
    public static final int GTYPE_MULTICURVE = 6;
    public static final int GTYPE_MULTIPOLYGON = 7;
    private static final int ETYPE_UNKNOWN = 0;
    private static final int ETYPE_POINT = 1;
    private static final int ETYPE_CURVE = 2;
    private static final int ETYPE_RING = 3;
    private static final int ETYPE_COMPOUNDCURVE = 4;
    private static final int ETYPE_COMPOUNDRING = 5;
    private static final int EITPR_UNKNOWN = 0;
    private static final int EITPR_LINEAR = 1;
    private static final int EITPR_ARC = 2;
    private static final int EITPR_RECTANGLE = 3;
    private static final int EITPR_CIRCLE = 4;
    private static final int EITPR_GEODETICMBR = 3;
    private static final int ETOPO_NA = 0;
    private static final int ETOPO_UNKNOWN = 0;
    private static final int ETOPO_EXTERIOR = 1;
    private static final int ETOPO_INTERIOR = 2;
    static StructDescriptor geomDesc = null;
    static StructDescriptor pointDesc = null;
    static ArrayDescriptor elemInfoDesc = null;
    static ArrayDescriptor ordinatesDesc = null;
    int gtype = 0;
    int linfo = 0;
    int srid = 0;
    double x = Double.NaN;
    double y = Double.NaN;
    double z = Double.NaN;
    int[] elemInfo = null;
    double[] ordinates = null;
    double[] mbr = null;
    int dim = 2;

    JGeometry(int n, int n2) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        this.dim = n / 1000 > 0 ? n / 1000 : 2;
        this.srid = n2 <= 0 ? 0 : n2;
    }

    public JGeometry(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) {
        this(n, n2);
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.elemInfo = nArray;
        this.ordinates = dArray;
    }

    public JGeometry(int n, int n2, int[] nArray, double[] dArray) {
        this(n, n2);
        this.elemInfo = nArray;
        this.ordinates = dArray;
    }

    public JGeometry(double d, double d2, int n) {
        this(1, n);
        this.x = d;
        this.y = d2;
    }

    public JGeometry(double d, double d2, double d3, int n) {
        this(3001, n);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public JGeometry(double d, double d2, double d3, double d4, int n) {
        this(3, n);
        this.elemInfo = new int[3];
        this.elemInfo[0] = 1;
        this.elemInfo[1] = 1003;
        this.elemInfo[2] = 3;
        this.ordinates = new double[4];
        this.ordinates[0] = d;
        this.ordinates[1] = d2;
        this.ordinates[2] = d3;
        this.ordinates[3] = d4;
    }

    public Object clone() {
        JGeometry jGeometry = new JGeometry(this.gtype, this.srid);
        jGeometry.dim = this.dim;
        jGeometry.x = this.x;
        jGeometry.y = this.y;
        jGeometry.z = this.z;
        if (this.elemInfo != null) {
            jGeometry.elemInfo = new int[this.elemInfo.length];
            System.arraycopy(this.elemInfo, 0, jGeometry.elemInfo, 0, this.elemInfo.length);
        }
        if (this.ordinates != null) {
            jGeometry.ordinates = new double[this.ordinates.length];
            System.arraycopy(this.ordinates, 0, jGeometry.ordinates, 0, this.ordinates.length);
        }
        if (this.mbr != null) {
            jGeometry.mbr = new double[this.mbr.length];
            System.arraycopy(this.mbr, 0, jGeometry.mbr, 0, this.mbr.length);
        }
        return jGeometry;
    }

    public static JGeometry createPoint(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(1, n2);
        jGeometry.dim = dArray.length;
        jGeometry.x = dArray[0];
        jGeometry.y = dArray[1];
        if (n == 3) {
            jGeometry.z = dArray[2];
        }
        return jGeometry;
    }

    public static JGeometry createLRSPoint(double[] dArray, int n, int n2) {
        try {
            if (n == 2 && dArray.length == 3) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(3301, n2, nArray, dArray);
                return jGeometry;
            }
            if (n == 3 && dArray.length == 4) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(4401, n2, nArray, dArray);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Point type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createCircle(double d, double d2, double d3, int n) {
        return JGeometry.createCircle(d + d3 * Math.cos(0.7853981633974483), d2 + d3 * Math.sin(0.7853981633974483), d + d3 * Math.cos(2.356194490192345), d2 + d3 * Math.sin(2.356194490192345), d + d3 * Math.cos(4.71238898038469), d2 + d3 * Math.sin(4.71238898038469), n);
    }

    public static JGeometry createCircle(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        if (JGeometry.orientation(d, d2, d3, d4, d5, d6) == 0.0) {
            return null;
        }
        JGeometry jGeometry = new JGeometry(3, n);
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 4;
        jGeometry.ordinates = new double[6];
        jGeometry.ordinates[0] = d;
        jGeometry.ordinates[1] = d2;
        jGeometry.ordinates[2] = d3;
        jGeometry.ordinates[3] = d4;
        jGeometry.ordinates[4] = d5;
        jGeometry.ordinates[5] = d6;
        return jGeometry;
    }

    public static JGeometry createLinearLineString(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearLineString(double[] dArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 3, n2);
                jGeometry.setType(3302);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 4, n2);
                jGeometry.setType(4402);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Line type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLinearMultiLineString(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createLinearLineString((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(6, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        int n4 = 1;
        jGeometry.elemInfo = new int[n3 * 3];
        for (int i = 0; i < n3; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n4;
            jGeometry.elemInfo[i * 3 + 1] = 2;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n4 += ((double[])objectArray[i]).length;
        }
        double[] dArray = new double[n4 - 1];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearMultiLineString(Object[] objectArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 3, n2);
                jGeometry.setType(3306);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 4, n2);
                jGeometry.setType(4406);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS MultiLine type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createMultiPoint(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createPoint((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(5, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1;
        jGeometry.elemInfo[2] = n3;
        double[] dArray = new double[n3 * n];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n4, n);
            n4 += n;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = JGeometry.closeCoords(dArray, n);
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(Object[] objectArray, int n, int n2) {
        int n3;
        if (objectArray.length == 1) {
            return JGeometry.createLinearPolygon((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        int n4 = objectArray.length;
        Object[] objectArray2 = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray2[n3] = JGeometry.closeCoords((double[])objectArray[n3], n);
        }
        n3 = 1;
        jGeometry.elemInfo = new int[n4 * 3];
        for (int i = 0; i < n4; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n3;
            jGeometry.elemInfo[i * 3 + 1] = i == 0 ? 1003 : 2003;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n3 += ((double[])objectArray2[i]).length;
        }
        double[] dArray = new double[n3 - 1];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double[] dArray2 = (double[])objectArray2[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearPolygon(double[] dArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(dArray, 3, n2);
                jGeometry.setType(3303);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(dArray, 4, n2);
                jGeometry.setType(4403);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLRSLinearPolygon(Object[] objectArray, int n, int n2) {
        try {
            if (objectArray instanceof double[][]) {
                for (int i = 0; i < objectArray.length; ++i) {
                    double[] dArray = ((double[][])objectArray)[i];
                    if (JGeometry.monoMeasure(dArray, n + 1) != 0) continue;
                    System.out.println("Inconsistent LRS Measure Values");
                    return null;
                }
            }
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(objectArray, 3, n2);
                jGeometry.setType(3303);
                return jGeometry;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygon(objectArray, 4, n2);
                jGeometry.setType(4403);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static int monoMeasure(double[] dArray, int n) {
        int n2;
        double d = Double.NaN;
        int n3 = 0;
        int n4 = 0;
        double d2 = Double.NaN;
        for (n2 = n - 1; n2 < dArray.length; n2 += n) {
            d = dArray[n2];
            if (Double.isNaN(d)) continue;
            n3 = n2;
            break;
        }
        n4 = dArray[n3] == dArray[dArray.length - 1] && dArray[n3 - (n - 2)] == dArray[dArray.length - (n - 1)] && dArray[n3 - (n - 1)] == dArray[dArray.length - n] ? dArray.length - n : dArray.length;
        if (Double.isNaN(d)) {
            return 1;
        }
        int n5 = 0;
        double d3 = d;
        for (n2 = n3 + n; n2 < n4; n2 += n) {
            d2 = dArray[n2];
            if (Double.isNaN(d2)) continue;
            double d4 = d2 - d3;
            if (n5 == 0) {
                n5 = d4 > 0.0 ? 1 : (d4 < 0.0 ? -1 : 0);
            } else if (d4 * (double)n5 < 0.0) {
                return 0;
            }
            d3 = d2;
        }
        if (n5 == 0) {
            return 1;
        }
        return n5;
    }

    public int getType() {
        return this.gtype;
    }

    public void setType(int n) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        if (n / 1000 > 0) {
            this.dim = n / 1000;
        }
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public Point2D getLabelPoint() {
        if (Double.isNaN(this.x) || Double.isNaN(this.y)) {
            return null;
        }
        return new Point2D.Double(this.x, this.y);
    }

    public double[] getPoint() {
        if (this.gtype != 1) {
            return null;
        }
        double[] dArray = new double[this.dim];
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        if (this.elemInfo.length == 3) {
            for (int i = 0; i < this.dim; ++i) {
                dArray[i] = this.ordinates[i];
            }
            return dArray;
        }
        double[] dArray2 = this.getMBR();
        if (dArray2 == null) {
            return null;
        }
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        return dArray;
    }

    public Point2D getJavaPoint() {
        if (this.gtype != 1) {
            return null;
        }
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            return new Point2D.Double(this.x, this.y);
        }
        if (this.elemInfo.length == 3) {
            return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
        }
        double[] dArray = this.getMBR();
        if (dArray != null) {
            return new Point2D.Double(dArray[0], dArray[1]);
        }
        return null;
    }

    public Point2D[] getJavaPoints() {
        int n;
        int n2 = this.elemInfo[1] % 10;
        int n3 = n = this.elemInfo[2];
        if (this.gtype != 5 || n2 != 1 || this.dim != 2) {
            return null;
        }
        Point2D[] point2DArray = new Point2D[n3];
        for (int i = 0; i < n3; ++i) {
            point2DArray[i] = new Point2D.Double(this.ordinates[i * this.dim], this.ordinates[i * this.dim + 1]);
        }
        return point2DArray;
    }

    public final boolean isPoint() {
        return this.gtype == 1;
    }

    public final boolean isMultiPoint() {
        return this.gtype == 5;
    }

    public final boolean isRectangle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 3 && this.elemInfo.length == 3;
    }

    public final boolean isCircle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 4 && this.elemInfo.length == 3;
    }

    public final boolean isGeodeticMBR() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 5 && this.elemInfo.length == 3;
    }

    public final boolean isLRSGeometry() {
        return this.dim <= 2 || this.linfo == 0 ? false : (this.dim == 3 ? this.linfo == 3 : (this.dim == 4 ? this.linfo == 3 || this.linfo == 4 : false));
    }

    public final boolean hasCircularArcs() {
        if (this.elemInfo != null) {
            for (int i = 1; i < this.elemInfo.length; i += 3) {
                int n = this.elemInfo[i];
                int n2 = this.elemInfo[i + 1];
                if ((n2 != 2 || n != 2 && n != 2003 && n != 3) && n != 4 && n != 5 && n != 2005) continue;
                return true;
            }
        }
        return false;
    }

    public int getDimensions() {
        return this.dim;
    }

    public double[] getOrdinatesArray() {
        return this.ordinates;
    }

    public int[] getElemInfo() {
        return this.elemInfo;
    }

    public final int getNumPoints() {
        if (this.gtype == 1) {
            return 1;
        }
        return this.ordinates.length / this.dim;
    }

    public double[] getFirstPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[i];
        }
        return dArray;
    }

    public double[] getLastPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        int n = this.ordinates.length - this.dim;
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[n + i];
        }
        return dArray;
    }

    public double[] getMBR() {
        if (this.mbr != null) {
            return this.mbr;
        }
        this.mbr = new double[4];
        if (this.isOptimizedPoint()) {
            this.mbr[0] = this.x;
            this.mbr[1] = this.y;
            this.mbr[2] = this.x;
            this.mbr[3] = this.y;
            return this.mbr;
        }
        if (this.isPoint() && this.elemInfo.length == 3) {
            this.mbr[0] = this.ordinates[0];
            this.mbr[1] = this.ordinates[1];
            this.mbr[2] = this.ordinates[0];
            this.mbr[3] = this.ordinates[1];
            return this.mbr;
        }
        if (this.isRectangle() || this.isGeodeticMBR()) {
            this.mbr[0] = Math.min(this.ordinates[0], this.ordinates[2]);
            this.mbr[1] = Math.min(this.ordinates[1], this.ordinates[3]);
            this.mbr[2] = Math.max(this.ordinates[0], this.ordinates[2]);
            this.mbr[3] = Math.max(this.ordinates[1], this.ordinates[3]);
            return this.mbr;
        }
        this.mbr[0] = Double.POSITIVE_INFINITY;
        this.mbr[1] = Double.POSITIVE_INFINITY;
        this.mbr[2] = Double.NEGATIVE_INFINITY;
        this.mbr[3] = Double.NEGATIVE_INFINITY;
        if (this.isMultiPoint() && this.elemInfo.length == 3) {
            int n = this.elemInfo[2];
            for (int i = 0; i < n; ++i) {
                JGeometry.expandMBR(this.mbr, this.ordinates[i * this.dim], this.ordinates[i * this.dim + 1]);
            }
            return this.mbr;
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block1: while (elementIterator.next()) {
            int n = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                double[] dArray;
                if (elementIterator.eitpr == 2) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block1;
                    dArray = JGeometry.computeArcMBR(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    this.expandMBR(this.mbr, dArray, 2);
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr == 4) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block1;
                    dArray = JGeometry.computeArc(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    double[] dArray2 = new double[]{dArray[0] - dArray[2], dArray[1] - dArray[2], dArray[0] + dArray[2], dArray[1] + dArray[2]};
                    this.expandMBR(this.mbr, dArray2, 2);
                    i += 2;
                    continue;
                }
                JGeometry.expandMBR(this.mbr, this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1]);
            }
        }
        return this.mbr;
    }

    public Object[] getOrdinatesOfElements() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        ElementIterator elementIterator = new ElementIterator(this);
        while (elementIterator.next()) {
            int n = elementIterator.ord_offset;
            double[] dArray = new double[elementIterator.nCoord * this.dim];
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    dArray[i * this.dim + j] = this.ordinates[n + i * this.dim + j];
                }
            }
            arrayList.add(dArray);
        }
        return arrayList.toArray();
    }

    public final Shape createShape() {
        GeneralPath generalPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            float f = (float)this.ordinates[0];
            float f2 = (float)this.ordinates[1];
            float f3 = (float)this.ordinates[2];
            float f4 = (float)this.ordinates[3];
            return new Rectangle2D.Double(f, Math.min(f2, f4), f3 - f, Math.abs(f4 - f2));
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.computeArc(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_;
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            int n = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.eitpr == 1) {
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)this.ordinates[n + i * this.dim], (float)this.ordinates[n + i * this.dim + 1]);
                    } else {
                        generalPath.lineTo((float)this.ordinates[n + i * this.dim], (float)this.ordinates[n + i * this.dim + 1]);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                    } else {
                        generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                    }
                    for (int j = 1; j < dArray.length / 2; ++j) {
                        generalPath.lineTo((float)dArray[j * 2], (float)dArray[j * 2 + 1]);
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    float f = (float)this.ordinates[n + 0];
                    float f5 = (float)this.ordinates[n + 1];
                    float f6 = (float)this.ordinates[n + this.dim];
                    float f7 = (float)this.ordinates[n + this.dim + 1];
                    if (elementIterator.original_etype < 2000) {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f6, f5);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f, f7);
                        generalPath.closePath();
                    } else {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f5);
                        generalPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = JGeometry.computeArc(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
                generalPath.append(double_, false);
                if (elementIterator.original_etype > 2000) {
                    generalPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return generalPath;
    }

    public static final JGeometry load(STRUCT sTRUCT) throws SQLException {
        double[] dArray;
        Datum[] datumArray;
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        int n = datumArray2[0] != null ? datumArray2[0].intValue() : 0;
        int n2 = datumArray2[1] != null ? datumArray2[1].intValue() : 0;
        STRUCT sTRUCT2 = (STRUCT)datumArray2[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (sTRUCT2 != null) {
            datumArray = sTRUCT2.getOracleAttributes();
            if (datumArray[0] != null && datumArray[1] != null) {
                d = datumArray[0].doubleValue();
                d2 = datumArray[1].doubleValue();
            }
            if (datumArray[2] != null) {
                d3 = datumArray[2].doubleValue();
            }
        }
        datumArray = datumArray2[3] != null ? ((ARRAY)datumArray2[3]).getIntArray() : null;
        double[] dArray2 = dArray = datumArray2[4] != null ? ((ARRAY)datumArray2[4]).getDoubleArray() : null;
        if (dArray != null && datumArray != null) {
            return new JGeometry(n, n2, d, d2, d3, (int[])datumArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JGeometry(d, d2, d3, n2);
            }
            return new JGeometry(d, d2, n2);
        }
        return null;
    }

    static final JGeometry loadAndReorient(STRUCT sTRUCT) throws SQLException {
        JGeometry jGeometry = JGeometry.load(sTRUCT);
        if (jGeometry == null) {
            return null;
        }
        if (!(jGeometry.gtype != 2 && jGeometry.gtype != 6 && jGeometry.gtype != 4 || jGeometry.hasCircularArcs())) {
            jGeometry.reOrientCurves();
        }
        return jGeometry;
    }

    public static STRUCT store(JGeometry jGeometry, Connection connection) throws SQLException {
        Object[] objectArray;
        if (geomDesc == null) {
            JGeometry.createDBDescriptors(connection);
        }
        if (geomDesc == null) {
            throw new SQLException("sdo_geometry descriptor could not be created.");
        }
        if (pointDesc == null) {
            throw new SQLException("sdo_point descriptor has not been created.");
        }
        if (elemInfoDesc == null) {
            throw new SQLException("elem_info descriptor has not been created.");
        }
        if (ordinatesDesc == null) {
            throw new SQLException("ordinates descriptor has not been created.");
        }
        NUMBER nUMBER = new NUMBER(jGeometry.gtype + jGeometry.linfo * 100 + jGeometry.dim * 1000);
        NUMBER nUMBER2 = jGeometry.srid == 0 ? null : new NUMBER(jGeometry.srid);
        STRUCT sTRUCT = null;
        Object[] objectArray2 = objectArray = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
        if (objectArray != null) {
            objectArray[0] = new NUMBER(new BigDecimal(jGeometry.x));
            objectArray[1] = new NUMBER(new BigDecimal(jGeometry.y));
            objectArray[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(new BigDecimal(jGeometry.z));
            sTRUCT = new STRUCT(pointDesc, connection, objectArray);
        }
        ARRAY aRRAY = jGeometry.elemInfo == null ? null : new ARRAY(elemInfoDesc, connection, (Object)jGeometry.elemInfo);
        BigDecimal[] bigDecimalArray = null;
        if (jGeometry.ordinates != null) {
            bigDecimalArray = new BigDecimal[jGeometry.ordinates.length];
            for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                bigDecimalArray[i] = new BigDecimal(jGeometry.ordinates[i]);
            }
        }
        ARRAY aRRAY2 = jGeometry.ordinates == null ? null : new ARRAY(ordinatesDesc, connection, (Object)bigDecimalArray);
        Object[] objectArray3 = new Object[]{nUMBER, nUMBER2, sTRUCT, aRRAY, aRRAY2};
        return new STRUCT(geomDesc, connection, objectArray3);
    }

    private final boolean isOptimizedPoint() {
        return this.gtype % 100 == 1 && this.ordinates == null && !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    private static final void createDBDescriptors(Connection connection) throws SQLException {
        geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
    }

    private final boolean isSimpleElement(int n) {
        return n == 1 || n == 2 || n % 10 == 3;
    }

    private final boolean isCompoundElement(int n) {
        return n == 4 || n % 10 == 5;
    }

    private static final void expandMBR(double[] dArray, double d, double d2) {
        if (dArray[0] > d) {
            dArray[0] = d;
        }
        if (dArray[1] > d2) {
            dArray[1] = d2;
        }
        if (dArray[2] < d) {
            dArray[2] = d;
        }
        if (dArray[3] < d2) {
            dArray[3] = d2;
        }
    }

    private final void expandMBR(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < dArray2.length / n; ++i) {
            int n2 = i * n;
            JGeometry.expandMBR(dArray, dArray2[n2], dArray2[n2 + 1]);
        }
    }

    private final void expandMBR(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        for (int i = 0; i < n2 / n3; ++i) {
            int n4 = n + i * n3;
            JGeometry.expandMBR(dArray, dArray2[n4], dArray2[n4 + 1]);
        }
    }

    private void reOrientCurves() {
        ElementIterator elementIterator = new ElementIterator(this);
        while (elementIterator.next()) {
            if (elementIterator.etype != 2) continue;
            int n = elementIterator.ord_offset;
            int n2 = elementIterator.nCoord;
            double d = this.ordinates[n + 0];
            double d2 = this.ordinates[n + this.dim];
            double d3 = this.ordinates[n + (n2 - 1) * this.dim];
            double d4 = this.ordinates[n + n2 / 2 * this.dim];
            if (d <= d3) continue;
            int n3 = 0;
            int n4 = n2 - 1;
            while (n3 < n2 / 2) {
                for (int i = 0; i < this.dim; ++i) {
                    double d5 = this.ordinates[n + n3 * this.dim + i];
                    this.ordinates[n + n3 * this.dim + i] = this.ordinates[n + n4 * this.dim + i];
                    this.ordinates[n + n4 * this.dim + i] = d5;
                }
                ++n3;
                --n4;
            }
        }
    }

    public static final double[] computeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d3 - d5;
        double d11 = d4 - d6;
        double d12 = d2 - d4;
        double d13 = d + d3;
        double d14 = d3 + d5;
        double d15 = d2 + d4;
        double d16 = d4 + d6;
        double d17 = d9 * d11 - d10 * d12;
        if (d17 > -4.9E-323 && d17 < 4.9E-323) {
            return null;
        }
        double[] dArray = new double[6];
        double d18 = (d11 * d13 * d9 - d12 * d14 * d10 + d12 * d11 * (d12 + d11)) / d17;
        double d19 = Math.abs(d4 - d6) < 5.0E-8 ? (d15 * d12 + (d13 - d18) * d9) / d12 : (d16 * d11 + (d14 - d18) * d10) / d11;
        double d20 = Math.sqrt(((d18 *= 0.5) - d) * (d18 - d) + ((d19 *= 0.5) - d2) * (d19 - d2));
        double d21 = Math.atan2(d2 - d19, d - d18);
        if (d21 < 0.0) {
            d21 += Math.PI * 2;
        }
        if ((d8 = Math.atan2(d4 - d19, d3 - d18)) < 0.0) {
            d8 += Math.PI * 2;
        }
        if ((d7 = Math.atan2(d6 - d19, d5 - d18)) < 0.0) {
            d7 += Math.PI * 2;
        }
        dArray[0] = d18;
        dArray[1] = d19;
        dArray[2] = d20;
        dArray[3] = d21;
        dArray[4] = d8;
        dArray[5] = d7;
        return dArray;
    }

    private static final double[] computeArcMBR(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double[] dArray2 = new double[]{Math.min(d, d5), Math.min(d2, d6), Math.max(d, d5), Math.max(d2, d6)};
        if (JGeometry.thetaInArc(0.0, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 + d9, d8);
        }
        if (JGeometry.thetaInArc(1.5707963267948966, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 + d9);
        }
        if (JGeometry.thetaInArc(Math.PI, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 - d9, d8);
        }
        if (JGeometry.thetaInArc(4.71238898038469, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 - d9);
        }
        dArray = new double[]{dArray2[0], dArray2[1], dArray2[0], dArray2[3], dArray2[2], dArray2[3], dArray2[2], dArray2[1]};
        return dArray;
    }

    private static final short thetaInArc(double d, double d2, double d3, double d4) {
        if (d == d2 || d == d3 || d == d2 + Math.PI * 2 || d == d3 + Math.PI * 2 || d == d2 - Math.PI * 2 || d == d3 - Math.PI * 2) {
            return -1;
        }
        int n = 0;
        if (d4 > 0.0) {
            n = (short)(n + 1);
        }
        if (d3 > d2) {
            n = (short)(n + 1);
        }
        if (d2 < d && d < d3 || d2 > d && d > d3) {
            n = (short)(n + 1);
        }
        return (short)(n & 1);
    }

    private static final double orientation(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * d4 + d3 * d6 + d5 * d2 - (d5 * d4 + d3 * d2 + d * d6);
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = n - 1;
        if (n2 < 1) {
            return null;
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d14 = d10;
        double d15 = d12;
        if (d13 > 0.0 && d15 < d14) {
            d15 += Math.PI * 2;
        } else if (d13 < 0.0 && d15 > d14) {
            d15 -= Math.PI * 2;
        }
        double[] dArray2 = new double[n * 2];
        for (int i = 0; i <= n2; ++i) {
            double d16 = d14 + (d15 - d14) * (double)i / (double)n2;
            dArray2[i * 2] = d7 + d9 * Math.cos(d16);
            dArray2[i * 2 + 1] = d8 + d9 * Math.sin(d16);
        }
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        int n;
        if (d7 <= 0.0) {
            return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, 32);
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = dArray[2];
        double d12 = dArray[3];
        double d13 = dArray[4];
        double d14 = dArray[5];
        double d15 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d16 = d14 - d12;
        if (d15 > 0.0 && d16 < 0.0) {
            d16 += Math.PI * 2;
        } else if (d15 < 0.0 && d16 > 0.0) {
            d16 -= Math.PI * 2;
        }
        if (d16 < 0.0) {
            d16 = -d16;
        }
        if ((n = (int)Math.ceil(d16 / (d8 = Math.acos(1.0 - d7 / d11) * 2.0))) < 1) {
            n = 1;
        }
        if (n > 1024) {
            n = 1024;
        }
        double d17 = d12;
        double d18 = d14;
        if (d15 > 0.0 && d18 < d17) {
            d18 += Math.PI * 2;
        } else if (d15 < 0.0 && d18 > d17) {
            d18 -= Math.PI * 2;
        }
        double[] dArray2 = new double[(n + 1) * 2];
        for (int i = 0; i <= n; ++i) {
            double d19 = d17 + (d18 - d17) * (double)i / (double)n;
            dArray2[i * 2] = d9 + d11 * Math.cos(d19);
            dArray2[i * 2 + 1] = d10 + d11 * Math.sin(d19);
        }
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        double d7 = dArray[2] / 250.0;
        return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, d7);
    }

    private static final double[] closeCoords(double[] dArray, int n) {
        int n2 = dArray.length / n - 1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (dArray[0 + i] == dArray[n2 * n + i]) continue;
            bl = false;
        }
        if (bl) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length + n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        ++n2;
        for (int i = 0; i < n; ++i) {
            dArray2[n2 * n + i] = dArray2[i];
        }
        return dArray2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.gtype);
        objectOutputStream.writeInt(this.linfo);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeDouble(this.x);
        objectOutputStream.writeDouble(this.y);
        objectOutputStream.writeDouble(this.z);
        objectOutputStream.writeObject(this.elemInfo);
        objectOutputStream.writeObject(this.ordinates);
        objectOutputStream.writeInt(this.dim);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.gtype = objectInputStream.readInt();
        this.linfo = objectInputStream.readInt();
        this.srid = objectInputStream.readInt();
        this.x = objectInputStream.readDouble();
        this.y = objectInputStream.readDouble();
        this.z = objectInputStream.readDouble();
        this.elemInfo = (int[])objectInputStream.readObject();
        this.ordinates = (double[])objectInputStream.readObject();
        this.dim = objectInputStream.readInt();
    }

    public long getSize() {
        return 40 + (this.elemInfo == null ? 0 : 4 * this.elemInfo.length) + (this.ordinates == null ? 0 : 8 * this.ordinates.length);
    }

    public String toString() {
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof JGeometry)) {
            return false;
        }
        JGeometry jGeometry = (JGeometry)object;
        return this.getType() == jGeometry.getType() && Arrays.equals(this.getPoint(), jGeometry.getPoint()) && Arrays.equals(this.getElemInfo(), jGeometry.getElemInfo()) && Arrays.equals(this.getOrdinatesArray(), jGeometry.getOrdinatesArray());
    }

    private static class ElementIterator {
        int ei = 0;
        int nextei = 0;
        int dim = 2;
        int gtype = 0;
        int[] elemInfo = null;
        double[] ordinates = null;
        int ord_offset = 0;
        int etype = 0;
        int original_etype = 0;
        int top_etype = 0;
        int eitpr = 0;
        int next_ord_offset = 0;
        int nCoord = 0;
        int nSubElement = 0;
        boolean lastElem = false;
        boolean isFirstElemOfCompound = false;
        boolean isCompound = false;

        public ElementIterator(JGeometry jGeometry) {
            this.gtype = jGeometry.gtype;
            this.elemInfo = jGeometry.elemInfo;
            this.ordinates = jGeometry.ordinates;
            if (jGeometry.dim > 0) {
                this.dim = jGeometry.dim;
            }
        }

        public boolean next() {
            if (this.elemInfo == null) {
                return false;
            }
            if (this.isFirstElemOfCompound && this.nSubElement > 0) {
                this.isFirstElemOfCompound = false;
            }
            if (this.nSubElement > 0) {
                --this.nSubElement;
            }
            if (this.nSubElement == 0) {
                this.isCompound = false;
            }
            while (true) {
                if (this.ei > this.elemInfo.length - 3) {
                    return false;
                }
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.original_etype = this.elemInfo[this.ei + 1];
                if (!this.isCompound) {
                    this.top_etype = this.etype;
                }
                this.eitpr = this.elemInfo[this.ei + 2];
                if (this.etype != 0) break;
                this.ei += 3;
            }
            if (this.etype >= 4) {
                this.isFirstElemOfCompound = true;
                this.isCompound = true;
                this.nSubElement = this.eitpr;
                this.ei += 3;
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.original_etype = this.elemInfo[this.ei + 1];
                this.eitpr = this.elemInfo[this.ei + 2];
            }
            this.nextei = this.ei + 3;
            this.ord_offset = this.elemInfo[this.ei] - 1;
            this.etype = this.elemInfo[this.ei + 1];
            this.original_etype = this.elemInfo[this.ei + 1];
            this.eitpr = this.elemInfo[this.ei + 2];
            this.lastElem = this.nextei > this.elemInfo.length - 3;
            this.next_ord_offset = this.lastElem ? this.ordinates.length : this.elemInfo[this.nextei] - 1;
            this.nCoord = (this.next_ord_offset - this.ord_offset) / this.dim;
            if (this.nSubElement > 1) {
                ++this.nCoord;
            }
            this.ei += 3;
            return true;
        }
    }

    public static class Point {
        double x;
        double y;
        double z;
        double m;

        public Point() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public final boolean equals(Point point) {
            return this.x == point.x && this.y == point.y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void set(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }
}

