/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import oracle.security.crypto.cert.GeneralName;
import oracle.security.crypto.cert.ext.BasicConstraintsExtension;

public class OracleCertExtension {
    private boolean b = false;
    private int[] c = null;
    boolean a = false;
    private boolean d = true;
    private BigInteger e = null;
    private ArrayList<GeneralName> f = null;

    public void setSubjectKeyId(boolean bl) {
        this.b = bl;
    }

    public void setBasicConstraints(boolean bl) {
        this.d = bl;
        this.e = this.d ? null : BigInteger.ZERO;
        this.a = true;
    }

    public void setBasicConstraints(String string) {
        this.d = true;
        this.e = new BigInteger(string);
        this.a = true;
    }

    public void setKeyUsage(String string) {
        int[] nArray = new int[9];
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("digitalSignature")) {
                nArray[n] = 0;
            } else if (string2.equals("nonRepudiation")) {
                nArray[n] = 1;
            } else if (string2.equals("keyEncipherment")) {
                nArray[n] = 2;
            } else if (string2.equals("dataEncipherment")) {
                nArray[n] = 3;
            } else if (string2.equals("keyAgreement")) {
                nArray[n] = 4;
            } else if (string2.equals("keyCertSign")) {
                nArray[n] = 5;
            } else if (string2.equals("cRLSign")) {
                nArray[n] = 6;
            } else if (string2.equals("encipherOnly")) {
                nArray[n] = 7;
            } else {
                if (!string2.equals("decipherOnly")) continue;
                nArray[n] = 8;
            }
            ++n;
        }
        this.c = Arrays.copyOf(nArray, n);
    }

    public boolean getSubjectKeyId() {
        return this.b;
    }

    public int[] getKeyUsage() {
        return this.c;
    }

    public BasicConstraintsExtension getBasicConstraints() {
        if (!this.a) {
            return null;
        }
        if (this.d && this.e != null) {
            return new BasicConstraintsExtension(this.e);
        }
        return new BasicConstraintsExtension(this.d);
    }

    public ArrayList<GeneralName> getSubjectAlternativeNamesList() {
        return this.f;
    }

    public void setSubjectAlternativeNamesList(ArrayList<GeneralName> arrayList) {
        this.f = arrayList;
    }
}

