/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CTTIoer11
extends T4CTTIMsg {
    final int MAXERRBUF = 512;
    long curRowNumber;
    long retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength;
    int warnFlag;
    int[] errorLength;
    byte[] errorMsg;
    byte[] oerepa;
    static final int OERFNCF = 32;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_20:58:27_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;

    T4CTTIoer11(T4CConnection _conn) {
        super(_conn, (byte)4);
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$16, null, _conn);
            }
            this.MAXERRBUF = 512;
            this.warnLength = 0;
            this.warnFlag = 0;
            this.errorLength = new int[1];
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$16, null);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$16, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$16, null, throwable2);
            }
            throw throwable;
        }
    }

    void init() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$0, this, new Object[0]);
            }
            this.retCode = 0L;
            this.errorMsg = null;
            this.oerepa = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    int unmarshal() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$1, this, new Object[0]);
            }
            this.unmarshalAttributes();
            if (this.retCode != 0L) {
                this.unmarshalErrorMessage();
            }
            int n2 = this.currCursorID;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$1, this, n2);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$1, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalErrorMessage() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$2, this, new Object[0]);
            }
            this.errorMsg = this.meg.unmarshalCLR();
            this.errorLength[0] = this.errorMsg.length;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalAttributes() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$3, this, new Object[0]);
            }
            if (this.connection.getTTCVersion() >= 3) {
                short _endToEndECIDSequenceNumber;
                this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
            }
            this.curRowNumber = this.meg.unmarshalUB4();
            this.retCode = this.meg.unmarshalUB2();
            this.arrayElemWError = this.meg.unmarshalUB2();
            this.arrayElemErrno = this.meg.unmarshalUB2();
            this.currCursorID = this.meg.unmarshalUB2();
            this.errorPosition = this.meg.unmarshalSB2();
            this.sqlType = this.meg.unmarshalUB1();
            this.oerFatal = this.meg.unmarshalSB1();
            this.flags = this.meg.unmarshalSB1();
            this.userCursorOpt = this.meg.unmarshalSB1();
            this.upiParam = this.meg.unmarshalUB1();
            this.warningFlag = this.meg.unmarshalUB1();
            this.rba = this.meg.unmarshalUB4();
            this.partitionId = this.meg.unmarshalUB2();
            this.tableId = this.meg.unmarshalUB1();
            this.blockNumber = this.meg.unmarshalUB4();
            this.slotNumber = this.meg.unmarshalUB2();
            this.osError = this.meg.unmarshalSWORD();
            this.stmtNumber = this.meg.unmarshalUB1();
            this.callNumber = this.meg.unmarshalUB1();
            this.pad1 = this.meg.unmarshalUB2();
            this.successIters = this.meg.unmarshalUB4();
            this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
            this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
            int oerepal = this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
            this.oerepa = (byte[])(oerepal > 0 ? Arrays.copyOf(this.connection.tmpBytes128, this.connection.tmpBytes128.length) : null);
            this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    void unmarshalWarning() throws IOException, SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$4, this, new Object[0]);
            }
            this.retCode = this.meg.unmarshalUB2();
            this.warnLength = this.meg.unmarshalUB2();
            this.warnFlag = this.meg.unmarshalUB2();
            if (this.retCode != 0L && this.warnLength > 0) {
                this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
                this.errorLength[0] = this.warnLength;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    void print() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (TRACE) {
                if (this.warnFlag != 0) {
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Current Row Number    :" + this.curRowNumber);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Returned Code         :" + this.retCode);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Array Element w/error :" + this.arrayElemWError);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Array Element errno   :" + this.arrayElemErrno);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Current Cursor ID     :" + this.currCursorID);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Error Position        :" + this.errorPosition);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  SQL command type      :" + this.sqlType);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Fatal                 :" + this.oerFatal);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Various flags         :" + this.flags);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  User cursor options   :" + this.userCursorOpt);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  UPI parameter that \n  generated the error   :" + this.upiParam);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Warning flags         :" + this.warningFlag);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "      Row ID structure  :rba=" + this.rba + ",partitionId=" + this.partitionId + ",tableId=" + this.tableId + "blockNumber=" + this.blockNumber + ",slotNumber=" + this.slotNumber);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Operating System Error:" + this.osError);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Statemente number     :" + this.stmtNumber);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Procedure call number :" + this.callNumber);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Pad1                  :" + this.pad1);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Successful iterations :" + this.successIters);
                    }
                } else {
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Warning length: " + this.warnLength);
                    }
                    if (bl) {
                        this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "  Warning flag: " + this.warnFlag);
                    }
                }
            }
            if (this.retCode != 0L) {
                if (bl) {
                    this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "**** Error Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true));
                }
            } else if (this.warnFlag != 0 && bl) {
                this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "Warning Message: " + this.meg.conv.CharBytesToString(this.errorMsg, this.warnLength, true));
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    void processError() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$6, this, new Object[0]);
            }
            this.processError(true);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void processError(boolean bl) throws SQLException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void throwException;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$7, this, bl);
            }
            this.processError((boolean)throwException, null);
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void processError(OracleStatement oracleStatement) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$8, this, oracleStatement);
            }
            this.processError(true, (OracleStatement)stmt);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void processError(boolean bl, OracleStatement oracleStatement) throws SQLException {
        boolean bl2 = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            int wrn;
            void throwException;
            long errNum;
            void stmt;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, bl, oracleStatement);
            }
            if (stmt != null) {
                stmt.numberOfExecutedElementsInBatch = (int)this.successIters;
            }
            if ((errNum = this.getRetCode()) != 0L) {
                if (bl2) {
                    this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoer.processError: retCode = " + errNum);
                }
                if (bl2) {
                    this.debug($$$loggerRef$$$9, Level.FINEST, $$$methodRef$$$9, "T4CTTIoer.processError: errorMsg = " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true));
                }
                switch ((int)errNum) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: 
                    case 3113: 
                    case 3114: {
                        this.connection.internalClose();
                        break;
                    }
                    case 902: 
                    case 21700: {
                        this.connection.removeAllDescriptor();
                    }
                }
                if (throwException != false) {
                    SQLException sqlException = (SQLException)DatabaseError.createSqlException(null, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)errNum).fillInStackTrace();
                    if (this.errorPosition >= 0 && stmt != null) {
                        sqlException.initCause(new OracleDatabaseException(this.errorPosition, (int)this.retCode, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), stmt.sqlObject.actualSql, stmt.sqlObject.originalSql));
                    }
                    SQLException sQLException = sqlException;
                    if (bl2) {
                        ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, sQLException);
                    }
                    throw sQLException;
                }
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, null);
                }
                return;
            }
            if (throwException == false) {
                if (bl2) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, null);
                }
                return;
            }
            if ((this.warningFlag & 1) == 1 && (((wrn = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (wrn & 4) == 4)) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(110).fillInStackTrace();
                if (bl2) {
                    ClioSupport.throwing($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, sQLException);
                }
                throw sQLException;
            }
            if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
                stmt.foundPlsqlCompilerWarning();
            }
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    void processWarning() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.retCode != 0L) {
                if (bl) {
                    this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "T4CTTIoer.processWarning: retCode = " + this.retCode);
                }
                if (bl) {
                    this.debug($$$loggerRef$$$10, Level.FINEST, $$$methodRef$$$10, "T4CTTIoer.processWarning: errorMsg = " + this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true));
                }
                SQLWarning sQLWarning = DatabaseError.newSqlWarning(this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), (int)this.retCode);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$10, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$10, this, sQLWarning);
                }
                throw sQLWarning;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    long getCurRowNumber() throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$11, this, new Object[0]);
            }
            long l2 = this.curRowNumber;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$11, this, l2);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$11, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    long getRetCode() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$12, this, new Object[0]);
            }
            long l2 = this.retCode;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$12, this, l2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$12, this, null);
            }
            return l2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$13, this, new Object[0]);
            }
            T4CConnection t4CConnection = this.connection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$13, this, t4CConnection);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$13, this, null);
            }
            return t4CConnection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    long updateChecksum(long l2) throws SQLException {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            long localCheckSum;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$14, this, l2);
            }
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.retCode);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.curRowNumber);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.errorPosition);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.sqlType);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.oerFatal);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.flags);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.userCursorOpt);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.upiParam);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.warningFlag);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.osError);
            localCheckSum = CRC64.updateChecksum(localCheckSum, this.successIters);
            long l3 = localCheckSum = CRC64.updateChecksum(localCheckSum, this.errorMsg, 0, this.errorMsg.length);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$14, this, l3);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$14, this, null);
            }
            return l3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        boolean bl = (0x200000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$15, null, new Object[0]);
            }
            if (LOGGER == null) {
                LOGGER = Logger.getLogger("oracle.jdbc.driver");
            }
            Logger logger = LOGGER;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$15, null, logger);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$15, null, null);
            }
            return logger;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, T4CTTIoer11.class, $$$methodRef$$$15, null, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$16 = T4CTTIoer11.class.getDeclaredConstructor(T4CConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = T4CTTIoer11.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CTTIoer11.class.getDeclaredMethod("updateChecksum", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CTTIoer11.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CTTIoer11.class.getDeclaredMethod("getRetCode", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CTTIoer11.class.getDeclaredMethod("getCurRowNumber", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CTTIoer11.class.getDeclaredMethod("processWarning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CTTIoer11.class.getDeclaredMethod("processError", Boolean.TYPE, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CTTIoer11.class.getDeclaredMethod("processError", OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CTTIoer11.class.getDeclaredMethod("processError", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CTTIoer11.class.getDeclaredMethod("processError", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CTTIoer11.class.getDeclaredMethod("print", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CTTIoer11.class.getDeclaredMethod("unmarshalWarning", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CTTIoer11.class.getDeclaredMethod("unmarshalAttributes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CTTIoer11.class.getDeclaredMethod("unmarshalErrorMessage", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CTTIoer11.class.getDeclaredMethod("unmarshal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CTTIoer11.class.getDeclaredMethod("init", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoer11"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

