/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.dms.console.DMSConsole;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class DMSFactory {
    protected static final EventFactoryIntf eventFactory = DMSConsole.getConsole().newEventFactory();
    protected static final NounFactoryIntf nounFactory = DMSConsole.getConsole().newNounFactory();
    protected static final PhaseEventFactoryIntf phaseEventFactory = DMSConsole.getConsole().newPhaseEventFactory();
    protected static final StateFactoryIntf stateFactory = DMSConsole.getConsole().newStateFactory();

    public static EventIntf createEvent(NounIntf noun, String name, String desc) {
        return eventFactory.create(noun, name, desc);
    }

    public static NounIntf createNoun(NounIntf noun, String name, String type) {
        return nounFactory.create(noun == null ? DMSFactory.getRoot() : noun, name, type == null ? "n/a" : type);
    }

    public static NounIntf createNoun(String path, String type) {
        return nounFactory.create(path, type == null ? "n/a" : type);
    }

    public static PhaseEventIntf createPhaseEvent(NounIntf noun, String name, String desc) {
        return phaseEventFactory.create(noun, name, desc);
    }

    public static StateIntf createState(NounIntf noun, String name, String units, String desc, int value) {
        return stateFactory.create(noun, name, units, desc, value);
    }

    public static StateIntf createState(NounIntf noun, String name, String units, String desc, Object value) {
        return stateFactory.create(noun, name, units, desc, value);
    }

    public static NounIntf getRoot() {
        return nounFactory.getRoot();
    }

    public static long getToken() {
        return phaseEventFactory.getToken();
    }

    public static NounIntf get(String name) {
        return nounFactory.get(name);
    }
}

