/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.InetAddress;
import java.util.logging.Logger;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.Packet;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

public class ConnectPacket
extends Packet
implements SQLnetDef {
    private boolean connDataOflow;
    private byte[] connBytes;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;

    public ConnectPacket(SessionAtts sAtts, boolean sendAttention, boolean useVIO) throws IOException {
        super(sAtts);
        this.data = sAtts.cOption.conn_data.toString();
        if (this.data != null) {
            this.data = ConnectPacket.makeConnectionStringUseIPAddresses(this.data, sAtts.nt.getInetAddress());
            this.connBytes = this.data.getBytes("ASCII");
            this.dataLen = this.connBytes.length;
        } else {
            this.connBytes = null;
            this.dataLen = 0;
        }
        this.connDataOflow = this.dataLen > 230;
        int bufferLength = !this.connDataOflow ? 74 + this.dataLen : 74;
        this.createBuffer(bufferLength, 1, sAtts.redirecting ? 2 : 0);
        sAtts.redirecting = false;
        this.buffer[8] = 1;
        this.buffer[9] = 62;
        this.buffer[10] = 1;
        this.buffer[11] = 44;
        int connFlag2 = 0;
        int opt = 1;
        if (sendAttention && sAtts.nt.isCharacteristicUrgentSupported()) {
            opt |= 0xC00;
            if (sAtts.anoEnabled) {
                connFlag2 = 1;
            }
        }
        if (useVIO) {
            opt |= 0x40;
        }
        this.buffer[12] = (byte)(opt >> 8 & 0xFF);
        this.buffer[13] = (byte)(opt & 0xFF);
        if (this.sdu < 65535) {
            this.buffer[14] = (byte)(this.sdu / 256);
            this.buffer[15] = (byte)(this.sdu % 256);
        } else {
            this.buffer[14] = -1;
            this.buffer[15] = -1;
        }
        if (this.tdu < 65535) {
            this.buffer[16] = (byte)(this.tdu / 256);
            this.buffer[17] = (byte)(this.tdu % 256);
        } else {
            this.buffer[16] = -1;
            this.buffer[17] = -1;
        }
        this.buffer[18] = 79;
        this.buffer[19] = -104;
        this.buffer[22] = 0;
        this.buffer[23] = 1;
        this.buffer[24] = (byte)(this.dataLen / 256);
        this.buffer[25] = (byte)(this.dataLen % 256);
        this.buffer[27] = 74;
        if (!sAtts.anoEnabled) {
            this.buffer[33] = 4;
            this.buffer[32] = 4;
        } else {
            this.buffer[32] = this.buffer[33] = (byte)sAtts.getANOFlags();
        }
        this.buffer[32] = (byte)(this.buffer[32] | 0x80);
        this.buffer[33] = (byte)(this.buffer[33] | 0x80);
        ConnectPacket.setUb2ToBytes(this.buffer, 50, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 52, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 54, 0);
        ConnectPacket.setUb2ToBytes(this.buffer, 56, 0);
        this.buffer[61] = (byte)(this.sdu & 0xFF);
        this.buffer[60] = (byte)(this.sdu >> 8 & 0xFF);
        this.buffer[59] = (byte)(this.sdu >> 16 & 0xFF);
        this.buffer[58] = (byte)(this.sdu >> 24 & 0xFF);
        this.buffer[65] = (byte)(this.tdu & 0xFF);
        this.buffer[64] = (byte)(this.tdu >> 8 & 0xFF);
        this.buffer[63] = (byte)(this.tdu >> 16 & 0xFF);
        this.buffer[62] = (byte)(this.tdu >> 24 & 0xFF);
        int compressionFieldBuilder = 0;
        if (sAtts.networkCompression.equals("on") || sAtts.networkCompression.equals("auto")) {
            compressionFieldBuilder = Integer.MIN_VALUE;
            if (sAtts.networkCompression.equals("auto")) {
                compressionFieldBuilder |= 0x40000000;
            }
            if (!sAtts.cOption.protocol.equalsIgnoreCase("tcp")) {
                compressionFieldBuilder |= 2;
            }
            int schemeShiftCounter = 26;
            for (String level : sAtts.networkCompressionLevelsArray) {
                if (level.equals("low")) {
                    compressionFieldBuilder |= 1 << schemeShiftCounter;
                } else if (level.equals("high")) {
                    compressionFieldBuilder |= 2 << schemeShiftCounter;
                }
                schemeShiftCounter -= 4;
            }
        }
        this.buffer[69] = (byte)(compressionFieldBuilder & 0xFF);
        this.buffer[68] = (byte)(compressionFieldBuilder >> 8 & 0xFF);
        this.buffer[67] = (byte)(compressionFieldBuilder >> 16 & 0xFF);
        this.buffer[66] = (byte)(compressionFieldBuilder >> 24 & 0xFF);
        this.buffer[73] = (byte)(connFlag2 & 0xFF);
        this.buffer[72] = (byte)(connFlag2 >> 8 & 0xFF);
        this.buffer[71] = (byte)(connFlag2 >> 16 & 0xFF);
        this.buffer[70] = (byte)(connFlag2 >> 24 & 0xFF);
        if (!this.connDataOflow && this.connBytes != null && this.connBytes.length > 0) {
            System.arraycopy(this.connBytes, 0, this.buffer, 74, this.connBytes.length);
        }
    }

    @Override
    protected void send() throws IOException {
        super.send();
        if (this.connDataOflow) {
            byte[] userBuffer = new byte[this.connBytes.length];
            System.arraycopy(this.connBytes, 0, userBuffer, 0, this.connBytes.length);
            this.sAtts.nsOutputStream.write(userBuffer);
            this.sAtts.nsOutputStream.flush();
        }
    }

    static final String makeConnectionStringUseIPAddresses(String cdata, InetAddress ipaddr) {
        String result = cdata;
        try {
            String cHost;
            NVPair nvpHost;
            NVNavigator nav = new NVNavigator();
            NVPair nvpConn = new NVFactory().createNVPair(cdata);
            NVPair nvpAddr = null;
            NVPair nvpAddrList = nav.findNVPair(nvpConn, "ADDRESS_LIST");
            nvpAddr = nvpAddrList != null ? nav.findNVPair(nvpAddrList, "ADDRESS") : nav.findNVPair(nvpConn, "ADDRESS");
            if (nvpAddr != null && (nvpHost = nav.findNVPair(nvpAddr, "HOST")) != null && (cHost = nvpHost.getAtom()) != null && !cHost.matches("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}") && !cHost.matches("[\\[[\\w:]*\\]]") && ipaddr != null) {
                nvpHost.setAtom(ipaddr.getHostAddress());
                result = nvpConn.toString();
            }
        }
        catch (NLException nLException) {
            // empty catch block
        }
        return result;
    }

    static {
        try {
            $$$methodRef$$$2 = ConnectPacket.class.getDeclaredConstructor(SessionAtts.class, Boolean.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ConnectPacket.class.getDeclaredMethod("makeConnectionStringUseIPAddresses", String.class, InetAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ConnectPacket.class.getDeclaredMethod("send", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

