/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.pool;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Executable;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleConnectionPoolDataSource;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OracleFailoverEventHandlerThread;
import oracle.jdbc.pool.OracleFailoverWorkerThread;
import oracle.jdbc.pool.OracleImplicitConnectionCache;
import oracle.ons.ONS;
import oracle.ons.ONSException;

@DefaultLogger(value="oracle.jdbc")
public class OracleConnectionCacheManager {
    private static OracleConnectionCacheManager cacheManagerInstance;
    protected Hashtable m_connCache = new Hashtable();
    public static final int REFRESH_INVALID_CONNECTIONS = 4096;
    public static final int REFRESH_ALL_CONNECTIONS = 8192;
    public static final String PHYSICAL_CONNECTION_CREATED_COUNT = "PhysicalConnectionCreatedCount";
    public static final String PHYSICAL_CONNECTION_CLOSED_COUNT = "PhysicalConnectionClosedCount";
    protected static final int FAILOVER_EVENT_TYPE_SERVICE = 256;
    protected static final int FAILOVER_EVENT_TYPE_HOST = 512;
    protected static final String EVENT_DELIMITER = "{} =";
    protected OracleFailoverEventHandlerThread failoverEventHandlerThread = null;
    private static boolean isONSInitializedForRemoteSubscription;
    static final int ORAERROR_END_OF_FILE_ON_COM_CHANNEL = 3113;
    static final int ORAERROR_NOT_CONNECTED_TO_ORACLE = 3114;
    static final int ORAERROR_INIT_SHUTDOWN_IN_PROGRESS = 1033;
    static final int ORAERROR_ORACLE_NOT_AVAILABLE = 1034;
    static final int ORAERROR_IMMEDIATE_SHUTDOWN_IN_PROGRESS = 1089;
    static final int ORAERROR_SHUTDOWN_IN_PROGRESS_NO_CONN = 1090;
    static final int ORAERROR_NET_IO_EXCEPTION = 17002;
    protected int[] fatalErrorCodes = null;
    protected int failoverEnabledCacheCount = 0;
    protected static AtomicInteger UNNAMED_CACHE_COUNT;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Apr_04_20:55:48_PDT_2019";
    public static boolean TRACE;
    private static Logger LOGGER;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;
    private static Executable $$$methodRef$$$29;
    private static Logger $$$loggerRef$$$29;
    private static Executable $$$methodRef$$$30;
    private static Logger $$$loggerRef$$$30;

    private OracleConnectionCacheManager() {
        UNNAMED_CACHE_COUNT = new AtomicInteger();
    }

    public static synchronized OracleConnectionCacheManager getConnectionCacheManagerInstance() throws SQLException {
        block3: {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try {
                if (cacheManagerInstance == null) {
                    cacheManagerInstance = new OracleConnectionCacheManager();
                }
            }
            catch (RuntimeException re) {
                if (!bl) break block3;
                OracleLog.debug($$$loggerRef$$$0, Level.INFO, OracleConnectionCacheManager.class, $$$methodRef$$$0, "OracleConnectionCacheManager.getConnectionCacheManagerInstance(): RuntimeException : " + re.getMessage());
            }
        }
        return cacheManagerInstance;
    }

    public String createCache(OracleDataSource ods, Properties cacheProperties) throws SQLException {
        String connectionCacheName = null;
        if (ods == null || !ods.getConnectionCachingEnabled()) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        connectionCacheName = ods.connCacheName != null ? ods.connCacheName : ods.dataSourceName + "#0x" + Integer.toHexString(UNNAMED_CACHE_COUNT.getAndIncrement());
        this.createCache(connectionCacheName, ods, cacheProperties);
        return connectionCacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createCache(String cacheName, OracleDataSource ods, Properties cacheProperties) throws SQLException {
        if (ods == null || !ods.getConnectionCachingEnabled()) {
            throw (SQLException)DatabaseError.createSqlException(137).fillInStackTrace();
        }
        if (cacheName == null) {
            throw (SQLException)DatabaseError.createSqlException(138).fillInStackTrace();
        }
        if (this.m_connCache.containsKey(cacheName)) {
            throw (SQLException)DatabaseError.createSqlException(140).fillInStackTrace();
        }
        boolean _odsIsFcfEnabled = ods.getFastConnectionFailoverEnabled();
        if (_odsIsFcfEnabled && this.failoverEventHandlerThread == null) {
            final String onsConfigStr = ods.getONSConfiguration();
            if (onsConfigStr != null && !onsConfigStr.equals("")) {
                OracleConnectionCacheManager oracleConnectionCacheManager = this;
                synchronized (oracleConnectionCacheManager) {
                    if (!isONSInitializedForRemoteSubscription) {
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction(){
                                private static Executable $$$methodRef$$$0;
                                private static Logger $$$loggerRef$$$0;
                                private static Executable $$$methodRef$$$1;
                                private static Logger $$$loggerRef$$$1;

                                public Object run() throws ONSException {
                                    ONS ons = new ONS(onsConfigStr);
                                    return null;
                                }

                                static {
                                    try {
                                        $$$methodRef$$$1 = 1.class.getDeclaredConstructor(OracleConnectionCacheManager.class, String.class);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                    try {
                                        $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                                    }
                                    catch (Throwable throwable) {}
                                    $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                                }
                            });
                        }
                        catch (PrivilegedActionException onsexc) {
                            throw (SQLException)DatabaseError.createSqlException(175, (Object)onsexc).fillInStackTrace();
                        }
                        isONSInitializedForRemoteSubscription = true;
                    }
                }
            }
            this.failoverEventHandlerThread = new OracleFailoverEventHandlerThread();
        }
        OracleImplicitConnectionCache icc = new OracleImplicitConnectionCache(ods, cacheProperties);
        icc.cacheName = cacheName;
        ods.odsCache = icc;
        this.m_connCache.put(cacheName, icc);
        if (_odsIsFcfEnabled) {
            this.checkAndStartThread(this.failoverEventHandlerThread);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeCache(String string, long l2) throws SQLException {
        void waitTimeout;
        void cacheName;
        OracleImplicitConnectionCache oicc;
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.remove(cacheName) : null;
        if (oicc != null) {
            block6: {
                oicc.disableConnectionCache();
                if (waitTimeout > 0L) {
                    try {
                        Thread.currentThread();
                        Thread.sleep((long)(waitTimeout * 1000L));
                    }
                    catch (InterruptedException ea) {
                        if (!bl) break block6;
                        this.debug($$$loggerRef$$$3, Level.FINEST, $$$methodRef$$$3, "OracleConnectionCacheManager.removeCache() - Exception Occurred : " + ea.getMessage());
                    }
                }
            }
            if (oicc.cacheEnabledDS.getFastConnectionFailoverEnabled()) {
                this.cleanupFCFThreads(oicc);
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oicc.closeConnectionCache(waitTimeout < 0L ? 32 : 1);
        oicc = null;
    }

    public void reinitializeCache(String cacheName, Properties cacheProperties) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        this.disableCache(cacheName);
        oicc.reinitializeCacheConnections(cacheProperties);
        this.enableCache(cacheName);
    }

    public boolean existsCache(String cacheName) throws SQLException {
        return this.m_connCache.containsKey(cacheName);
    }

    public void enableCache(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oicc.enableConnectionCache();
    }

    public void disableCache(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oicc.disableConnectionCache();
    }

    public void refreshCache(String cacheName, int mode) throws SQLException {
        block4: {
            block3: {
                OracleImplicitConnectionCache oicc;
                OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
                if (oicc == null) break block3;
                switch (mode) {
                    case 4096: 
                    case 8192: {
                        oicc.refreshCacheConnections(mode);
                        break block4;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(68).fillInStackTrace();
                    }
                }
            }
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
    }

    public void purgeCache(String cacheName, boolean cleanupCheckedOutConnections) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc == null) {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        oicc.purgeCacheConnections(cleanupCheckedOutConnections, 1);
    }

    public Properties getCacheProperties(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.getConnectionCacheProperties();
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public String[] getCacheNameList() throws SQLException {
        String[] sArray = this.m_connCache.keySet().toArray(new String[this.m_connCache.size()]);
        return sArray;
    }

    public int getNumberOfAvailableConnections(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.cacheSize;
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public int getNumberOfActiveConnections(String cacheName) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            return oicc.getNumberOfCheckedOutConnections();
        }
        throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
    }

    public synchronized void setConnectionPoolDataSource(String cacheName, ConnectionPoolDataSource ds) throws SQLException {
        OracleImplicitConnectionCache oicc;
        OracleImplicitConnectionCache oracleImplicitConnectionCache = oicc = cacheName != null ? (OracleImplicitConnectionCache)this.m_connCache.get(cacheName) : null;
        if (oicc != null) {
            if (oicc.cacheSize > 0) {
                throw (SQLException)DatabaseError.createSqlException(78).fillInStackTrace();
            }
        } else {
            throw (SQLException)DatabaseError.createSqlException(141).fillInStackTrace();
        }
        ((OracleConnectionPoolDataSource)ds).makeURL();
        ((OracleConnectionPoolDataSource)ds).setURL(((OracleConnectionPoolDataSource)ds).url);
        oicc.connectionPoolDS = (OracleConnectionPoolDataSource)ds;
    }

    /*
     * WARNING - void declaration
     */
    protected void verifyAndHandleEvent(int n2, byte[] byArray) throws SQLException {
        boolean isEventValid;
        StringTokenizer strTokens;
        int cardinality;
        String status;
        String hostNameKey;
        String dbUniqNameKey;
        String instNameKey;
        String svcName;
        boolean bl;
        block17: {
            bl = (0L & TraceControllerImpl.feature) != 0L;
            svcName = null;
            instNameKey = null;
            dbUniqNameKey = null;
            hostNameKey = null;
            status = null;
            cardinality = 0;
            strTokens = null;
            isEventValid = true;
            try {
                void eventBody;
                strTokens = new StringTokenizer(new String((byte[])eventBody, "UTF-8"), EVENT_DELIMITER, true);
            }
            catch (UnsupportedEncodingException e2) {
                if (!bl) break block17;
                this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "OracleConnectionCacheManager : verifyAndHandleEvent() - UTF-8 Encoding Exception" + e2.getMessage());
            }
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            val = null;
            st = strTokens.nextToken();
            if (st.equals("=") && strTokens.hasMoreTokens()) {
                val = strTokens.nextToken();
            } else {
                key = st;
            }
            if (key.equalsIgnoreCase("version") && val != null && !val.startsWith("1.")) {
                isEventValid = false;
                if (bl) {
                    this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "Invalid event version: " + val);
                }
            }
            if (key.equalsIgnoreCase("service") && val != null) {
                svcName = val;
            }
            if (key.equalsIgnoreCase("instance") && val != null && !val.equals(" ")) {
                instNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("database") && val != null) {
                dbUniqNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("host") && val != null) {
                hostNameKey = val.toLowerCase().intern();
            }
            if (key.equalsIgnoreCase("status") && val != null) {
                status = val;
            }
            if (!key.equalsIgnoreCase("card") || val == null) continue;
            try {
                cardinality = Integer.parseInt(val);
            }
            catch (NumberFormatException nfe) {
                isEventValid = false;
                if (!bl) continue;
                this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "OracleConnectionCacheManager : verifyAndHandleEvent() - Cardinality value= " + val + " : Error : " + nfe.getMessage());
            }
        }
        if (isEventValid) {
            void eventType;
            this.invokeFailoverProcessingThreads((int)eventType, svcName, instNameKey, dbUniqNameKey, hostNameKey, status, cardinality);
        } else if (bl) {
            this.debug($$$loggerRef$$$15, Level.FINEST, $$$methodRef$$$15, "Dropped invalid event");
        }
        strTokens = null;
    }

    private void invokeFailoverProcessingThreads(int eventType, String svcName, String instNameKey, String dbUniqNameKey, String hostNameKey, String status, int card) throws SQLException {
        OracleImplicitConnectionCache oicc2 = null;
        boolean serviceEvent = false;
        boolean hostEvent = false;
        if (eventType == 256) {
            serviceEvent = true;
        }
        if (eventType == 512) {
            hostEvent = true;
        }
        for (OracleImplicitConnectionCache oicc2 : this.m_connCache.values()) {
            if ((!serviceEvent || !svcName.equalsIgnoreCase(oicc2.dataSourceServiceName)) && !hostEvent) continue;
            OracleFailoverWorkerThread workerTh = new OracleFailoverWorkerThread(oicc2, eventType, instNameKey, dbUniqNameKey, hostNameKey, status, card);
            this.checkAndStartThread(workerTh);
            oicc2.failoverWorkerThread = workerTh;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void checkAndStartThread(Thread thread) throws SQLException {
        block3: {
            boolean bl = (0L & TraceControllerImpl.feature) != 0L;
            try {
                void thr;
                if (!thr.isAlive()) {
                    thr.setDaemon(true);
                    thr.start();
                }
            }
            catch (IllegalThreadStateException ie) {
                if (!bl) break block3;
                this.debug($$$loggerRef$$$17, Level.FINEST, $$$methodRef$$$17, "OracleConnectionCacheManager.checkAndStartThread() - IllegalThreadStateException occurred:" + ie.getMessage());
            }
        }
    }

    protected boolean failoverEnabledCacheExists() {
        return this.failoverEnabledCacheCount > 0;
    }

    /*
     * WARNING - void declaration
     */
    protected void parseRuntimeLoadBalancingEvent(String string, byte[] byArray) throws SQLException {
        boolean bl = (0L & TraceControllerImpl.feature) != 0L;
        OracleImplicitConnectionCache icc = null;
        Enumeration iccSet = this.m_connCache.elements();
        while (iccSet.hasMoreElements()) {
            try {
                void eventBody;
                void service;
                icc = (OracleImplicitConnectionCache)iccSet.nextElement();
                if (!service.equalsIgnoreCase(icc.dataSourceServiceName)) continue;
                if (eventBody == null) {
                    icc.zapRLBInfo();
                    continue;
                }
                this.retrieveServiceMetrics(icc, (byte[])eventBody);
            }
            catch (Exception e2) {
                if (!bl) continue;
                this.debug($$$loggerRef$$$19, Level.FINEST, $$$methodRef$$$19, "(RLB)OracleConnectionCacheManager.parseRuntimeLoadBalancingEvent():" + e2.getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void retrieveServiceMetrics(OracleImplicitConnectionCache oracleImplicitConnectionCache, byte[] byArray) throws SQLException {
        void icc;
        boolean updateNecessary;
        int flag;
        int percent;
        String dbUniqNameKey;
        String instNameKey;
        StringTokenizer strTokens;
        boolean bl;
        block17: {
            bl = (0L & TraceControllerImpl.feature) != 0L;
            strTokens = null;
            instNameKey = null;
            dbUniqNameKey = null;
            percent = 0;
            flag = 0;
            updateNecessary = false;
            try {
                void eventBody;
                strTokens = new StringTokenizer(new String((byte[])eventBody, "UTF-8"), EVENT_DELIMITER, true);
            }
            catch (UnsupportedEncodingException e2) {
                if (!bl) break block17;
                this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "OracleConnectionCacheManager : retrieveServiceMetrics() - (RLB)UTF-8 Encoding Exception:" + e2.getMessage());
            }
        }
        String st = null;
        String val = null;
        String key = null;
        while (strTokens.hasMoreTokens()) {
            block18: {
                val = null;
                st = strTokens.nextToken();
                if (st.equals("=") && strTokens.hasMoreTokens()) {
                    val = strTokens.nextToken();
                } else {
                    if (st.equals("}")) {
                        if (!updateNecessary) continue;
                        icc.updateDatabaseInstance(dbUniqNameKey, instNameKey, percent, flag);
                        updateNecessary = false;
                        continue;
                    }
                    if (st.equals("{") || st.equals(" ")) continue;
                    key = st;
                    updateNecessary = true;
                }
                if (key.equalsIgnoreCase("version") && val != null && !val.equals("1.0")) {
                    throw (SQLException)DatabaseError.createSqlException(146).fillInStackTrace();
                }
                if (key.equalsIgnoreCase("database") && val != null) {
                    dbUniqNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("instance") && val != null) {
                    instNameKey = val.toLowerCase().intern();
                }
                if (key.equalsIgnoreCase("percent") && val != null) {
                    try {
                        percent = Integer.parseInt(val);
                        if (percent == 0) {
                            percent = 1;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        if (!bl) break block18;
                        this.debug($$$loggerRef$$$20, Level.FINEST, $$$methodRef$$$20, "(RLB)OracleConnectionCacheManager.retrieveServiceMetrics() - Exception occurred : (RLB)percent value= " + val + nfe.getMessage());
                    }
                }
            }
            if (!key.equalsIgnoreCase("flag") || val == null) continue;
            if (val.equalsIgnoreCase("good")) {
                flag = 1;
                continue;
            }
            if (val.equalsIgnoreCase("violating")) {
                flag = 3;
                continue;
            }
            if (val.equalsIgnoreCase("NO_DATA")) {
                flag = 4;
                continue;
            }
            if (val.equalsIgnoreCase("UNKNOWN")) {
                flag = 2;
                continue;
            }
            if (!val.equalsIgnoreCase("BLOCKED")) continue;
            flag = 5;
        }
        icc.processDatabaseInstances();
    }

    protected void cleanupFCFThreads(OracleImplicitConnectionCache oicc) throws SQLException {
        this.cleanupFCFWorkerThread(oicc);
        oicc.cleanupRLBThreads();
        if (this.failoverEnabledCacheCount <= 0) {
            this.cleanupFCFEventHandlerThread();
        }
        --this.failoverEnabledCacheCount;
    }

    /*
     * WARNING - void declaration
     */
    protected void cleanupFCFWorkerThread(OracleImplicitConnectionCache oracleImplicitConnectionCache) throws SQLException {
        void oicc;
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (oicc.failoverWorkerThread != null) {
            block4: {
                try {
                    if (oicc.failoverWorkerThread.isAlive()) {
                        oicc.failoverWorkerThread.join();
                    }
                }
                catch (InterruptedException e2) {
                    if (!bl) break block4;
                    this.debug($$$loggerRef$$$22, Level.FINEST, $$$methodRef$$$22, "OracleConnectionCacheManager.cleanupFCFWorkerThread() - Exception occurred:" + e2.getMessage());
                }
            }
            oicc.failoverWorkerThread = null;
        }
    }

    protected void cleanupFCFEventHandlerThread() throws SQLException {
        boolean bl;
        boolean bl2 = bl = (0L & TraceControllerImpl.feature) != 0L;
        if (this.failoverEventHandlerThread != null) {
            block3: {
                try {
                    this.failoverEventHandlerThread.interrupt();
                }
                catch (Exception e2) {
                    if (!bl) break block3;
                    this.debug($$$loggerRef$$$23, Level.FINEST, $$$methodRef$$$23, "OracleConnectionCacheManager.cleanupFCFEventHandlerThread() - Exception occurred:" + e2.getMessage());
                }
            }
            this.failoverEventHandlerThread = null;
        }
    }

    public boolean isFatalConnectionError(SQLException se) {
        boolean retCode = false;
        int errCode = se.getErrorCode();
        if (errCode == 3113 || errCode == 3114 || errCode == 1033 || errCode == 1034 || errCode == 1089 || errCode == 1090 || errCode == 17002) {
            retCode = true;
        }
        if (!retCode && this.fatalErrorCodes != null) {
            for (int i2 = 0; i2 < this.fatalErrorCodes.length; ++i2) {
                if (errCode != this.fatalErrorCodes[i2]) continue;
                retCode = true;
                break;
            }
        }
        return retCode;
    }

    public synchronized void setConnectionErrorCodes(int[] fatalErrorCodes) throws SQLException {
        if (fatalErrorCodes != null) {
            this.fatalErrorCodes = fatalErrorCodes;
        }
    }

    public int[] getConnectionErrorCodes() throws SQLException {
        return this.fatalErrorCodes;
    }

    public Map getStatistics(String cacheName) throws SQLException {
        Map map = null;
        OracleImplicitConnectionCache icc = null;
        if (this.m_connCache != null && (icc = (OracleImplicitConnectionCache)this.m_connCache.get(cacheName)) != null) {
            map = icc.getStatistics();
        }
        return map;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable method, String msg) {
        ClioSupport.log(logger, level, this.getClass(), method, msg);
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.pool");
        }
        return LOGGER;
    }

    static {
        try {
            $$$methodRef$$$30 = OracleConnectionCacheManager.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$30 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$29 = OracleConnectionCacheManager.class.getDeclaredMethod("logger", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$29 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$28 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = OracleConnectionCacheManager.class.getDeclaredMethod("getStatistics", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionErrorCodes", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleConnectionCacheManager.class.getDeclaredMethod("setConnectionErrorCodes", int[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleConnectionCacheManager.class.getDeclaredMethod("isFatalConnectionError", SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFEventHandlerThread", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFWorkerThread", OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleConnectionCacheManager.class.getDeclaredMethod("cleanupFCFThreads", OracleImplicitConnectionCache.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleConnectionCacheManager.class.getDeclaredMethod("retrieveServiceMetrics", OracleImplicitConnectionCache.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleConnectionCacheManager.class.getDeclaredMethod("parseRuntimeLoadBalancingEvent", String.class, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleConnectionCacheManager.class.getDeclaredMethod("failoverEnabledCacheExists", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleConnectionCacheManager.class.getDeclaredMethod("checkAndStartThread", Thread.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleConnectionCacheManager.class.getDeclaredMethod("invokeFailoverProcessingThreads", Integer.TYPE, String.class, String.class, String.class, String.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleConnectionCacheManager.class.getDeclaredMethod("verifyAndHandleEvent", Integer.TYPE, byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleConnectionCacheManager.class.getDeclaredMethod("setConnectionPoolDataSource", String.class, ConnectionPoolDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleConnectionCacheManager.class.getDeclaredMethod("getNumberOfActiveConnections", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleConnectionCacheManager.class.getDeclaredMethod("getNumberOfAvailableConnections", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleConnectionCacheManager.class.getDeclaredMethod("getCacheNameList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleConnectionCacheManager.class.getDeclaredMethod("getCacheProperties", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleConnectionCacheManager.class.getDeclaredMethod("purgeCache", String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleConnectionCacheManager.class.getDeclaredMethod("refreshCache", String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleConnectionCacheManager.class.getDeclaredMethod("disableCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleConnectionCacheManager.class.getDeclaredMethod("enableCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleConnectionCacheManager.class.getDeclaredMethod("existsCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleConnectionCacheManager.class.getDeclaredMethod("reinitializeCache", String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleConnectionCacheManager.class.getDeclaredMethod("removeCache", String.class, Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleConnectionCacheManager.class.getDeclaredMethod("createCache", String.class, OracleDataSource.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleConnectionCacheManager.class.getDeclaredMethod("createCache", OracleDataSource.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleConnectionCacheManager.class.getDeclaredMethod("getConnectionCacheManagerInstance", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        cacheManagerInstance = null;
        isONSInitializedForRemoteSubscription = false;
        _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.pool.OracleConnectionCacheManager"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

