/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFJMSConnection;
import oracle.jdbc.driver.NTFJMSRegistration;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public class NTFJMSConnectionGroup {
    ArrayList<NTFJMSConnection> jmsListenerConnections;
    private HashMap<Long, Integer> jmsRegIdToJDBCRegId;
    private int noOfRegistrationsInThisGroup;
    String uniqueIdentifier;
    static final int DEFAULT_MAX_NTF_CONNECTIONS = 16;
    private static int MAX_NTF_CONNECTIONS;
    private int aliveConnections;
    private HashMap<Long, NTFJMSRegistration> jmsRegIdToNtfReg;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    public static synchronized void setMaxNtfConnection(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            int maxConn;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, n2);
            }
            if (maxConn <= 0) {
                maxConn = 16;
            }
            if (MAX_NTF_CONNECTIONS > 0) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null);
                    ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, null);
                }
                return;
            }
            MAX_NTF_CONNECTIONS = maxConn;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$0, null, throwable2);
            }
            throw throwable;
        }
    }

    public static int getMaxNtfConnection() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, new Object[0]);
            }
            if (MAX_NTF_CONNECTIONS == 0) {
                int n2 = 16;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, n2);
                    ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, null);
                }
                return 16;
            }
            int n3 = MAX_NTF_CONNECTIONS;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, n3);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, null);
            }
            return n3;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$1, null, throwable2);
            }
            throw throwable;
        }
    }

    NTFJMSConnectionGroup(String uniqueIdentifier) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, null, uniqueIdentifier);
            }
            this.jmsListenerConnections = new ArrayList();
            this.jmsRegIdToJDBCRegId = new HashMap();
            this.noOfRegistrationsInThisGroup = 0;
            this.aliveConnections = 0;
            this.jmsRegIdToNtfReg = new HashMap();
            this.uniqueIdentifier = uniqueIdentifier;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void checkForActiveRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, new Object[0]);
            }
            if (this.noOfRegistrationsInThisGroup == 0) {
                if (!this.jmsListenerConnections.isEmpty()) {
                    for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                        if (listenerConnection == null) continue;
                        listenerConnection.setNeedToBeClosed(true);
                        listenerConnection.interrupt();
                        listenerConnection.closeThisListener();
                        --this.aliveConnections;
                    }
                    this.jmsListenerConnections.clear();
                }
                PhysicalConnection.ntfManager.removeJMSConnectionGroup(this.uniqueIdentifier);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void startJMSListenerConnection(String string, String string2, String string3, String string4, ArrayList<String> arrayList, String string5, int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void numberOfRegistrations;
            void password;
            void userName;
            void serviceName;
            void instanceName;
            void listenerAddresses;
            void jmsConnectionId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, string, string2, string3, string4, arrayList, string5, n2);
            }
            if (!$assertionsDisabled && jmsConnectionId == null) {
                AssertionError assertionError = new AssertionError((Object)"jmsConnectionId is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            String connClass = "notify" + (String)jmsConnectionId;
            NTFJMSConnection jmsListenerConnection = new NTFJMSConnection((String)jmsConnectionId, (ArrayList<String>)listenerAddresses, (String)instanceName, (String)serviceName, (String)userName, (String)password, connClass, (int)numberOfRegistrations);
            this.jmsListenerConnections.add(jmsListenerConnection);
            jmsListenerConnection.setDaemon(true);
            jmsListenerConnection.start();
            ++this.aliveConnections;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void decrementNumberOfRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, new Object[0]);
            }
            --this.noOfRegistrationsInThisGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized NTFJMSConnection getNTFJMSConnection(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void numberOfNewRegistrations;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, n2);
            }
            this.noOfRegistrationsInThisGroup += numberOfNewRegistrations;
            if (this.noOfRegistrationsInThisGroup > NTFJMSConnectionGroup.getMaxNtfConnection()) {
                int minimumRegistrations = this.noOfRegistrationsInThisGroup;
                NTFJMSConnection connectionWithMinimumRegistrations = this.jmsListenerConnections.get(0);
                for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                    int numberOfRegistrationsInConnection = listenerConnection.getNumberOfRegistrations();
                    if (numberOfRegistrationsInConnection >= minimumRegistrations) continue;
                    connectionWithMinimumRegistrations = listenerConnection;
                    minimumRegistrations = numberOfRegistrationsInConnection;
                }
                connectionWithMinimumRegistrations.incrementNumberOfRegistrations((int)numberOfNewRegistrations);
                NTFJMSConnection nTFJMSConnection = connectionWithMinimumRegistrations;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, nTFJMSConnection);
                    ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, null);
                }
                return nTFJMSConnection;
            }
            NTFJMSConnection nTFJMSConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, nTFJMSConnection);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void resetRegistrationNumbers(int n2, NTFJMSConnection nTFJMSConnection) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void ntfJMSConnection;
            void nbOfRegistration;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, n2, nTFJMSConnection);
            }
            this.noOfRegistrationsInThisGroup -= nbOfRegistration;
            if (ntfJMSConnection != null) {
                ntfJMSConnection.decrementNumberOfRegistrations((int)nbOfRegistration);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    synchronized void raiseException() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, new Object[0]);
            }
            --this.aliveConnections;
            if (this.aliveConnections == 0) {
                NTFJMSRegistration ntfReg = null;
                Iterator<Long> regIdIter = this.jmsRegIdToNtfReg.keySet().iterator();
                while (regIdIter.hasNext()) {
                    ntfReg = this.jmsRegIdToNtfReg.get(regIdIter.next());
                    try {
                        ntfReg.raiseException(1);
                    }
                    catch (Exception exception) {}
                }
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addNtfRegistrationByRegId(long l2, NTFJMSRegistration nTFJMSRegistration) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void ntfReg;
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, l2, nTFJMSRegistration);
            }
            this.jmsRegIdToNtfReg.put((long)jmsRegId, (NTFJMSRegistration)ntfReg);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFJMSRegistration getNtfRegistrationByRegId(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, l2);
            }
            NTFJMSRegistration nTFJMSRegistration = this.jmsRegIdToNtfReg.get((long)jmsRegId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, nTFJMSRegistration);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, null);
            }
            return nTFJMSRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    NTFJMSRegistration removeNtfRegistrationByRegId(long l2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsRegId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, l2);
            }
            NTFJMSRegistration nTFJMSRegistration = this.jmsRegIdToNtfReg.remove((long)jmsRegId);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, nTFJMSRegistration);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, null);
            }
            return nTFJMSRegistration;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized void stopNTFJMSConnection(String string) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void jmsConnectionId;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, string);
            }
            if (jmsConnectionId == null || jmsConnectionId.length() == 0) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this);
                    ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, null);
                }
                return;
            }
            for (NTFJMSConnection listenerConnection : this.jmsListenerConnections) {
                if (listenerConnection == null || !jmsConnectionId.equals(listenerConnection.getJMSConnectionId())) continue;
                listenerConnection.decrementNumberOfRegistrations(1);
                if (listenerConnection.getNumberOfRegistrations() > 0) break;
                listenerConnection.setNeedToBeClosed(true);
                break;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnectionGroup.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = NTFJMSConnectionGroup.class.getDeclaredConstructor(String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSConnectionGroup.class.getDeclaredMethod("stopNTFJMSConnection", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnectionGroup.class.getDeclaredMethod("removeNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNtfRegistrationByRegId", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnectionGroup.class.getDeclaredMethod("addNtfRegistrationByRegId", Long.TYPE, NTFJMSRegistration.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnectionGroup.class.getDeclaredMethod("raiseException", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnectionGroup.class.getDeclaredMethod("resetRegistrationNumbers", Integer.TYPE, NTFJMSConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnectionGroup.class.getDeclaredMethod("getNTFJMSConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnectionGroup.class.getDeclaredMethod("decrementNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnectionGroup.class.getDeclaredMethod("startJMSListenerConnection", String.class, String.class, String.class, String.class, ArrayList.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnectionGroup.class.getDeclaredMethod("checkForActiveRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnectionGroup.class.getDeclaredMethod("getMaxNtfConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnectionGroup.class.getDeclaredMethod("setMaxNtfConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        MAX_NTF_CONNECTIONS = 0;
    }
}

