/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.LongRawAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CLongRawAccessor
extends LongRawAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    byte[][] data = null;
    int[] nbBytesRead = null;
    int[] bytesReadSoFar = null;
    private T4CMarshaller marshaller = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;

    T4CLongRawAccessor(OracleStatement oracleStatement, int n2, int n3, short s2, int n4, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, s2, n4);
        this.mare = t4CMAREngine;
        if (oracleStatement.isFetchStreams) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    T4CLongRawAccessor(OracleStatement oracleStatement, int n2, int n3, boolean bl, int n4, int n5, int n6, long l2, int n7, short s2, int n8, int n9, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, n3, bl, n4, n5, n6, l2, n7, s2);
        this.mare = t4CMAREngine;
        if (oracleStatement != null && oracleStatement.implicitDefineForLobPrefetchDone) {
            this.definedColumnType = 0;
            this.definedColumnSize = 0;
        } else {
            this.definedColumnType = n8;
            this.definedColumnSize = n9;
        }
        if (oracleStatement.isFetchStreams) {
            this.data = new byte[oracleStatement.rowPrefetch][];
            for (int i2 = 0; i2 < oracleStatement.rowPrefetch; ++i2) {
                this.data[i2] = new byte[4080];
            }
            this.nbBytesRead = new int[oracleStatement.rowPrefetch];
            this.bytesReadSoFar = new int[oracleStatement.rowPrefetch];
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer11);
    }

    @Override
    void fetchNextColumns() throws SQLException {
        this.statement.continueReadRow(this.columnPosition);
    }

    @Override
    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        int n3 = this.lastRowProcessed;
        if (this.statement.isFetchStreams) {
            int n4 = this.bytesReadSoFar[n3];
            int n5 = this.getLength(n3);
            if (n4 == n5) {
                return -1;
            }
            int n6 = 0;
            n6 = n2 <= n5 - n4 ? n2 : n5 - n4;
            this.rowData.setPosition(this.getOffset(n3) + (long)n4);
            this.rowData.getBytes(byArray, 0, n6);
            int n7 = n3;
            this.bytesReadSoFar[n7] = this.bytesReadSoFar[n7] + n6;
            return n6;
        }
        int n8 = this.readStreamFromWire(byArray, 0, n2, this.escapeSequenceArr, this.readHeaderArr, this.readAsNonStreamArr, this.mare, ((T4CConnection)this.statement.connection).oer);
        if (this.statement.connection.checksumMode.needToCalculateFetchChecksum() && n8 != -1) {
            long l2;
            this.statement.checkSum = l2 = CRC64.updateChecksum(this.statement.checkSum, byArray, 0, n8);
        }
        return n8;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 23 ? T4CMarshaller.RAW : T4CMarshaller.LONG_RAW;
        }
        return this.marshaller;
    }

    @Override
    boolean isNullByDescribe() {
        return false;
    }

    @Override
    String getString(int n2) throws SQLException {
        String string = super.getString(n2);
        if (string != null && this.definedColumnSize > 0 && string.length() > this.definedColumnSize * 2) {
            string = string.substring(0, this.definedColumnSize * 2);
        }
        return string;
    }

    @Override
    long updateChecksum(long l2, int n2) throws SQLException {
        if (this.isNull(n2)) {
            l2 = CRC64.updateChecksum(l2, NULL_DATA_BYTES, 0, NULL_DATA_BYTES.length);
        }
        return l2;
    }

    static {
        try {
            $$$methodRef$$$15 = T4CLongRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = T4CLongRawAccessor.class.getDeclaredConstructor(OracleStatement.class, Integer.TYPE, Integer.TYPE, Short.TYPE, Integer.TYPE, T4CMAREngine.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = T4CLongRawAccessor.class.getDeclaredMethod("updateChecksum", Long.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = T4CLongRawAccessor.class.getDeclaredMethod("getString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = T4CLongRawAccessor.class.getDeclaredMethod("isNullByDescribe", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = T4CLongRawAccessor.class.getDeclaredMethod("getMarshaller", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = T4CLongRawAccessor.class.getDeclaredMethod("copyRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = T4CLongRawAccessor.class.getDeclaredMethod("readStream", byte[].class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = T4CLongRawAccessor.class.getDeclaredMethod("fetchNextColumns", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = T4CLongRawAccessor.class.getDeclaredMethod("readStreamFromWire", byte[].class, Integer.TYPE, Integer.TYPE, int[].class, boolean[].class, boolean[].class, T4CMAREngine.class, T4CTTIoer11.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = T4CLongRawAccessor.class.getDeclaredMethod("unmarshalOneRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = T4CLongRawAccessor.class.getDeclaredMethod("reinitForResultSetCache", ByteArray.class, OracleStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = T4CLongRawAccessor.class.getDeclaredMethod("getPreviousRowProcessed", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = T4CLongRawAccessor.class.getDeclaredMethod("processIndicator", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = T4CLongRawAccessor.class.getDeclaredMethod("unmarshalColumnMetadata", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = T4CLongRawAccessor.class.getDeclaredMethod("getMAREngine", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

