/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import oracle.dms.util.Name;
import oracle.dms.util.ObjectUtils;

public class NameSupport
implements Name {
    protected String m_name;
    private static final long serialVersionUID = -1150676494331L;

    protected NameSupport() {
        this.m_name = null;
    }

    protected NameSupport(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("name=" + name);
        }
        this.m_name = name;
    }

    @Override
    public final String getName() {
        return this.m_name;
    }

    @Override
    public int compareTo(Name obj) {
        if (obj == null) {
            return 1;
        }
        String name = obj.getName();
        return this.getName().compareTo(name);
    }

    public boolean equals(Object o) {
        boolean retVal = false;
        if (this == o) {
            retVal = true;
        } else if (o instanceof NameSupport) {
            NameSupport that = (NameSupport)o;
            retVal = ObjectUtils.areEqual(this.m_name, that.m_name);
        }
        return retVal;
    }

    public int hashCode() {
        int retVal = 0;
        if (this.m_name != null) {
            retVal = this.m_name.hashCode();
        }
        return retVal;
    }

    public void appendNameHeader(StringBuilder buf) {
        if (buf == null) {
            return;
        }
        NameSupport.appendNameHeader(this.m_name, buf);
    }

    public static void appendNameHeader(String name, StringBuilder buf) {
        int i;
        if (name == null || name.trim().length() == 0 || buf == null) {
            return;
        }
        int len = name.length();
        for (i = 0; i < len; ++i) {
            buf.append('-');
        }
        buf.append('\n');
        buf.append(name);
        buf.append('\n');
        for (i = 0; i < len; ++i) {
            buf.append('-');
        }
        buf.append('\n');
    }
}

